/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.builder;

import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirFunctionTarget;
import org.jetbrains.kotlin.fir.FirLabel;
import org.jetbrains.kotlin.fir.FirLoopTarget;
import org.jetbrains.kotlin.fir.FirPsiSourceElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.FirSourceElementKt;
import org.jetbrains.kotlin.fir.FirTargetElement;
import org.jetbrains.kotlin.fir.builder.Context;
import org.jetbrains.kotlin.fir.builder.ConversionUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberFunction;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.declarations.impl.FirErrorFunctionImpl;
import org.jetbrains.kotlin.fir.diagnostics.DiagnosticKind;
import org.jetbrains.kotlin.fir.diagnostics.FirSimpleDiagnostic;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirConstKind;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirLoop;
import org.jetbrains.kotlin.fir.expressions.FirOperation;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccess;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirReturnExpression;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.impl.FirAbstractLoop;
import org.jetbrains.kotlin.fir.expressions.impl.FirAbstractLoopJump;
import org.jetbrains.kotlin.fir.expressions.impl.FirArraySetCallImpl;
import org.jetbrains.kotlin.fir.expressions.impl.FirBlockImpl;
import org.jetbrains.kotlin.fir.expressions.impl.FirConstExpressionImpl;
import org.jetbrains.kotlin.fir.expressions.impl.FirErrorExpressionImpl;
import org.jetbrains.kotlin.fir.expressions.impl.FirFunctionCallImpl;
import org.jetbrains.kotlin.fir.expressions.impl.FirModifiableQualifiedAccess;
import org.jetbrains.kotlin.fir.expressions.impl.FirOperatorCallImpl;
import org.jetbrains.kotlin.fir.expressions.impl.FirReturnExpressionImpl;
import org.jetbrains.kotlin.fir.expressions.impl.FirStringConcatenationCallImpl;
import org.jetbrains.kotlin.fir.expressions.impl.FirVariableAssignmentImpl;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.impl.FirErrorNamedReferenceImpl;
import org.jetbrains.kotlin.fir.references.impl.FirExplicitThisReference;
import org.jetbrains.kotlin.fir.references.impl.FirSimpleNamedReference;
import org.jetbrains.kotlin.fir.symbols.AbstractFirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.CallableId;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirErrorFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.impl.ConeClassLikeTypeImpl;
import org.jetbrains.kotlin.fir.types.impl.ConeTypeParameterTypeImpl;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitBuiltinTypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirResolvedTypeRefImpl;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.resolve.constants.evaluate.ParseUtilsKt;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u00f0\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 t*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001tB\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010#\u001a\u00020$J\u0018\u0010%\u001a\u00020$2\u0006\u0010&\u001a\u00020'2\b\b\u0002\u0010(\u001a\u00020)J\u0013\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00028\u0000\u00a2\u0006\u0002\u0010-JH\u0010.\u001a\u00020+2\b\u0010/\u001a\u0004\u0018\u0001002\b\u00101\u001a\u0004\u0018\u00018\u00002\u0006\u00102\u001a\u00020'2\u0006\u00103\u001a\u00020)2\u0017\u00104\u001a\u0013\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020+05\u00a2\u0006\u0002\b6\u00a2\u0006\u0002\u00107J\u0014\u00108\u001a\b\u0012\u0004\u0012\u00020:092\u0006\u0010;\u001a\u00020<J*\u0010=\u001a\u0002H\u0001\"\u0004\b\u0001\u0010\u00012\u0006\u0010&\u001a\u00020'2\f\u0010>\u001a\b\u0012\u0004\u0012\u0002H\u00010?H\u0086\b\u00a2\u0006\u0002\u0010@J\u0017\u0010A\u001a\u00020B*\u00020B2\u0006\u0010,\u001a\u00028\u0000\u00a2\u0006\u0002\u0010CJ\u0018\u0010D\u001a\u00020E*\u00020E2\f\u0010F\u001a\b\u0012\u0004\u0012\u00020G0?JD\u0010H\u001a\u00020I*\u0004\u0018\u00018\u00002\b\u0010J\u001a\u0004\u0018\u00010K2\u0006\u0010L\u001a\u00020+2\u0006\u0010M\u001a\u00020N2\u0017\u00104\u001a\u0013\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020+05\u00a2\u0006\u0002\b6\u00a2\u0006\u0002\u0010OJ\u001b\u0010P\u001a\u0004\u0018\u00018\u0000*\u00028\u00002\u0006\u0010Q\u001a\u00020\u001bH&\u00a2\u0006\u0002\u0010RJ\u0013\u0010S\u001a\u0004\u0018\u00018\u0000*\u00028\u0000H&\u00a2\u0006\u0002\u0010 J\u0013\u0010T\u001a\u0004\u0018\u00010\u0017*\u00028\u0000H&\u00a2\u0006\u0002\u0010\u0019J\u0011\u0010U\u001a\u00020'*\u00028\u0000H&\u00a2\u0006\u0002\u0010VJ\u0019\u0010W\u001a\u0004\u0018\u00010K\"\u0004\b\u0001\u0010\u0001*\u0002H\u0001H\u0002\u00a2\u0006\u0002\u0010XJ6\u0010Y\u001a\u00020Z*\u00020[2\b\u0010\\\u001a\u0004\u0018\u00018\u00002\u0019\u0010]\u001a\u0015\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00010^05\u00a2\u0006\u0002\b6H\u0002\u00a2\u0006\u0002\u0010_J\u001d\u0010`\u001a\u0004\u0018\u0001H\u0001\"\u0004\b\u0001\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010a\u00a2\u0006\u0002\u0010bJ\u0016\u0010c\u001a\u00020d\"\u0004\b\u0001\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010aJ\u0014\u0010e\u001a\u00020<*\u0004\u0018\u00010f2\u0006\u0010g\u001a\u00020hJD\u0010i\u001a\u00020+*\f\u0012\b\b\u0001\u0012\u0004\u0018\u00018\u00000j2\b\u0010k\u001a\u0004\u0018\u00010l2\u001f\u0010m\u001a\u001b\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020+0n\u00a2\u0006\u0002\b6\u00a2\u0006\u0002\u0010oJ\"\u0010p\u001a\u00020q*\u00020+2\n\b\u0002\u0010r\u001a\u0004\u0018\u00010K2\n\b\u0002\u0010s\u001a\u0004\u0018\u00010\u0017R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0014\u0010\u0010\u001a\u00020\u000bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\rR\u0014\u0010\u0012\u001a\u00020\u000bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\rR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0016\u0010\u0016\u001a\u00020\u0017*\u00028\u0000X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0016\u0010\u001a\u001a\u00020\u001b*\u00028\u0000X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u0004\u0018\u00018\u0000*\u0004\u0018\u00018\u0000X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0016\u0010!\u001a\u00020\u0017*\u00028\u0000X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0019\u00a8\u0006u"}, d2={"Lorg/jetbrains/kotlin/fir/builder/BaseFirBuilder;", "T", "", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "context", "Lorg/jetbrains/kotlin/fir/builder/Context;", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/builder/Context;)V", "getContext", "()Lorg/jetbrains/kotlin/fir/builder/Context;", "implicitAnnotationType", "Lorg/jetbrains/kotlin/fir/types/impl/FirImplicitBuiltinTypeRef;", "getImplicitAnnotationType", "()Lorg/jetbrains/kotlin/fir/types/impl/FirImplicitBuiltinTypeRef;", "implicitAnyType", "getImplicitAnyType", "implicitEnumType", "getImplicitEnumType", "implicitUnitType", "getImplicitUnitType", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "asText", "", "getAsText", "(Ljava/lang/Object;)Ljava/lang/String;", "elementType", "Lcom/intellij/psi/tree/IElementType;", "getElementType", "(Ljava/lang/Object;)Lcom/intellij/psi/tree/IElementType;", "selectorExpression", "getSelectorExpression", "(Ljava/lang/Object;)Ljava/lang/Object;", "unescapedValue", "getUnescapedValue", "callableIdForClassConstructor", "Lorg/jetbrains/kotlin/fir/symbols/CallableId;", "callableIdForName", "name", "Lorg/jetbrains/kotlin/name/Name;", "local", "", "generateConstantExpressionByLiteral", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "expression", "(Ljava/lang/Object;)Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "generateIncrementOrDecrementBlock", "baseExpression", "Lorg/jetbrains/kotlin/psi/KtUnaryExpression;", "argument", "callName", "prefix", "convert", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "(Lorg/jetbrains/kotlin/psi/KtUnaryExpression;Ljava/lang/Object;Lorg/jetbrains/kotlin/name/Name;ZLkotlin/jvm/functions/Function1;)Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "typeParametersFromSelfType", "", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeParameter;", "delegatedSelfTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "withChildClassName", "l", "Lkotlin/Function0;", "(Lorg/jetbrains/kotlin/name/Name;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "bindLabel", "Lorg/jetbrains/kotlin/fir/expressions/impl/FirAbstractLoopJump;", "(Lorg/jetbrains/kotlin/fir/expressions/impl/FirAbstractLoopJump;Ljava/lang/Object;)Lorg/jetbrains/kotlin/fir/expressions/impl/FirAbstractLoopJump;", "configure", "Lorg/jetbrains/kotlin/fir/expressions/impl/FirAbstractLoop;", "generateBlock", "Lorg/jetbrains/kotlin/fir/expressions/FirBlock;", "generateAssignment", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "source", "Lorg/jetbrains/kotlin/fir/FirSourceElement;", "value", "operation", "Lorg/jetbrains/kotlin/fir/expressions/FirOperation;", "(Ljava/lang/Object;Lorg/jetbrains/kotlin/fir/FirSourceElement;Lorg/jetbrains/kotlin/fir/expressions/FirExpression;Lorg/jetbrains/kotlin/fir/expressions/FirOperation;Lkotlin/jvm/functions/Function1;)Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "getChildNodeByType", "type", "(Ljava/lang/Object;Lcom/intellij/psi/tree/IElementType;)Ljava/lang/Object;", "getExpressionInParentheses", "getLabelName", "getReferencedNameAsName", "(Ljava/lang/Object;)Lorg/jetbrains/kotlin/name/Name;", "getSourceOrNull", "(Ljava/lang/Object;)Lorg/jetbrains/kotlin/fir/FirSourceElement;", "initializeLValue", "Lorg/jetbrains/kotlin/fir/references/FirReference;", "Lorg/jetbrains/kotlin/fir/expressions/impl/FirModifiableQualifiedAccess;", "left", "convertQualified", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccess;", "(Lorg/jetbrains/kotlin/fir/expressions/impl/FirModifiableQualifiedAccess;Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)Lorg/jetbrains/kotlin/fir/references/FirReference;", "pop", "", "(Ljava/util/List;)Ljava/lang/Object;", "removeLast", "", "toDelegatedSelfType", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "firClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "toInterpolatingCall", "", "base", "Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;", "convertTemplateEntry", "Lkotlin/Function2;", "([Ljava/lang/Object;Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;Lkotlin/jvm/functions/Function2;)Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "toReturn", "Lorg/jetbrains/kotlin/fir/expressions/FirReturnExpression;", "baseSource", "labelName", "Companion", "psi2fir"})
public abstract class BaseFirBuilder<T> {
    @NotNull
    private final FirImplicitBuiltinTypeRef implicitUnitType;
    @NotNull
    private final FirImplicitBuiltinTypeRef implicitAnyType;
    @NotNull
    private final FirImplicitBuiltinTypeRef implicitEnumType;
    @NotNull
    private final FirImplicitBuiltinTypeRef implicitAnnotationType;
    @NotNull
    private final FirSession session;
    @NotNull
    private final Context context;
    @NotNull
    private static final Name KNPE;
    @NotNull
    private static final Name ANONYMOUS_OBJECT_NAME;
    public static final Companion Companion;

    @NotNull
    protected final FirImplicitBuiltinTypeRef getImplicitUnitType() {
        return this.implicitUnitType;
    }

    @NotNull
    protected final FirImplicitBuiltinTypeRef getImplicitAnyType() {
        return this.implicitAnyType;
    }

    @NotNull
    protected final FirImplicitBuiltinTypeRef getImplicitEnumType() {
        return this.implicitEnumType;
    }

    @NotNull
    protected final FirImplicitBuiltinTypeRef getImplicitAnnotationType() {
        return this.implicitAnnotationType;
    }

    @NotNull
    public abstract IElementType getElementType(T var1);

    @NotNull
    public abstract String getAsText(T var1);

    @NotNull
    public abstract String getUnescapedValue(T var1);

    @NotNull
    public abstract Name getReferencedNameAsName(T var1);

    @Nullable
    public abstract String getLabelName(T var1);

    @Nullable
    public abstract T getExpressionInParentheses(T var1);

    @Nullable
    public abstract T getChildNodeByType(T var1, @NotNull IElementType var2);

    @Nullable
    public abstract T getSelectorExpression(@Nullable T var1);

    public final <T> T withChildClassName(@NotNull Name name, @NotNull Function0<? extends T> l) {
        int $i$f$withChildClassName = 0;
        Intrinsics.checkParameterIsNotNull(name, "name");
        Intrinsics.checkParameterIsNotNull(l, "l");
        Context context2 = this.getContext();
        FqName fqName2 = this.getContext().getClassName().child(name);
        Intrinsics.checkExpressionValueIsNotNull(fqName2, "context.className.child(name)");
        context2.setClassName(fqName2);
        T t = l.invoke();
        Context context3 = this.getContext();
        FqName fqName3 = this.getContext().getClassName().parent();
        Intrinsics.checkExpressionValueIsNotNull(fqName3, "context.className.parent()");
        context3.setClassName(fqName3);
        return t;
    }

    @NotNull
    public final CallableId callableIdForName(@NotNull Name name, boolean local2) {
        CallableId callableId;
        Intrinsics.checkParameterIsNotNull(name, "name");
        if (local2) {
            callableId = new CallableId(name);
        } else if (Intrinsics.areEqual(this.context.getClassName(), FqName.ROOT)) {
            callableId = new CallableId(this.context.getPackageFqName(), name);
        } else if (this.context.getClassName().shortName() == ANONYMOUS_OBJECT_NAME) {
            FqName fqName2 = FqName.ROOT;
            Intrinsics.checkExpressionValueIsNotNull(fqName2, "FqName.ROOT");
            callableId = new CallableId(fqName2, new FqName("anonymous"), name);
        } else {
            callableId = new CallableId(this.context.getPackageFqName(), this.context.getClassName(), name);
        }
        return callableId;
    }

    public static /* synthetic */ CallableId callableIdForName$default(BaseFirBuilder baseFirBuilder, Name name, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: callableIdForName");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        return baseFirBuilder.callableIdForName(name, bl);
    }

    @NotNull
    public final CallableId callableIdForClassConstructor() {
        CallableId callableId;
        if (Intrinsics.areEqual(this.context.getClassName(), FqName.ROOT)) {
            FqName fqName2 = this.context.getPackageFqName();
            Name name = Name.special("<anonymous-init>");
            Intrinsics.checkExpressionValueIsNotNull(name, "Name.special(\"<anonymous-init>\")");
            callableId = new CallableId(fqName2, name);
        } else {
            FqName fqName3 = this.context.getPackageFqName();
            FqName fqName4 = this.context.getClassName();
            Name name = this.context.getClassName().shortName();
            Intrinsics.checkExpressionValueIsNotNull(name, "context.className.shortName()");
            callableId = new CallableId(fqName3, fqName4, name);
        }
        return callableId;
    }

    public final <T> void removeLast(@NotNull List<T> $this$removeLast) {
        Intrinsics.checkParameterIsNotNull($this$removeLast, "$this$removeLast");
        $this$removeLast.remove($this$removeLast.size() - 1);
    }

    @Nullable
    public final <T> T pop(@NotNull List<T> $this$pop) {
        Intrinsics.checkParameterIsNotNull($this$pop, "$this$pop");
        T result2 = CollectionsKt.lastOrNull($this$pop);
        if (result2 != null) {
            $this$pop.remove($this$pop.size() - 1);
        }
        return result2;
    }

    @NotNull
    public final FirReturnExpression toReturn(@NotNull FirExpression $this$toReturn, @Nullable FirSourceElement baseSource, @Nullable String labelName) {
        FirReturnExpressionImpl firReturnExpressionImpl;
        block9: {
            Intrinsics.checkParameterIsNotNull($this$toReturn, "$this$toReturn");
            firReturnExpressionImpl = new FirReturnExpressionImpl(baseSource, $this$toReturn);
            boolean bl = false;
            boolean bl2 = false;
            FirReturnExpressionImpl $this$apply = firReturnExpressionImpl;
            boolean bl3 = false;
            $this$apply.setTarget(new FirFunctionTarget(labelName));
            if (labelName == null) {
                FirFunction<?> firFunction;
                block8: {
                    List<FirFunction<?>> $this$lastOrNull$iv = this.context.getFirFunctions();
                    boolean $i$f$lastOrNull = false;
                    ListIterator<FirFunction<?>> iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
                    while (iterator$iv.hasPrevious()) {
                        FirFunction<?> element$iv;
                        FirFunction<?> it = element$iv = iterator$iv.previous();
                        boolean bl4 = false;
                        if (!(!(it instanceof FirAnonymousFunction) || !((FirAnonymousFunction)it).isLambda())) continue;
                        firFunction = element$iv;
                        break block8;
                    }
                    firFunction = null;
                }
                FirFunction lastFunction = firFunction;
                if (lastFunction != null) {
                    $this$apply.getTarget().bind((FirFunction<?>)((FirTargetElement)lastFunction));
                } else {
                    $this$apply.getTarget().bind((FirFunction<?>)((FirTargetElement)new FirErrorFunctionImpl($this$apply.getSource(), this.session, new FirSimpleDiagnostic("Cannot bind unlabeled return to a function", DiagnosticKind.ReturnNotAllowed), new FirErrorFunctionSymbol())));
                }
            } else {
                for (FirFunction<?> firFunction : CollectionsKt.asReversedMutable(this.context.getFirFunctions())) {
                    FirFunction<?> firFunction2 = firFunction;
                    if (firFunction2 instanceof FirAnonymousFunction) {
                        FirLabel firLabel = ((FirAnonymousFunction)firFunction).getLabel();
                        if (!Intrinsics.areEqual(firLabel != null ? firLabel.getName() : null, labelName)) continue;
                        $this$apply.getTarget().bind((FirFunction<?>)((FirTargetElement)firFunction));
                    } else {
                        if (!(firFunction2 instanceof FirMemberFunction) || !Intrinsics.areEqual(((FirMemberFunction)firFunction).getName().asString(), labelName)) continue;
                        $this$apply.getTarget().bind((FirFunction<?>)((FirTargetElement)firFunction));
                    }
                    break block9;
                }
                $this$apply.getTarget().bind((FirFunction<?>)((FirTargetElement)new FirErrorFunctionImpl($this$apply.getSource(), this.session, new FirSimpleDiagnostic("Cannot bind label " + labelName + " to a function", DiagnosticKind.UnresolvedLabel), new FirErrorFunctionSymbol())));
            }
        }
        return firReturnExpressionImpl;
    }

    public static /* synthetic */ FirReturnExpression toReturn$default(BaseFirBuilder baseFirBuilder, FirExpression firExpression2, FirSourceElement firSourceElement, String string2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: toReturn");
        }
        if ((n & 1) != 0) {
            firSourceElement = firExpression2.getSource();
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        return baseFirBuilder.toReturn(firExpression2, firSourceElement, string2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final FirTypeRef toDelegatedSelfType(@Nullable KtClassOrObject $this$toDelegatedSelfType, @NotNull FirRegularClass firClass) {
        void $this$toTypedArray$iv;
        Collection<ConeTypeParameterTypeImpl> collection;
        void $this$mapTo$iv$iv;
        Collection $this$map$iv;
        FirPsiSourceElement firPsiSourceElement;
        FirSourceElement firSourceElement;
        Object $this$toFirSourceElement$iv;
        Intrinsics.checkParameterIsNotNull(firClass, "firClass");
        KtClassOrObject ktClassOrObject = $this$toDelegatedSelfType;
        if (ktClassOrObject != null) {
            $this$toFirSourceElement$iv = ktClassOrObject;
            boolean $i$f$toFirSourceElement = false;
            firPsiSourceElement = firSourceElement = new FirPsiSourceElement((PsiElement)$this$toFirSourceElement$iv);
        } else {
            firPsiSourceElement = null;
        }
        $this$toFirSourceElement$iv = firClass.getTypeParameters();
        ConeClassLikeLookupTag coneClassLikeLookupTag = firClass.getSymbol().toLookupTag();
        firSourceElement = firPsiSourceElement;
        boolean $i$f$map = false;
        void var5_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FirTypeParameter firTypeParameter = (FirTypeParameter)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            ConeTypeParameterTypeImpl coneTypeParameterTypeImpl = new ConeTypeParameterTypeImpl(it.getSymbol().toLookupTag(), false);
            collection.add(coneTypeParameterTypeImpl);
        }
        collection = (List)destination$iv$iv;
        $this$map$iv = collection;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        ConeTypeParameterTypeImpl[] coneTypeParameterTypeImplArray = thisCollection$iv.toArray(new ConeTypeParameterTypeImpl[0]);
        if (coneTypeParameterTypeImplArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        collection = coneTypeParameterTypeImplArray;
        boolean bl = false;
        ConeKotlinTypeProjection[] coneKotlinTypeProjectionArray = (ConeKotlinTypeProjection[])collection;
        ConeClassLikeLookupTag coneClassLikeLookupTag2 = coneClassLikeLookupTag;
        ConeKotlinType coneKotlinType = new ConeClassLikeTypeImpl(coneClassLikeLookupTag2, coneKotlinTypeProjectionArray, bl);
        FirSourceElement firSourceElement2 = firSourceElement;
        return new FirResolvedTypeRefImpl(firSourceElement2, coneKotlinType);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<FirTypeParameter> typeParametersFromSelfType(@NotNull FirTypeRef delegatedSelfTypeRef) {
        List list2;
        ConeKotlinTypeProjection[] coneKotlinTypeProjectionArray;
        Intrinsics.checkParameterIsNotNull(delegatedSelfTypeRef, "delegatedSelfTypeRef");
        FirTypeRef $this$coneTypeSafe$iv = delegatedSelfTypeRef;
        boolean $i$f$coneTypeSafe = false;
        FirTypeRef firTypeRef = $this$coneTypeSafe$iv;
        if (!(firTypeRef instanceof FirResolvedTypeRef)) {
            firTypeRef = null;
        }
        FirResolvedTypeRef firResolvedTypeRef = (FirResolvedTypeRef)firTypeRef;
        Object object = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
        if (!(object instanceof ConeKotlinType)) {
            object = coneKotlinTypeProjectionArray = null;
        }
        if (object != null && (coneKotlinTypeProjectionArray = coneKotlinTypeProjectionArray.getTypeArguments()) != null) {
            void $this$mapTo$iv$iv;
            ConeKotlinTypeProjection[] $this$map$iv = coneKotlinTypeProjectionArray;
            boolean $i$f$map = false;
            ConeKotlinTypeProjection[] coneKotlinTypeProjectionArray2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            void var7_7 = $this$mapTo$iv$iv;
            int n = ((void)var7_7).length;
            for (int i = 0; i < n; ++i) {
                void it;
                void item$iv$iv;
                void var11_11 = item$iv$iv = var7_7[i];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                void v4 = it;
                if (v4 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeTypeParameterType");
                }
                FirClassifierSymbol<?> firClassifierSymbol = ((ConeTypeParameterType)v4).getLookupTag().getSymbol();
                if (firClassifierSymbol == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol");
                }
                FirTypeParameter firTypeParameter = (FirTypeParameter)((FirTypeParameterSymbol)firClassifierSymbol).getFir();
                collection.add(firTypeParameter);
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    @NotNull
    public final FirAbstractLoop configure(@NotNull FirAbstractLoop $this$configure, @NotNull Function0<? extends FirBlock> generateBlock) {
        Intrinsics.checkParameterIsNotNull($this$configure, "$this$configure");
        Intrinsics.checkParameterIsNotNull(generateBlock, "generateBlock");
        $this$configure.setLabel(this.pop(this.context.getFirLabels()));
        Collection collection = this.context.getFirLoops();
        boolean bl = false;
        collection.add($this$configure);
        $this$configure.setBlock(generateBlock.invoke());
        this.removeLast(this.context.getFirLoops());
        return $this$configure;
    }

    @NotNull
    public final FirAbstractLoopJump bindLabel(@NotNull FirAbstractLoopJump $this$bindLabel, T expression2) {
        Intrinsics.checkParameterIsNotNull($this$bindLabel, "$this$bindLabel");
        String labelName = this.getLabelName(expression2);
        $this$bindLabel.setTarget(new FirLoopTarget(labelName));
        FirLoop lastLoop = CollectionsKt.lastOrNull(this.context.getFirLoops());
        if (labelName == null) {
            if (lastLoop != null) {
                $this$bindLabel.getTarget().bind((FirLoop)((FirTargetElement)lastLoop));
            } else {
                $this$bindLabel.getTarget().bind((FirLoop)((FirTargetElement)FirExpressionUtilKt.FirErrorLoop(this.getSourceOrNull(expression2), new FirSimpleDiagnostic("Cannot bind unlabeled jump to a loop", DiagnosticKind.Syntax))));
            }
        } else {
            for (FirLoop firLoop : CollectionsKt.asReversedMutable(this.context.getFirLoops())) {
                FirLabel firLabel = firLoop.getLabel();
                if (!Intrinsics.areEqual(firLabel != null ? firLabel.getName() : null, labelName)) continue;
                $this$bindLabel.getTarget().bind((FirLoop)((FirTargetElement)firLoop));
                return $this$bindLabel;
            }
            $this$bindLabel.getTarget().bind((FirLoop)((FirTargetElement)FirExpressionUtilKt.FirErrorLoop(this.getSourceOrNull(expression2), new FirSimpleDiagnostic("Cannot bind label " + labelName + " to a loop", DiagnosticKind.Syntax))));
        }
        return $this$bindLabel;
    }

    private final <T> FirSourceElement getSourceOrNull(T $this$getSourceOrNull) {
        return $this$getSourceOrNull instanceof PsiElement ? new FirPsiSourceElement((PsiElement)$this$getSourceOrNull) : null;
    }

    @NotNull
    public final FirExpression generateConstantExpressionByLiteral(T expression2) {
        FirExpression firExpression2;
        IElementType type2 = this.getElementType(expression2);
        String text2 = this.getAsText(expression2);
        IElementType iElementType = type2;
        Serializable convertedText = Intrinsics.areEqual(iElementType, KtNodeTypes.INTEGER_CONSTANT) || Intrinsics.areEqual(iElementType, KtNodeTypes.FLOAT_CONSTANT) ? (Serializable)ParseUtilsKt.parseNumericLiteral(text2, type2) : (Intrinsics.areEqual(iElementType, KtNodeTypes.BOOLEAN_CONSTANT) ? (Serializable)Boolean.valueOf(ParseUtilsKt.parseBoolean(text2)) : null);
        iElementType = type2;
        if (Intrinsics.areEqual(iElementType, KtNodeTypes.INTEGER_CONSTANT)) {
            if (!(convertedText instanceof Long)) {
                return new FirErrorExpressionImpl(this.getSourceOrNull(expression2), new FirSimpleDiagnostic("Incorrect constant expression: " + text2, DiagnosticKind.IllegalConstExpression));
            }
            FirConstKind kind = ParseUtilsKt.hasLongSuffix(text2) || ParseUtilsKt.hasUnsignedSuffix(text2) || ParseUtilsKt.hasUnsignedLongSuffix(text2) ? (FirConstKind)FirConstKind.Long.INSTANCE : (FirConstKind)FirConstKind.IntegerLiteral.INSTANCE;
            firExpression2 = FirExpressionUtilKt.FirConstExpressionImpl(this.getSourceOrNull(expression2), kind, convertedText, new FirSimpleDiagnostic("Incorrect integer literal: " + text2, DiagnosticKind.Syntax));
        } else if (Intrinsics.areEqual(iElementType, KtNodeTypes.FLOAT_CONSTANT)) {
            if (convertedText instanceof Float) {
                firExpression2 = FirExpressionUtilKt.FirConstExpressionImpl(this.getSourceOrNull(expression2), FirConstKind.Float.INSTANCE, convertedText, new FirSimpleDiagnostic("Incorrect float: " + text2, DiagnosticKind.Syntax));
            } else {
                Serializable serializable = convertedText;
                if (serializable == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Double");
                }
                firExpression2 = FirExpressionUtilKt.FirConstExpressionImpl(this.getSourceOrNull(expression2), FirConstKind.Double.INSTANCE, (Double)serializable, new FirSimpleDiagnostic("Incorrect double: " + text2, DiagnosticKind.Syntax));
            }
        } else if (Intrinsics.areEqual(iElementType, KtNodeTypes.CHARACTER_CONSTANT)) {
            firExpression2 = FirExpressionUtilKt.FirConstExpressionImpl(this.getSourceOrNull(expression2), FirConstKind.Char.INSTANCE, ConversionUtilsKt.parseCharacter(text2), new FirSimpleDiagnostic("Incorrect character: " + text2, DiagnosticKind.Syntax));
        } else if (Intrinsics.areEqual(iElementType, KtNodeTypes.BOOLEAN_CONSTANT)) {
            Serializable serializable = convertedText;
            if (serializable == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Boolean");
            }
            firExpression2 = new FirConstExpressionImpl<Boolean>(this.getSourceOrNull(expression2), FirConstKind.Boolean.INSTANCE, (Boolean)serializable);
        } else if (Intrinsics.areEqual(iElementType, KtNodeTypes.NULL)) {
            firExpression2 = new FirConstExpressionImpl<Object>(this.getSourceOrNull(expression2), FirConstKind.Null.INSTANCE, null);
        } else {
            throw (Throwable)((Object)new AssertionError((Object)("Unknown literal type: " + type2 + ", " + text2)));
        }
        return firExpression2;
    }

    @NotNull
    public final FirExpression toInterpolatingCall(@NotNull T[] $this$toInterpolatingCall, @Nullable KtStringTemplateExpression base, @NotNull Function2<? super T, ? super String, ? extends FirExpression> convertTemplateEntry) {
        FirExpression firExpression2;
        Intrinsics.checkParameterIsNotNull($this$toInterpolatingCall, "$this$toInterpolatingCall");
        Intrinsics.checkParameterIsNotNull(convertTemplateEntry, "convertTemplateEntry");
        StringBuilder sb = new StringBuilder();
        boolean hasExpressions = false;
        FirExpression result2 = null;
        boolean callCreated = false;
        for (T entry : $this$toInterpolatingCall) {
            Object object;
            boolean bl;
            FirElement firElement;
            Object $this$apply;
            FirElement firElement2;
            FirElement firElement3;
            Object object2;
            if (entry == null || Intrinsics.areEqual(object2 = this.getElementType(entry), KtTokens.OPEN_QUOTE) || Intrinsics.areEqual(object2, KtTokens.CLOSING_QUOTE)) continue;
            if (Intrinsics.areEqual(object2, KtNodeTypes.LITERAL_STRING_TEMPLATE_ENTRY)) {
                sb.append(this.getAsText(entry));
                firElement3 = new FirConstExpressionImpl<String>(this.getSourceOrNull(entry), FirConstKind.String.INSTANCE, this.getAsText(entry));
            } else if (Intrinsics.areEqual(object2, KtNodeTypes.ESCAPE_STRING_TEMPLATE_ENTRY)) {
                sb.append(this.getUnescapedValue(entry));
                firElement3 = new FirConstExpressionImpl<String>(this.getSourceOrNull(entry), FirConstKind.String.INSTANCE, this.getUnescapedValue(entry));
            } else if (Intrinsics.areEqual(object2, KtNodeTypes.SHORT_STRING_TEMPLATE_ENTRY) || Intrinsics.areEqual(object2, KtNodeTypes.LONG_STRING_TEMPLATE_ENTRY)) {
                hasExpressions = true;
                FirExpression firExpression3 = convertTemplateEntry.invoke(entry, "Incorrect template argument");
                FirSourceElement source = firExpression3.getSource();
                FirFunctionCallImpl firFunctionCallImpl = new FirFunctionCallImpl(source);
                boolean bl2 = false;
                boolean bl3 = false;
                FirFunctionCallImpl $this$apply2 = firFunctionCallImpl;
                boolean bl4 = false;
                $this$apply2.setExplicitReceiver(firExpression3);
                Name name = Name.identifier("toString");
                Intrinsics.checkExpressionValueIsNotNull(name, "Name.identifier(\"toString\")");
                $this$apply2.setCalleeReference(new FirSimpleNamedReference(source, name, null));
                firElement3 = firFunctionCallImpl;
            } else {
                hasExpressions = true;
                firElement3 = new FirErrorExpressionImpl(this.getSourceOrNull(entry), new FirSimpleDiagnostic("Incorrect template entry: " + this.getAsText(entry), DiagnosticKind.Syntax));
            }
            FirElement nextArgument = firElement3;
            if (result2 == null) {
                firElement2 = nextArgument;
            } else if (callCreated && result2 instanceof FirStringConcatenationCallImpl) {
                object2 = result2;
                boolean firExpression3 = false;
                boolean bl5 = false;
                $this$apply = (FirStringConcatenationCallImpl)object2;
                boolean bl6 = false;
                Collection collection = ((FirStringConcatenationCallImpl)$this$apply).getArguments();
                firElement = nextArgument;
                bl = false;
                collection.add(firElement);
                object = object2;
                firElement2 = (FirElement)object;
            } else {
                FirPsiSourceElement firPsiSourceElement;
                callCreated = true;
                KtStringTemplateExpression ktStringTemplateExpression = base;
                if (ktStringTemplateExpression != null) {
                    FirPsiSourceElement firPsiSourceElement2;
                    PsiElement $this$toFirSourceElement$iv = ktStringTemplateExpression;
                    boolean $i$f$toFirSourceElement = false;
                    firPsiSourceElement = firPsiSourceElement2 = new FirPsiSourceElement($this$toFirSourceElement$iv);
                } else {
                    firPsiSourceElement = null;
                }
                FirSourceElement firSourceElement = firPsiSourceElement;
                object2 = new FirStringConcatenationCallImpl(firSourceElement);
                boolean bl7 = false;
                boolean bl8 = false;
                $this$apply = object2;
                boolean bl9 = false;
                Collection collection = ((FirStringConcatenationCallImpl)$this$apply).getArguments();
                FirExpression firExpression4 = result2;
                if (firExpression4 == null) {
                    Intrinsics.throwNpe();
                }
                firElement = firExpression4;
                bl = false;
                collection.add(firElement);
                collection = ((FirStringConcatenationCallImpl)$this$apply).getArguments();
                firElement = nextArgument;
                bl = false;
                collection.add(firElement);
                object = object2;
                firElement2 = (FirElement)object;
            }
            result2 = (FirExpression)firElement2;
        }
        if (hasExpressions) {
            firExpression2 = result2;
            if (firExpression2 == null) {
                Intrinsics.throwNpe();
            }
        } else {
            FirPsiSourceElement firPsiSourceElement;
            KtStringTemplateExpression ktStringTemplateExpression = base;
            if (ktStringTemplateExpression != null) {
                FirPsiSourceElement firPsiSourceElement3;
                PsiElement $this$toFirSourceElement$iv = ktStringTemplateExpression;
                boolean $i$f$toFirSourceElement = false;
                firPsiSourceElement = firPsiSourceElement3 = new FirPsiSourceElement($this$toFirSourceElement$iv);
            } else {
                firPsiSourceElement = null;
            }
            FirSourceElement firSourceElement = firPsiSourceElement;
            FirConstKind firConstKind = FirConstKind.String.INSTANCE;
            String string2 = sb.toString();
            Intrinsics.checkExpressionValueIsNotNull(string2, "sb.toString()");
            String string3 = string2;
            FirConstKind firConstKind2 = firConstKind;
            FirSourceElement firSourceElement2 = firSourceElement;
            firExpression2 = new FirConstExpressionImpl<String>(firSourceElement2, firConstKind2, string3);
        }
        return firExpression2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final FirExpression generateIncrementOrDecrementBlock(@Nullable KtUnaryExpression baseExpression, @Nullable T argument, @NotNull Name callName, boolean prefix, @NotNull Function1<? super T, ? extends FirExpression> convert) {
        Collection collection;
        FirPsiSourceElement firPsiSourceElement;
        FirPsiSourceElement firPsiSourceElement2;
        Intrinsics.checkParameterIsNotNull(callName, "callName");
        Intrinsics.checkParameterIsNotNull(convert, "convert");
        if (argument == null) {
            return new FirErrorExpressionImpl((FirSourceElement)argument, new FirSimpleDiagnostic("Inc/dec without operand", DiagnosticKind.Syntax));
        }
        KtUnaryExpression ktUnaryExpression = baseExpression;
        if (ktUnaryExpression != null) {
            PsiElement $this$toFirSourceElement$iv = ktUnaryExpression;
            boolean $i$f$toFirSourceElement = false;
            firPsiSourceElement2 = new FirPsiSourceElement($this$toFirSourceElement$iv);
        } else {
            firPsiSourceElement2 = null;
        }
        FirPsiSourceElement source = firPsiSourceElement2;
        FirBlockImpl firBlockImpl = new FirBlockImpl(source);
        boolean bl = false;
        boolean bl2 = false;
        FirBlockImpl $this$apply = firBlockImpl;
        boolean bl3 = false;
        Name name = Name.special("<unary>");
        Intrinsics.checkExpressionValueIsNotNull(name, "Name.special(\"<unary>\")");
        Name tempName = name;
        FirVariable<?> temporaryVariable = ConversionUtilsKt.generateTemporaryVariable(this.session, (FirSourceElement)source, tempName, convert.invoke(argument));
        Collection collection2 = $this$apply.getStatements();
        boolean bl4 = false;
        collection2.add(temporaryVariable);
        Name name2 = Name.special("<unary-result>");
        Intrinsics.checkExpressionValueIsNotNull(name2, "Name.special(\"<unary-result>\")");
        Name resultName = name2;
        FirFunctionCallImpl firFunctionCallImpl = new FirFunctionCallImpl(source);
        boolean bl5 = false;
        boolean bl6 = false;
        FirFunctionCallImpl $this$apply2 = firFunctionCallImpl;
        boolean bl7 = false;
        FirFunctionCallImpl firFunctionCallImpl2 = $this$apply2;
        KtExpression ktExpression = baseExpression;
        if (ktExpression != null && (ktExpression = ktExpression.getOperationReference()) != null) {
            void $this$toFirSourceElement$iv;
            PsiElement psiElement = ktExpression;
            FirFunctionCallImpl firFunctionCallImpl3 = firFunctionCallImpl2;
            boolean $i$f$toFirSourceElement = false;
            FirPsiSourceElement firPsiSourceElement3 = new FirPsiSourceElement((PsiElement)$this$toFirSourceElement$iv);
            firFunctionCallImpl2 = firFunctionCallImpl3;
            firPsiSourceElement = firPsiSourceElement3;
        } else {
            firPsiSourceElement = null;
        }
        AbstractFirBasedSymbol<?> abstractFirBasedSymbol = null;
        Name name3 = callName;
        FirSourceElement firSourceElement = firPsiSourceElement;
        firFunctionCallImpl2.setCalleeReference(new FirSimpleNamedReference(firSourceElement, name3, abstractFirBasedSymbol));
        $this$apply2.setExplicitReceiver(ConversionUtilsKt.generateResolvedAccessExpression(source, temporaryVariable));
        FirFunctionCallImpl resultInitializer = firFunctionCallImpl;
        FirVariable<?> resultVar = ConversionUtilsKt.generateTemporaryVariable(this.session, (FirSourceElement)source, resultName, (FirExpression)resultInitializer);
        FirStatement assignment = this.generateAssignment(argument, source, prefix && Intrinsics.areEqual(this.getElementType(argument), KtNodeTypes.REFERENCE_EXPRESSION) ^ true ? ConversionUtilsKt.generateResolvedAccessExpression(source, resultVar) : (FirQualifiedAccessExpression)resultInitializer, FirOperation.ASSIGN, convert);
        Function0<Unit> $fun$appendAssignment$1 = new Function0<Unit>($this$apply, assignment){
            final /* synthetic */ FirBlockImpl $this_apply;
            final /* synthetic */ FirStatement $assignment;

            public final void invoke() {
                if (this.$assignment instanceof FirBlock) {
                    Collection collection = this.$this_apply.getStatements();
                    Iterable iterable = ((FirBlock)this.$assignment).getStatements();
                    boolean bl = false;
                    CollectionsKt.addAll(collection, iterable);
                } else {
                    Collection collection = this.$this_apply.getStatements();
                    FirStatement firStatement = this.$assignment;
                    boolean bl = false;
                    collection.add(firStatement);
                }
            }
            {
                this.$this_apply = firBlockImpl;
                this.$assignment = firStatement;
                super(0);
            }
        };
        if (prefix) {
            if (Intrinsics.areEqual(this.getElementType(argument), KtNodeTypes.REFERENCE_EXPRESSION) ^ true) {
                collection = $this$apply.getStatements();
                boolean bl8 = false;
                collection.add(resultVar);
                $fun$appendAssignment$1.invoke();
                collection = $this$apply.getStatements();
                FirQualifiedAccessExpression firQualifiedAccessExpression = ConversionUtilsKt.generateResolvedAccessExpression(source, resultVar);
                boolean bl9 = false;
                collection.add(firQualifiedAccessExpression);
            } else {
                $fun$appendAssignment$1.invoke();
                collection = $this$apply.getStatements();
                FirQualifiedAccessExpression firQualifiedAccessExpression = ConversionUtilsKt.generateAccessExpression(source, this.getReferencedNameAsName(argument));
                boolean bl10 = false;
                collection.add(firQualifiedAccessExpression);
            }
        } else {
            $fun$appendAssignment$1.invoke();
            collection = $this$apply.getStatements();
            FirQualifiedAccessExpression firQualifiedAccessExpression = ConversionUtilsKt.generateResolvedAccessExpression(source, temporaryVariable);
            boolean bl11 = false;
            collection.add(firQualifiedAccessExpression);
        }
        return firBlockImpl;
    }

    private final FirReference initializeLValue(@NotNull FirModifiableQualifiedAccess $this$initializeLValue, T left, Function1<? super T, ? extends FirQualifiedAccess> convertQualified) {
        IElementType tokenType;
        T t = left;
        IElementType iElementType = tokenType = t != null ? this.getElementType(t) : null;
        if (left != null) {
            IElementType iElementType2 = tokenType;
            if (Intrinsics.areEqual(iElementType2, KtNodeTypes.REFERENCE_EXPRESSION)) {
                return new FirSimpleNamedReference(this.getSourceOrNull(left), this.getReferencedNameAsName(left), null);
            }
            if (Intrinsics.areEqual(iElementType2, KtNodeTypes.THIS_EXPRESSION)) {
                return new FirExplicitThisReference(this.getSourceOrNull(left), this.getLabelName(left));
            }
            if (Intrinsics.areEqual(iElementType2, KtNodeTypes.DOT_QUALIFIED_EXPRESSION) || Intrinsics.areEqual(iElementType2, KtNodeTypes.SAFE_ACCESS_EXPRESSION)) {
                FirReference firReference;
                FirQualifiedAccess firMemberAccess = convertQualified.invoke(left);
                if (firMemberAccess != null) {
                    $this$initializeLValue.setExplicitReceiver(firMemberAccess.getExplicitReceiver());
                    $this$initializeLValue.setSafe(firMemberAccess.getSafe());
                    firReference = firMemberAccess.getCalleeReference();
                } else {
                    firReference = new FirErrorNamedReferenceImpl(this.getSourceOrNull(left), new FirSimpleDiagnostic("Unsupported qualified LValue: " + this.getAsText(left), DiagnosticKind.Syntax));
                }
                return firReference;
            }
            if (Intrinsics.areEqual(iElementType2, KtNodeTypes.PARENTHESIZED)) {
                return this.initializeLValue($this$initializeLValue, this.getExpressionInParentheses(left), convertQualified);
            }
        }
        return new FirErrorNamedReferenceImpl(this.getSourceOrNull(left), new FirSimpleDiagnostic("Unsupported LValue: " + tokenType, DiagnosticKind.Syntax));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final FirStatement generateAssignment(@Nullable T $this$generateAssignment, @Nullable FirSourceElement source, @NotNull FirExpression value2, @NotNull FirOperation operation, @NotNull Function1<? super T, ? extends FirExpression> convert) {
        IElementType tokenType;
        Intrinsics.checkParameterIsNotNull(value2, "value");
        Intrinsics.checkParameterIsNotNull((Object)operation, "operation");
        Intrinsics.checkParameterIsNotNull(convert, "convert");
        T t = $this$generateAssignment;
        IElementType iElementType = tokenType = t != null ? this.getElementType(t) : null;
        if (Intrinsics.areEqual(tokenType, KtNodeTypes.PARENTHESIZED)) {
            T t2 = $this$generateAssignment;
            if (t2 == null) {
                Intrinsics.throwNpe();
            }
            return this.generateAssignment(this.getExpressionInParentheses(t2), source, value2, operation, convert);
        }
        if (Intrinsics.areEqual(tokenType, KtNodeTypes.ARRAY_ACCESS_EXPRESSION)) {
            FirPsiSourceElement firPsiSourceElement;
            FirPsiSourceElement firPsiSourceElement2;
            PsiElement psiArrayExpression;
            T t3 = $this$generateAssignment;
            if (t3 == null) {
                Intrinsics.throwNpe();
            }
            FirExpression firExpression2 = convert.invoke(t3);
            if (firExpression2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.impl.FirFunctionCallImpl");
            }
            FirFunctionCallImpl firArrayAccess = (FirFunctionCallImpl)firExpression2;
            if (operation == FirOperation.ASSIGN) {
                FirFunctionCallImpl firFunctionCallImpl = firArrayAccess;
                boolean bl = false;
                boolean bl2 = false;
                FirFunctionCallImpl $this$apply2 = firFunctionCallImpl;
                boolean bl3 = false;
                $this$apply2.setCalleeReference(new FirSimpleNamedReference(source, OperatorNameConventions.SET, null));
                Collection collection = $this$apply2.getArguments();
                FirExpression firExpression3 = value2;
                boolean bl4 = false;
                collection.add(firExpression3);
                return firFunctionCallImpl;
            }
            FirArraySetCallImpl firArraySetCallImpl = new FirArraySetCallImpl(source, value2, operation);
            boolean bl = false;
            boolean bl5 = false;
            FirArraySetCallImpl $this$apply = firArraySetCallImpl;
            boolean bl6 = false;
            Collection collection = $this$apply.getIndexes();
            Iterable iterable = firArrayAccess.getArguments();
            boolean bl7 = false;
            CollectionsKt.addAll(collection, iterable);
            FirArraySetCallImpl arraySet = firArraySetCallImpl;
            IElementType iElementType2 = KtNodeTypes.REFERENCE_EXPRESSION;
            Intrinsics.checkExpressionValueIsNotNull(iElementType2, "REFERENCE_EXPRESSION");
            T arrayExpression = this.getChildNodeByType($this$generateAssignment, iElementType2);
            if (arrayExpression != null) {
                FirArraySetCallImpl firArraySetCallImpl2 = arraySet;
                bl5 = false;
                boolean $this$apply2 = false;
                FirArraySetCallImpl $this$apply3 = firArraySetCallImpl2;
                boolean bl8 = false;
                $this$apply3.setLValue(this.initializeLValue($this$apply3, arrayExpression, new Function1<T, FirQualifiedAccess>(this, arrayExpression, convert){
                    final /* synthetic */ BaseFirBuilder this$0;
                    final /* synthetic */ Object $arrayExpression$inlined;
                    final /* synthetic */ Function1 $convert$inlined;
                    {
                        this.this$0 = baseFirBuilder;
                        this.$arrayExpression$inlined = object;
                        this.$convert$inlined = function1;
                        super(1);
                    }

                    @Nullable
                    public final FirQualifiedAccess invoke(T $this$initializeLValue) {
                        R r = this.$convert$inlined.invoke($this$initializeLValue);
                        if (!(r instanceof FirQualifiedAccess)) {
                            r = null;
                        }
                        return (FirQualifiedAccess)r;
                    }
                }));
                return firArraySetCallImpl2;
            }
            FirExpression firExpression4 = firArrayAccess.getExplicitReceiver();
            PsiElement psiElement = psiArrayExpression = firExpression4 != null ? FirSourceElementKt.getPsi(firExpression4) : null;
            if (psiElement != null) {
                FirPsiSourceElement firPsiSourceElement3;
                PsiElement $this$toFirSourceElement$iv = psiElement;
                boolean $i$f$toFirSourceElement = false;
                firPsiSourceElement2 = firPsiSourceElement3 = new FirPsiSourceElement($this$toFirSourceElement$iv);
            } else {
                firPsiSourceElement2 = null;
            }
            FirSourceElement firSourceElement = firPsiSourceElement2;
            FirBlockImpl $this$toFirSourceElement$iv = new FirBlockImpl(firSourceElement);
            boolean bl9 = false;
            boolean bl10 = false;
            FirBlockImpl $this$apply4 = $this$toFirSourceElement$iv;
            boolean bl11 = false;
            Name name = Name.special("<array-set>");
            Intrinsics.checkExpressionValueIsNotNull(name, "Name.special(\"<array-set>\")");
            Name name2 = name;
            Collection collection2 = $this$apply4.getStatements();
            FirSourceElement firSourceElement2 = this.getSourceOrNull($this$generateAssignment);
            FirExpression firExpression5 = firArrayAccess.getExplicitReceiver();
            if (firExpression5 == null) {
                Intrinsics.throwNpe();
            }
            FirStatement firStatement = ConversionUtilsKt.generateTemporaryVariable(this.session, firSourceElement2, name2, firExpression5);
            boolean bl12 = false;
            collection2.add(firStatement);
            collection2 = $this$apply4.getStatements();
            firStatement = arraySet;
            bl12 = false;
            boolean bl13 = false;
            FirStatement $this$apply5 = firStatement;
            boolean bl14 = false;
            FirStatement firStatement2 = $this$apply5;
            PsiElement psiElement2 = psiArrayExpression;
            if (psiElement2 != null) {
                void $this$toFirSourceElement$iv2;
                PsiElement psiElement3 = psiElement2;
                FirStatement firStatement3 = firStatement2;
                boolean $i$f$toFirSourceElement = false;
                FirPsiSourceElement firPsiSourceElement4 = new FirPsiSourceElement((PsiElement)$this$toFirSourceElement$iv2);
                firStatement2 = firStatement3;
                firPsiSourceElement = firPsiSourceElement4;
            } else {
                firPsiSourceElement = null;
            }
            AbstractFirBasedSymbol<?> abstractFirBasedSymbol = null;
            Name name3 = name2;
            FirSourceElement firSourceElement3 = firPsiSourceElement;
            ((FirArraySetCallImpl)firStatement2).setLValue(new FirSimpleNamedReference(firSourceElement3, name3, abstractFirBasedSymbol));
            bl12 = false;
            collection2.add(firStatement);
            return $this$toFirSourceElement$iv;
        }
        if (FirOperation.Companion.getASSIGNMENTS().contains((Object)operation) && operation != FirOperation.ASSIGN) {
            FirOperatorCallImpl firOperatorCallImpl = new FirOperatorCallImpl(source, operation);
            boolean bl = false;
            boolean bl15 = false;
            FirOperatorCallImpl $this$apply6 = firOperatorCallImpl;
            boolean bl16 = false;
            Collection collection = $this$apply6.getArguments();
            Object object = $this$generateAssignment;
            if (object == null || (object = convert.invoke(object)) == null) {
                Object object2;
                object = new FirErrorExpressionImpl(null, new FirSimpleDiagnostic("Unsupported left value of assignment: " + ((object2 = source) != null && (object2 = FirSourceElementKt.getPsi((FirSourceElement)object2)) != null ? object2.getText() : null), DiagnosticKind.Syntax));
            }
            Object object3 = object;
            boolean bl17 = false;
            collection.add(object3);
            collection = $this$apply6.getArguments();
            object3 = value2;
            bl17 = false;
            collection.add(object3);
            return firOperatorCallImpl;
        }
        boolean bl = operation == FirOperation.ASSIGN;
        boolean bl18 = false;
        boolean bl19 = false;
        bl19 = false;
        boolean $this$apply6 = false;
        if (!bl) {
            boolean bl16 = false;
            String $this$apply6 = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException($this$apply6.toString());
        }
        FirVariableAssignmentImpl firVariableAssignmentImpl = new FirVariableAssignmentImpl(source, false, value2);
        bl18 = false;
        bl19 = false;
        FirVariableAssignmentImpl $this$apply7 = firVariableAssignmentImpl;
        boolean bl20 = false;
        $this$apply7.setLValue(this.initializeLValue($this$apply7, $this$generateAssignment, new Function1<T, FirQualifiedAccess>(this, $this$generateAssignment, convert){
            final /* synthetic */ BaseFirBuilder this$0;
            final /* synthetic */ Object $this_generateAssignment$inlined;
            final /* synthetic */ Function1 $convert$inlined;
            {
                this.this$0 = baseFirBuilder;
                this.$this_generateAssignment$inlined = object;
                this.$convert$inlined = function1;
                super(1);
            }

            @Nullable
            public final FirQualifiedAccess invoke(T $this$initializeLValue) {
                R r = this.$convert$inlined.invoke($this$initializeLValue);
                if (!(r instanceof FirQualifiedAccess)) {
                    r = null;
                }
                return (FirQualifiedAccess)r;
            }
        }));
        return firVariableAssignmentImpl;
    }

    @NotNull
    public final FirSession getSession() {
        return this.session;
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    public BaseFirBuilder(@NotNull FirSession session, @NotNull Context context2) {
        Intrinsics.checkParameterIsNotNull(session, "session");
        Intrinsics.checkParameterIsNotNull(context2, "context");
        this.session = session;
        this.context = context2;
        this.implicitUnitType = this.session.getBuiltinTypes().getUnitType();
        this.implicitAnyType = this.session.getBuiltinTypes().getAnyType();
        this.implicitEnumType = this.session.getBuiltinTypes().getEnumType();
        this.implicitAnnotationType = this.session.getBuiltinTypes().getAnnotationType();
    }

    public /* synthetic */ BaseFirBuilder(FirSession firSession, Context context2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            context2 = new Context();
        }
        this(firSession, context2);
    }

    static {
        Companion = new Companion(null);
        Name name = Name.identifier("KotlinNullPointerException");
        Intrinsics.checkExpressionValueIsNotNull(name, "Name.identifier(\"KotlinNullPointerException\")");
        KNPE = name;
        Name name2 = Name.special("<anonymous>");
        Intrinsics.checkExpressionValueIsNotNull(name2, "Name.special(\"<anonymous>\")");
        ANONYMOUS_OBJECT_NAME = name2;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/fir/builder/BaseFirBuilder$Companion;", "", "()V", "ANONYMOUS_OBJECT_NAME", "Lorg/jetbrains/kotlin/name/Name;", "getANONYMOUS_OBJECT_NAME", "()Lorg/jetbrains/kotlin/name/Name;", "KNPE", "getKNPE", "psi2fir"})
    public static final class Companion {
        @NotNull
        public final Name getKNPE() {
            return KNPE;
        }

        @NotNull
        public final Name getANONYMOUS_OBJECT_NAME() {
            return ANONYMOUS_OBJECT_NAME;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

