/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.scopes.impl;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirResolvedImport;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.calls.TowerScopeLevel;
import org.jetbrains.kotlin.fir.scopes.ProcessorAction;
import org.jetbrains.kotlin.fir.scopes.impl.FirAbstractImportingScope;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJD\u0010\u0011\u001a\u00020\u0012\"\f\b\u0000\u0010\u0013*\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010\u0015\u001a\u00020\u000b2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00130\u00172\u0016\u0010\u0018\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0014\u0012\u0004\u0012\u00020\u00120\u0019H\u0016J(\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u000b2\u0016\u0010\u0018\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001b\u0012\u0004\u0012\u00020\u00120\u0019H\u0016R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/fir/scopes/impl/FirAbstractStarImportingScope;", "Lorg/jetbrains/kotlin/fir/scopes/impl/FirAbstractImportingScope;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "lookupInFir", "", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;Z)V", "absentClassifierNames", "", "Lorg/jetbrains/kotlin/name/Name;", "starImports", "", "Lorg/jetbrains/kotlin/fir/declarations/FirResolvedImport;", "getStarImports", "()Ljava/util/List;", "processCallables", "Lorg/jetbrains/kotlin/fir/scopes/ProcessorAction;", "T", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "name", "token", "Lorg/jetbrains/kotlin/fir/resolve/calls/TowerScopeLevel$Token;", "processor", "Lkotlin/Function1;", "processClassifiersByName", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassifierSymbol;", "resolve"})
public abstract class FirAbstractStarImportingScope
extends FirAbstractImportingScope {
    private final Set<Name> absentClassifierNames;

    @NotNull
    protected abstract List<FirResolvedImport> getStarImports();

    @Override
    @NotNull
    public ProcessorAction processClassifiersByName(@NotNull Name name, @NotNull Function1<? super FirClassifierSymbol<?>, ? extends ProcessorAction> processor2) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        Intrinsics.checkParameterIsNotNull(processor2, "processor");
        if (this.getStarImports().isEmpty() || this.absentClassifierNames.contains(name)) {
            return ProcessorAction.NONE;
        }
        boolean empty = true;
        for (FirResolvedImport firResolvedImport : this.getStarImports()) {
            FirClassLikeSymbol<?> symbol2;
            ClassId classId;
            FqName relativeClassName = firResolvedImport.getRelativeClassName();
            if (!name.isSpecial()) {
                String string2 = name.getIdentifier();
                Intrinsics.checkExpressionValueIsNotNull(string2, "name.identifier");
                CharSequence charSequence = string2;
                boolean bl = false;
                if (charSequence.length() == 0) {
                    return ProcessorAction.NEXT;
                }
            }
            ClassId classId2 = classId = relativeClassName == null ? new ClassId(firResolvedImport.getPackageFqName(), name) : new ClassId(firResolvedImport.getPackageFqName(), relativeClassName.child(name), false);
            if (this.getProvider().getClassLikeSymbolByFqName(classId) == null) {
                continue;
            }
            empty = false;
            if (!processor2.invoke(symbol2).not()) continue;
            return ProcessorAction.STOP;
        }
        if (empty) {
            Collection collection = this.absentClassifierNames;
            boolean bl = false;
            collection.add(name);
        }
        return ProcessorAction.NEXT;
    }

    @Override
    @NotNull
    public <T extends FirCallableSymbol<?>> ProcessorAction processCallables(@NotNull Name name, @NotNull TowerScopeLevel.Token<? extends T> token, @NotNull Function1<? super FirCallableSymbol<?>, ? extends ProcessorAction> processor2) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        Intrinsics.checkParameterIsNotNull(token, "token");
        Intrinsics.checkParameterIsNotNull(processor2, "processor");
        if (this.getStarImports().isEmpty()) {
            return ProcessorAction.NONE;
        }
        for (FirResolvedImport firResolvedImport : this.getStarImports()) {
            if (!this.processCallables(firResolvedImport, name, token, processor2).stop()) continue;
            return ProcessorAction.STOP;
        }
        return ProcessorAction.NEXT;
    }

    public FirAbstractStarImportingScope(@NotNull FirSession session, @NotNull ScopeSession scopeSession, boolean lookupInFir) {
        Set set;
        Intrinsics.checkParameterIsNotNull(session, "session");
        Intrinsics.checkParameterIsNotNull(scopeSession, "scopeSession");
        super(session, scopeSession, lookupInFir);
        FirAbstractStarImportingScope firAbstractStarImportingScope = this;
        boolean bl = false;
        firAbstractStarImportingScope.absentClassifierNames = set = (Set)new LinkedHashSet();
    }

    public /* synthetic */ FirAbstractStarImportingScope(FirSession firSession, ScopeSession scopeSession, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = true;
        }
        this(firSession, scopeSession, bl);
    }
}

