/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.callTranslator;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.translate.callTranslator.CallInfoExtensionsKt;
import org.jetbrains.kotlin.js.translate.callTranslator.FunctionCallCase;
import org.jetbrains.kotlin.js.translate.callTranslator.FunctionCallCasesKt;
import org.jetbrains.kotlin.js.translate.callTranslator.FunctionCallInfo;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.TemporaryConstVariable;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.reference.CallArgumentTranslator;
import org.jetbrains.kotlin.js.translate.reference.ReferenceTranslator;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bJ.\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bJ\u0018\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J\f\u0010\u0013\u001a\u00020\u0004*\u00020\u0014H\u0014J\f\u0010\u0007\u001a\u00020\u0004*\u00020\u0014H\u0014J\f\u0010\u0015\u001a\u00020\u0004*\u00020\u0014H\u0014J\f\u0010\u0016\u001a\u00020\u0004*\u00020\u0014H\u0014\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/js/translate/callTranslator/DefaultFunctionCallCase;", "Lorg/jetbrains/kotlin/js/translate/callTranslator/FunctionCallCase;", "()V", "buildDefaultCallWithDispatchReceiver", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "argumentsInfo", "Lorg/jetbrains/kotlin/js/translate/reference/CallArgumentTranslator$ArgumentsInfo;", "dispatchReceiver", "functionName", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "isNative", "", "hasSpreadOperator", "buildDefaultCallWithoutReceiver", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "callableDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "nativeSpreadFunWithDispatchOrExtensionReceiver", "bothReceivers", "Lorg/jetbrains/kotlin/js/translate/callTranslator/FunctionCallInfo;", "extensionReceiver", "noReceivers", "js.translator"})
public final class DefaultFunctionCallCase
extends FunctionCallCase {
    public static final DefaultFunctionCallCase INSTANCE;

    private final JsExpression nativeSpreadFunWithDispatchOrExtensionReceiver(CallArgumentTranslator.ArgumentsInfo argumentsInfo, JsName functionName2) {
        TemporaryConstVariable temporaryConstVariable = argumentsInfo.getCachedReceiver();
        if (temporaryConstVariable == null) {
            Intrinsics.throwNpe();
        }
        TemporaryConstVariable cachedReceiver = temporaryConstVariable;
        JsNameRef jsNameRef = Namer.getFunctionApplyRef(new JsNameRef(functionName2, cachedReceiver.assignmentExpression()));
        Intrinsics.checkExpressionValueIsNotNull(jsNameRef, "Namer.getFunctionApplyRe\u2026.assignmentExpression()))");
        JsNameRef functionCallRef = jsNameRef;
        return new JsInvocation((JsExpression)functionCallRef, argumentsInfo.getTranslateArguments());
    }

    @NotNull
    public final JsExpression buildDefaultCallWithDispatchReceiver(@NotNull CallArgumentTranslator.ArgumentsInfo argumentsInfo, @NotNull JsExpression dispatchReceiver, @NotNull JsName functionName2, boolean isNative, boolean hasSpreadOperator) {
        Intrinsics.checkParameterIsNotNull(argumentsInfo, "argumentsInfo");
        Intrinsics.checkParameterIsNotNull(dispatchReceiver, "dispatchReceiver");
        Intrinsics.checkParameterIsNotNull(functionName2, "functionName");
        if (isNative && hasSpreadOperator) {
            return this.nativeSpreadFunWithDispatchOrExtensionReceiver(argumentsInfo, functionName2);
        }
        return new JsInvocation((JsExpression)JsAstUtils.pureFqn(functionName2, dispatchReceiver), argumentsInfo.getTranslateArguments());
    }

    @NotNull
    public final JsExpression buildDefaultCallWithoutReceiver(@NotNull TranslationContext context2, @NotNull CallArgumentTranslator.ArgumentsInfo argumentsInfo, @NotNull CallableDescriptor callableDescriptor, boolean isNative, boolean hasSpreadOperator) {
        Intrinsics.checkParameterIsNotNull(context2, "context");
        Intrinsics.checkParameterIsNotNull(argumentsInfo, "argumentsInfo");
        Intrinsics.checkParameterIsNotNull(callableDescriptor, "callableDescriptor");
        JsExpression jsExpression = ReferenceTranslator.translateAsValueReference(callableDescriptor, context2);
        Intrinsics.checkExpressionValueIsNotNull(jsExpression, "ReferenceTranslator.tran\u2026lableDescriptor, context)");
        JsExpression functionRef = jsExpression;
        if (isNative && hasSpreadOperator) {
            JsNameRef jsNameRef = Namer.getFunctionApplyRef(functionRef);
            Intrinsics.checkExpressionValueIsNotNull(jsNameRef, "Namer.getFunctionApplyRef(functionRef)");
            JsNameRef functionCallRef = jsNameRef;
            return new JsInvocation((JsExpression)functionCallRef, argumentsInfo.getTranslateArguments());
        }
        return new JsInvocation(functionRef, argumentsInfo.getTranslateArguments());
    }

    @Override
    @NotNull
    protected JsExpression noReceivers(@NotNull FunctionCallInfo $this$noReceivers) {
        Intrinsics.checkParameterIsNotNull($this$noReceivers, "$this$noReceivers");
        return this.buildDefaultCallWithoutReceiver($this$noReceivers.getContext(), $this$noReceivers.getArgumentsInfo(), CallInfoExtensionsKt.getCallableDescriptor($this$noReceivers), CallInfoExtensionsKt.isNative($this$noReceivers), CallInfoExtensionsKt.hasSpreadOperator($this$noReceivers));
    }

    @Override
    @NotNull
    protected JsExpression dispatchReceiver(@NotNull FunctionCallInfo $this$dispatchReceiver) {
        Intrinsics.checkParameterIsNotNull($this$dispatchReceiver, "$this$dispatchReceiver");
        CallArgumentTranslator.ArgumentsInfo argumentsInfo = $this$dispatchReceiver.getArgumentsInfo();
        JsExpression jsExpression = $this$dispatchReceiver.getDispatchReceiver();
        if (jsExpression == null) {
            Intrinsics.throwNpe();
        }
        return this.buildDefaultCallWithDispatchReceiver(argumentsInfo, jsExpression, CallInfoExtensionsKt.getFunctionName($this$dispatchReceiver), CallInfoExtensionsKt.isNative($this$dispatchReceiver), CallInfoExtensionsKt.hasSpreadOperator($this$dispatchReceiver));
    }

    @Override
    @NotNull
    protected JsExpression extensionReceiver(@NotNull FunctionCallInfo $this$extensionReceiver) {
        Intrinsics.checkParameterIsNotNull($this$extensionReceiver, "$this$extensionReceiver");
        if (CallInfoExtensionsKt.isNative($this$extensionReceiver) && CallInfoExtensionsKt.hasSpreadOperator($this$extensionReceiver)) {
            return this.nativeSpreadFunWithDispatchOrExtensionReceiver($this$extensionReceiver.getArgumentsInfo(), CallInfoExtensionsKt.getFunctionName($this$extensionReceiver));
        }
        if (CallInfoExtensionsKt.isNative($this$extensionReceiver)) {
            return new JsInvocation((JsExpression)new JsNameRef(CallInfoExtensionsKt.getFunctionName($this$extensionReceiver), $this$extensionReceiver.getExtensionReceiver()), $this$extensionReceiver.getArgumentsInfo().getTranslateArguments());
        }
        JsExpression jsExpression = ReferenceTranslator.translateAsValueReference(CallInfoExtensionsKt.getCallableDescriptor($this$extensionReceiver), $this$extensionReceiver.getContext());
        Intrinsics.checkExpressionValueIsNotNull(jsExpression, "ReferenceTranslator.tran\u2026lableDescriptor, context)");
        JsExpression functionRef = jsExpression;
        CallArgumentTranslator.ArgumentsInfo argumentsInfo = $this$extensionReceiver.getArgumentsInfo();
        JsExpression jsExpression2 = $this$extensionReceiver.getExtensionReceiver();
        if (jsExpression2 == null) {
            Intrinsics.throwNpe();
        }
        return new JsInvocation(functionRef, FunctionCallCasesKt.argsWithReceiver(argumentsInfo, jsExpression2));
    }

    @Override
    @NotNull
    protected JsExpression bothReceivers(@NotNull FunctionCallInfo $this$bothReceivers) {
        Intrinsics.checkParameterIsNotNull($this$bothReceivers, "$this$bothReceivers");
        JsName jsName = CallInfoExtensionsKt.getFunctionName($this$bothReceivers);
        JsExpression jsExpression = $this$bothReceivers.getDispatchReceiver();
        if (jsExpression == null) {
            Intrinsics.throwNpe();
        }
        JsNameRef jsNameRef = JsAstUtils.pureFqn(jsName, jsExpression);
        Intrinsics.checkExpressionValueIsNotNull(jsNameRef, "JsAstUtils.pureFqn(funct\u2026Name, dispatchReceiver!!)");
        JsNameRef functionRef = jsNameRef;
        JsExpression jsExpression2 = functionRef;
        CallArgumentTranslator.ArgumentsInfo argumentsInfo = $this$bothReceivers.getArgumentsInfo();
        JsExpression jsExpression3 = $this$bothReceivers.getExtensionReceiver();
        if (jsExpression3 == null) {
            Intrinsics.throwNpe();
        }
        return new JsInvocation(jsExpression2, FunctionCallCasesKt.argsWithReceiver(argumentsInfo, jsExpression3));
    }

    private DefaultFunctionCallCase() {
    }

    static {
        DefaultFunctionCallCase defaultFunctionCallCase;
        INSTANCE = defaultFunctionCallCase = new DefaultFunctionCallCase();
    }
}

