/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.module.id;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.module.id.MatcherLookup;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.module.id.ModuleId;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.module.id.ModuleRevisionId;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.plugins.matcher.MapMatcher;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.util.Checks;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.util.Message;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.util.filter.Filter;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.util.filter.NoFilter;

public class ModuleRules<T> {
    private Map<MapMatcher, T> rules = new LinkedHashMap<MapMatcher, T>();
    private MatcherLookup matcherLookup = new MatcherLookup();

    public ModuleRules() {
    }

    private ModuleRules(Map<MapMatcher, T> rules) {
        this.rules = new LinkedHashMap<MapMatcher, T>(rules);
        for (MapMatcher matcher : rules.keySet()) {
            this.matcherLookup.add(matcher);
        }
    }

    public void defineRule(MapMatcher condition, T rule) {
        Checks.checkNotNull(condition, "condition");
        Checks.checkNotNull(rule, "rule");
        this.rules.put(condition, rule);
        this.matcherLookup.add(condition);
    }

    public T getRule(ModuleId mid) {
        return this.getRule(mid, NoFilter.instance());
    }

    public List<T> getRules(ModuleId mid) {
        return this.getRules(mid.getAttributes(), NoFilter.instance());
    }

    public T getRule(ModuleRevisionId mrid) {
        return this.getRule(mrid, NoFilter.instance());
    }

    public T getRule(ModuleId mid, Filter<T> filter2) {
        Checks.checkNotNull(mid, "mid");
        return this.getRule(mid.getAttributes(), filter2);
    }

    public T getRule(ModuleRevisionId mrid, Filter<T> filter2) {
        Checks.checkNotNull(mrid, "mrid");
        Checks.checkNotNull(filter2, "filter");
        Map<String, String> moduleAttributes = mrid.getAttributes();
        return this.getRule(moduleAttributes, filter2);
    }

    private T getRule(Map<String, String> moduleAttributes, Filter<T> filter2) {
        for (MapMatcher midm : this.matcherLookup.get(moduleAttributes)) {
            T rule = this.rules.get(midm);
            if (!filter2.accept(rule)) continue;
            return rule;
        }
        return null;
    }

    public List<T> getRules(ModuleRevisionId mrid, Filter<T> filter2) {
        Checks.checkNotNull(mrid, "mrid");
        Checks.checkNotNull(filter2, "filter");
        Map<String, String> moduleAttributes = mrid.getAttributes();
        return this.getRules(moduleAttributes, filter2);
    }

    private List<T> getRules(Map<String, String> moduleAttributes, Filter<T> filter2) {
        ArrayList<T> matchingRules = new ArrayList<T>();
        for (MapMatcher midm : this.matcherLookup.get(moduleAttributes)) {
            T rule = this.rules.get(midm);
            if (!filter2.accept(rule)) continue;
            matchingRules.add(rule);
        }
        return matchingRules;
    }

    public void dump(String prefix) {
        if (this.rules.isEmpty()) {
            Message.debug(prefix + "NONE");
            return;
        }
        for (Map.Entry<MapMatcher, T> entry : this.rules.entrySet()) {
            MapMatcher midm = entry.getKey();
            T rule = entry.getValue();
            Message.debug(prefix + midm + " -> " + rule);
        }
    }

    public Map<MapMatcher, T> getAllRules() {
        return Collections.unmodifiableMap(this.rules);
    }

    public ModuleRules<T> clone() {
        return new ModuleRules<T>(this.rules);
    }
}

