/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.resolve;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.module.id.ModuleId;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.module.id.ModuleRevisionId;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.resolve.IvyNode;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.plugins.conflict.ConflictManager;

public class IvyNodeEviction {
    private IvyNode node;
    private Map<ModuleIdConf, Set<IvyNode>> selectedDeps = new HashMap<ModuleIdConf, Set<IvyNode>>();
    private Map<ModuleIdConf, Set<IvyNode>> pendingConflicts = new HashMap<ModuleIdConf, Set<IvyNode>>();
    private Map<ModuleIdConf, Set<IvyNode>> evictedDeps = new HashMap<ModuleIdConf, Set<IvyNode>>();
    private Map<ModuleIdConf, Collection<ModuleRevisionId>> evictedRevs = new HashMap<ModuleIdConf, Collection<ModuleRevisionId>>();
    private Map<String, EvictionData> evicted = new HashMap<String, EvictionData>();

    public IvyNodeEviction(IvyNode node) {
        if (node == null) {
            throw new NullPointerException("node must not be null");
        }
        this.node = node;
    }

    public Set<IvyNode> getResolvedNodes(ModuleId mid, String rootModuleConf) {
        Collection resolved = this.selectedDeps.get(new ModuleIdConf(mid, rootModuleConf));
        HashSet<IvyNode> ret = new HashSet<IvyNode>();
        if (resolved != null) {
            for (IvyNode node : resolved) {
                ret.add(node.getRealNode());
            }
        }
        return ret;
    }

    public Collection<ModuleRevisionId> getResolvedRevisions(ModuleId mid, String rootModuleConf) {
        Collection resolved = this.selectedDeps.get(new ModuleIdConf(mid, rootModuleConf));
        if (resolved == null) {
            return new HashSet<ModuleRevisionId>();
        }
        HashSet<ModuleRevisionId> resolvedRevs = new HashSet<ModuleRevisionId>();
        for (IvyNode node : resolved) {
            ModuleRevisionId resolvedId = node.getResolvedId();
            resolvedRevs.add(node.getId());
            resolvedRevs.add(resolvedId);
            if (resolvedId.getExtraAttributes().isEmpty()) continue;
            resolvedRevs.add(ModuleRevisionId.newInstance(resolvedId.getOrganisation(), resolvedId.getName(), resolvedId.getBranch(), resolvedId.getRevision()));
        }
        return resolvedRevs;
    }

    public void setResolvedNodes(ModuleId moduleId, String rootModuleConf, Collection<IvyNode> resolved) {
        ModuleIdConf moduleIdConf = new ModuleIdConf(moduleId, rootModuleConf);
        this.selectedDeps.put(moduleIdConf, new HashSet<IvyNode>(resolved));
    }

    public Collection<IvyNode> getEvictedNodes(ModuleId mid, String rootModuleConf) {
        Collection resolved = this.evictedDeps.get(new ModuleIdConf(mid, rootModuleConf));
        HashSet<IvyNode> ret = new HashSet<IvyNode>();
        if (resolved != null) {
            for (IvyNode node : resolved) {
                ret.add(node.getRealNode());
            }
        }
        return ret;
    }

    public Collection<ModuleRevisionId> getEvictedRevisions(ModuleId mid, String rootModuleConf) {
        Collection<ModuleRevisionId> evicted = this.evictedRevs.get(new ModuleIdConf(mid, rootModuleConf));
        if (evicted == null) {
            return new HashSet<ModuleRevisionId>();
        }
        return new HashSet<ModuleRevisionId>(evicted);
    }

    public void setEvictedNodes(ModuleId moduleId, String rootModuleConf, Collection<IvyNode> evicted) {
        ModuleIdConf moduleIdConf = new ModuleIdConf(moduleId, rootModuleConf);
        this.evictedDeps.put(moduleIdConf, new HashSet<IvyNode>(evicted));
        HashSet<ModuleRevisionId> evictedRevs = new HashSet<ModuleRevisionId>();
        for (IvyNode node : evicted) {
            evictedRevs.add(node.getId());
            evictedRevs.add(node.getResolvedId());
        }
        this.evictedRevs.put(moduleIdConf, evictedRevs);
    }

    public boolean isEvicted(String rootModuleConf) {
        ModuleId moduleId;
        this.cleanEvicted();
        if (this.node.isRoot()) {
            return false;
        }
        EvictionData evictedData = this.getEvictedData(rootModuleConf);
        if (evictedData == null) {
            return false;
        }
        IvyNode root = this.node.getRoot();
        Collection<ModuleRevisionId> resolvedRevisions = root.getResolvedRevisions(moduleId = this.node.getId().getModuleId(), rootModuleConf);
        return !resolvedRevisions.contains(this.node.getResolvedId()) || evictedData.isTransitivelyEvicted();
    }

    public boolean isCompletelyEvicted() {
        this.cleanEvicted();
        if (this.node.isRoot()) {
            return false;
        }
        for (String rootModuleConfiguration : this.node.getRootModuleConfigurations()) {
            if (this.isEvicted(rootModuleConfiguration)) continue;
            return false;
        }
        return true;
    }

    private void cleanEvicted() {
        Iterator<String> iter = this.evicted.keySet().iterator();
        while (iter.hasNext()) {
            Collection<IvyNode> sel = this.evicted.get(iter.next()).getSelected();
            if (sel == null) continue;
            for (IvyNode n : sel) {
                if (!n.getRealNode().equals(this.node)) continue;
                iter.remove();
            }
        }
    }

    public void markEvicted(EvictionData evictionData) {
        this.evicted.put(evictionData.getRootModuleConf(), evictionData);
    }

    public EvictionData getEvictedData(String rootModuleConf) {
        this.cleanEvicted();
        return this.evicted.get(rootModuleConf);
    }

    public String[] getEvictedConfs() {
        this.cleanEvicted();
        return this.evicted.keySet().toArray(new String[this.evicted.keySet().size()]);
    }

    public Collection<IvyNode> getAllEvictingNodes() {
        HashSet<IvyNode> allEvictingNodes = null;
        for (EvictionData ed : this.evicted.values()) {
            Collection<IvyNode> selected = ed.getSelected();
            if (selected == null) continue;
            if (allEvictingNodes == null) {
                allEvictingNodes = new HashSet<IvyNode>();
            }
            allEvictingNodes.addAll(selected);
        }
        return allEvictingNodes;
    }

    public Collection<String> getAllEvictingNodesDetails() {
        HashSet<String> ret = null;
        for (EvictionData ed : this.evicted.values()) {
            Collection<IvyNode> selected = ed.getSelected();
            if (selected == null) continue;
            if (ret == null) {
                ret = new HashSet<String>();
            }
            if (selected.size() == 1) {
                ret.add(selected.iterator().next() + (ed.getDetail() == null ? "" : " " + ed.getDetail()));
                continue;
            }
            if (selected.size() <= 1) continue;
            ret.add(selected + (ed.getDetail() == null ? "" : " " + ed.getDetail()));
        }
        return ret;
    }

    public Collection<ConflictManager> getAllEvictingConflictManagers() {
        HashSet<ConflictManager> ret = new HashSet<ConflictManager>();
        for (EvictionData ed : this.evicted.values()) {
            ret.add(ed.getConflictManager());
        }
        return ret;
    }

    public EvictionData getEvictionDataInRoot(String rootModuleConf, IvyNode ancestor) {
        Set<IvyNode> selectedNodes = this.node.getRoot().getResolvedNodes(this.node.getModuleId(), rootModuleConf);
        for (IvyNode node : selectedNodes) {
            if (!node.getResolvedId().equals(this.node.getResolvedId())) continue;
            return null;
        }
        return new EvictionData(rootModuleConf, ancestor, this.node.getRoot().getConflictManager(this.node.getModuleId()), selectedNodes);
    }

    public Collection<IvyNode> getPendingConflicts(String rootModuleConf, ModuleId mid) {
        Collection resolved = this.pendingConflicts.get(new ModuleIdConf(mid, rootModuleConf));
        HashSet<IvyNode> ret = new HashSet<IvyNode>();
        if (resolved != null) {
            for (IvyNode node : resolved) {
                ret.add(node.getRealNode());
            }
        }
        return ret;
    }

    public void setPendingConflicts(ModuleId moduleId, String rootModuleConf, Collection<IvyNode> conflicts) {
        ModuleIdConf moduleIdConf = new ModuleIdConf(moduleId, rootModuleConf);
        this.pendingConflicts.put(moduleIdConf, new HashSet<IvyNode>(conflicts));
    }

    private static final class ModuleIdConf {
        private ModuleId moduleId;
        private String conf;

        public ModuleIdConf(ModuleId mid, String conf) {
            if (mid == null) {
                throw new NullPointerException("mid cannot be null");
            }
            if (conf == null) {
                throw new NullPointerException("conf cannot be null");
            }
            this.moduleId = mid;
            this.conf = conf;
        }

        public final String getConf() {
            return this.conf;
        }

        public final ModuleId getModuleId() {
            return this.moduleId;
        }

        public boolean equals(Object obj) {
            return obj instanceof ModuleIdConf && this.getModuleId().equals(((ModuleIdConf)obj).getModuleId()) && this.getConf().equals(((ModuleIdConf)obj).getConf());
        }

        public int hashCode() {
            int hash = 33;
            hash += this.getModuleId().hashCode() * 17;
            return hash += this.getConf().hashCode() * 17;
        }
    }

    public static class EvictionData {
        private IvyNode parent;
        private ConflictManager conflictManager;
        private Collection<IvyNode> selected;
        private String rootModuleConf;
        private String detail;

        public EvictionData(String rootModuleConf, IvyNode parent, ConflictManager conflictManager, Collection<IvyNode> selected) {
            this(rootModuleConf, parent, conflictManager, selected, null);
        }

        public EvictionData(String rootModuleConf, IvyNode parent, ConflictManager conflictManager, Collection<IvyNode> selected, String detail) {
            this.rootModuleConf = rootModuleConf;
            this.parent = parent;
            this.conflictManager = conflictManager;
            this.selected = selected;
            this.detail = detail;
        }

        public String toString() {
            if (this.selected != null) {
                return this.selected + " in " + this.parent + (this.detail == null ? "" : " " + this.detail) + " (" + this.conflictManager + ") [" + this.rootModuleConf + "]";
            }
            return "transitively [" + this.rootModuleConf + "]";
        }

        public ConflictManager getConflictManager() {
            return this.conflictManager;
        }

        public IvyNode getParent() {
            return this.parent;
        }

        public Collection<IvyNode> getSelected() {
            return this.selected;
        }

        public String getRootModuleConf() {
            return this.rootModuleConf;
        }

        public boolean isTransitivelyEvicted() {
            return this.parent == null;
        }

        public String getDetail() {
            return this.detail;
        }
    }
}

