/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.api;

import writer2latex.api.BatchConverter;
import writer2latex.api.Converter;
import writer2latex.api.StarMathConverter;

public class ConverterFactory {
    private static final String VERSION = "1.6.1";
    private static final String DATE = "2018-10-12";

    public static String getVersion() {
        return VERSION;
    }

    public static String getDate() {
        return DATE;
    }

    public static Converter createConverter(String sMIME) {
        Object converter = null;
        if ("application/x-latex".equals(sMIME)) {
            converter = ConverterFactory.createInstance("writer2latex.latex.ConverterPalette");
        } else if ("application/x-bibtex".equals(sMIME)) {
            converter = ConverterFactory.createInstance("writer2latex.bibtex.Converter");
        } else if ("text/html".equals(sMIME)) {
            converter = ConverterFactory.createInstance("writer2latex.xhtml.Xhtml10Converter");
        } else if ("application/xhtml11".equals(sMIME)) {
            converter = ConverterFactory.createInstance("writer2latex.xhtml.Xhtml11Converter");
        } else if ("application/xhtml+xml".equals(sMIME)) {
            converter = ConverterFactory.createInstance("writer2latex.xhtml.XhtmlMathMLConverter");
        } else if ("text/html5".equals(sMIME)) {
            converter = ConverterFactory.createInstance("writer2latex.xhtml.Html5Converter");
        } else if ("epub3".equals(sMIME)) {
            converter = ConverterFactory.createInstance("writer2latex.epub.EPUB3Converter");
        } else if ("application/epub+zip".equals(sMIME)) {
            converter = ConverterFactory.createInstance("writer2latex.epub.EPUBConverter");
        }
        return converter instanceof Converter ? (Converter)converter : null;
    }

    public static BatchConverter createBatchConverter(String sMIME) {
        Object converter = null;
        if ("text/html".equals(sMIME)) {
            converter = ConverterFactory.createInstance("writer2latex.xhtml.BatchConverterImpl");
        }
        return converter instanceof BatchConverter ? (BatchConverter)converter : null;
    }

    public static StarMathConverter createStarMathConverter() {
        Object converter = ConverterFactory.createInstance("writer2latex.latex.StarMathConverter");
        return converter instanceof StarMathConverter ? (StarMathConverter)converter : null;
    }

    private static Object createInstance(String sClassName) {
        try {
            return Class.forName(sClassName).newInstance();
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (InstantiationException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }
}

