/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.component.configurator.converters.composite;

import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.configurator.ConfigurationListener;
import org.codehaus.plexus.component.configurator.converters.AbstractConfigurationConverter;
import org.codehaus.plexus.component.configurator.converters.ConfigurationConverter;
import org.codehaus.plexus.component.configurator.converters.ParameterizedConfigurationConverter;
import org.codehaus.plexus.component.configurator.converters.lookup.ConverterLookup;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.eclipse.sisu.inject.Logs;

public class MapConverter
extends AbstractConfigurationConverter
implements ParameterizedConfigurationConverter {
    @Override
    public boolean canConvert(Class<?> type) {
        return Map.class.isAssignableFrom(type) && !Properties.class.isAssignableFrom(type);
    }

    @Override
    public Object fromConfiguration(ConverterLookup lookup, PlexusConfiguration configuration, Class<?> type, Class<?> enclosingType, ClassLoader loader, ExpressionEvaluator evaluator, ConfigurationListener listener) throws ComponentConfigurationException {
        return this.fromConfiguration(lookup, configuration, type, null, enclosingType, loader, evaluator, listener);
    }

    @Override
    public Object fromConfiguration(ConverterLookup lookup, PlexusConfiguration configuration, Class<?> type, Type[] typeArguments, Class<?> enclosingType, ClassLoader loader, ExpressionEvaluator evaluator, ConfigurationListener listener) throws ComponentConfigurationException {
        Object value = this.fromExpression(configuration, evaluator, type);
        if (value != null) {
            return value;
        }
        try {
            Map<Object, Object> map = this.instantiateMap(configuration, type, loader);
            Class<?> elementType = MapConverter.findElementType(typeArguments);
            if (Object.class == elementType || String.class == elementType) {
                int i = 0;
                int size = configuration.getChildCount();
                while (i < size) {
                    PlexusConfiguration element = configuration.getChild(i);
                    map.put(element.getName(), this.fromExpression(element, evaluator));
                    ++i;
                }
                return map;
            }
            ConfigurationConverter converter = lookup.lookupConverterForType(elementType);
            int i = 0;
            int size = configuration.getChildCount();
            while (i < size) {
                Object elementValue;
                PlexusConfiguration element = configuration.getChild(i);
                try {
                    elementValue = converter.fromConfiguration(lookup, element, elementType, enclosingType, loader, evaluator, listener);
                }
                catch (ComponentConfigurationException componentConfigurationException) {
                    elementValue = this.fromExpression(element, evaluator);
                    Logs.warn((String)("Map in " + enclosingType + " declares value type as: {} but saw: {} at runtime"), elementType, elementValue != null ? elementValue.getClass() : null);
                }
                map.put(element.getName(), elementValue);
                ++i;
            }
            return map;
        }
        catch (ComponentConfigurationException e) {
            if (e.getFailedConfiguration() == null) {
                e.setFailedConfiguration(configuration);
            }
            throw e;
        }
    }

    private Map<Object, Object> instantiateMap(PlexusConfiguration configuration, Class<?> type, ClassLoader loader) throws ComponentConfigurationException {
        Class<?> implType = this.getClassForImplementationHint(type, configuration, loader);
        if (implType == null || Modifier.isAbstract(implType.getModifiers())) {
            return new TreeMap<Object, Object>();
        }
        Object impl = this.instantiateObject(implType);
        this.failIfNotTypeCompatible(impl, type, configuration);
        return (Map)impl;
    }

    private static Class<?> findElementType(Type[] typeArguments) {
        if (typeArguments != null && typeArguments.length > 1 && typeArguments[1] instanceof Class) {
            return (Class)typeArguments[1];
        }
        return Object.class;
    }
}

