/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.converter;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.converter.ObjectConverter;
import com.jidesoft.converter.ObjectConverterManager;
import com.jidesoft.converter.Resource;
import com.jidesoft.range.Range;
import java.text.MessageFormat;
import java.util.Locale;

public class RangeConverter
implements ObjectConverter {
    private Class<?> _elementClass;
    public static final ConverterContext CONTEXT_RANGE = new ConverterContext("Range");
    public static final ConverterContext CONTEXT_MULTIPLE = new ConverterContext("Multiple");

    public RangeConverter(Class<?> clazz) {
        this._elementClass = clazz;
    }

    public String arrayToString(Object[] objectArray, ConverterContext converterContext) {
        if (objectArray.length > 1) {
            if (CONTEXT_RANGE.equals(converterContext)) {
                String string = Resource.getResourceBundle(Locale.getDefault()).getString("Range.range");
                return MessageFormat.format(string, this.toString(0, objectArray[0], converterContext), this.toString(1, objectArray[1], converterContext));
            }
            return Resource.getResourceBundle(Locale.getDefault()).getString("Range.multiple");
        }
        if (objectArray.length == 1) {
            return this.toString(0, objectArray[0], converterContext);
        }
        return "";
    }

    protected String toString(int n, Object object, ConverterContext converterContext) {
        return ObjectConverterManager.toString(object, this._elementClass, converterContext);
    }

    public Object[] arrayFromString(String string, ConverterContext converterContext) {
        return null;
    }

    protected Object fromString(int n, String string, ConverterContext converterContext) {
        return ObjectConverterManager.fromString(string, this._elementClass, converterContext);
    }

    @Override
    public String toString(Object object, ConverterContext converterContext) {
        if (object instanceof Range) {
            Range range = (Range)object;
            if (range.size() == 0.0) {
                return this.arrayToString(new Object[]{range.lower()}, converterContext);
            }
            return this.arrayToString(new Object[]{range.lower(), range.upper()}, converterContext);
        }
        return "";
    }

    @Override
    public boolean supportToString(Object object, ConverterContext converterContext) {
        return true;
    }

    @Override
    public Object fromString(String string, ConverterContext converterContext) {
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        Object[] objectArray = this.arrayFromString(string, converterContext);
        if (objectArray == null) {
            return null;
        }
        if (objectArray.length == 1) {
            return null;
        }
        if (objectArray.length >= 2) {
            return null;
        }
        return null;
    }

    @Override
    public boolean supportFromString(String string, ConverterContext converterContext) {
        return false;
    }
}

