/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

class SoftHashMap<K, V>
extends AbstractMap<K, V>
implements Serializable {
    private static final long serialVersionUID = 2456984612468446907L;
    private final Map<K, SoftReference<V>> hash = new HashMap<K, SoftReference<V>>();
    private final Map<SoftReference<V>, K> reverseLookup = new HashMap<SoftReference<V>, K>();
    private final ReferenceQueue<V> queue = new ReferenceQueue();

    SoftHashMap() {
    }

    @Override
    public V get(Object object) {
        this.expungeStaleEntries();
        V v = null;
        SoftReference<V> softReference = this.hash.get(object);
        if (softReference != null && (v = (V)softReference.get()) == null) {
            this.hash.remove(object);
            this.reverseLookup.remove(softReference);
        }
        return v;
    }

    private void expungeStaleEntries() {
        Reference<V> reference;
        while ((reference = this.queue.poll()) != null) {
            this.hash.remove(this.reverseLookup.remove(reference));
        }
    }

    @Override
    public V put(K k, V v) {
        this.expungeStaleEntries();
        SoftReference<V> softReference = new SoftReference<V>(v, this.queue);
        this.reverseLookup.put((SoftReference<K>)softReference, (SoftReference<V>)k);
        SoftReference<V> softReference2 = this.hash.put(k, softReference);
        if (softReference2 == null) {
            return null;
        }
        return softReference2.get();
    }

    @Override
    public V remove(Object object) {
        this.expungeStaleEntries();
        SoftReference<V> softReference = this.hash.remove(object);
        if (softReference == null) {
            return null;
        }
        return softReference.get();
    }

    @Override
    public void clear() {
        this.hash.clear();
        this.reverseLookup.clear();
    }

    @Override
    public int size() {
        this.expungeStaleEntries();
        return this.hash.size();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        this.expungeStaleEntries();
        LinkedHashSet<Map.Entry<K, V>> linkedHashSet = new LinkedHashSet<Map.Entry<K, V>>();
        for (final Map.Entry<K, SoftReference<V>> entry : this.hash.entrySet()) {
            final V v = entry.getValue().get();
            if (v == null) continue;
            linkedHashSet.add(new Map.Entry<K, V>(){

                @Override
                public K getKey() {
                    return entry.getKey();
                }

                @Override
                public V getValue() {
                    return v;
                }

                @Override
                public V setValue(V v2) {
                    entry.setValue(new SoftReference(v2, SoftHashMap.this.queue));
                    return v;
                }
            });
        }
        return linkedHashSet;
    }
}

