/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx.skins;

import eu.hansolo.tilesfx.Tile;
import eu.hansolo.tilesfx.fonts.Fonts;
import eu.hansolo.tilesfx.skins.TileSkin;
import eu.hansolo.tilesfx.tools.Helper;
import eu.hansolo.tilesfx.weather.DarkSky;
import eu.hansolo.tilesfx.weather.DataPoint;
import eu.hansolo.tilesfx.weather.WeatherSymbol;
import java.time.format.DateTimeFormatter;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.layout.HBox;
import javafx.scene.text.Font;
import javafx.scene.text.Text;

public class WeatherTileSkin
extends TileSkin {
    private static final DateTimeFormatter TF = DateTimeFormatter.ofPattern("HH:mm");
    private Text titleText;
    private Text valueText;
    private Text unitText;
    private WeatherSymbol weatherSymbol;
    private Text text;
    private WeatherSymbol sunriseSymbol;
    private WeatherSymbol sunsetSymbol;
    private Text sunriseText;
    private Text sunsetText;
    private HBox sunriseBox;
    private HBox sunsetBox;
    private DarkSky darkSky;

    public WeatherTileSkin(Tile TILE) {
        super(TILE);
    }

    @Override
    protected void initGraphics() {
        super.initGraphics();
        this.darkSky = this.tile.getDarkSky();
        this.titleText = new Text(this.tile.getTitle());
        this.titleText.setFill(this.tile.getTitleColor());
        Helper.enableNode(this.titleText, !this.tile.getTitle().isEmpty());
        this.valueText = new Text();
        this.unitText = new Text(this.darkSky.getUnit().temperatureUnitString);
        this.text = new Text("");
        this.text.setFill(this.tile.getTextColor());
        this.sunriseSymbol = new WeatherSymbol(DarkSky.ConditionAndIcon.SUNRISE, 22.0, this.tile.getForegroundColor());
        this.sunsetSymbol = new WeatherSymbol(DarkSky.ConditionAndIcon.SUNSET, 22.0, this.tile.getForegroundColor());
        this.sunriseText = new Text("");
        this.sunriseText.setTextOrigin(VPos.CENTER);
        this.sunriseText.setFill(this.tile.getTextColor());
        this.sunsetText = new Text("");
        this.sunsetText.setTextOrigin(VPos.CENTER);
        this.sunsetText.setFill(this.tile.getTextColor());
        this.sunriseBox = new HBox(this.sunriseSymbol, this.sunriseText);
        this.sunriseBox.setAlignment(Pos.CENTER_RIGHT);
        this.sunsetBox = new HBox(this.sunsetSymbol, this.sunsetText);
        this.sunsetBox.setAlignment(Pos.CENTER_RIGHT);
        this.weatherSymbol = new WeatherSymbol(DarkSky.ConditionAndIcon.NONE, 250.0, this.tile.getForegroundColor());
        this.getPane().getChildren().addAll((Node[])new Node[]{this.titleText, this.valueText, this.unitText, this.weatherSymbol, this.text, this.sunriseBox, this.sunsetBox});
    }

    @Override
    protected void registerListeners() {
        super.registerListeners();
    }

    @Override
    protected void handleEvents(String EVENT_TYPE) {
        super.handleEvents(EVENT_TYPE);
        if ("VISIBILITY".equals(EVENT_TYPE)) {
            Helper.enableNode(this.titleText, !this.tile.getTitle().isEmpty());
            Helper.enableNode(this.valueText, this.tile.isValueVisible());
            Helper.enableNode(this.unitText, !this.tile.getUnit().isEmpty());
        }
    }

    @Override
    protected void resizeDynamicText() {
        double maxWidth = this.width - this.size * 0.1;
        double fontSize = this.size * this.textSize.factor;
        this.titleText.setFont(Fonts.latoRegular(fontSize));
        if (this.titleText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.titleText, maxWidth, fontSize);
        }
        this.titleText.relocate(this.size * 0.05, this.size * 0.05);
        maxWidth = this.unitText.isVisible() ? this.width - this.size * 0.275 : this.width - this.size * 0.1;
        fontSize = this.size * 0.24;
        this.valueText.setFont(Fonts.latoRegular(fontSize));
        if (this.valueText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.valueText, maxWidth, fontSize);
        }
        if (this.unitText.isVisible()) {
            this.valueText.relocate(this.width - this.size * 0.075 - this.valueText.getLayoutBounds().getWidth() - this.unitText.getLayoutBounds().getWidth(), this.size * 0.15);
        } else {
            this.valueText.relocate(this.width - this.size * 0.05 - this.valueText.getLayoutBounds().getWidth(), this.size * 0.15);
        }
        maxWidth = this.width - this.size * 0.1;
        fontSize = this.size * this.textSize.factor;
        this.text.setFont(Fonts.latoRegular(fontSize));
        if (this.text.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.text, maxWidth, fontSize);
        }
        this.text.setX(this.size * 0.05);
        this.text.setY(this.height - this.size * 0.05);
        Helper.fitNodeWidth(this.text, maxWidth);
        maxWidth = this.width - this.size * 0.705;
        fontSize = this.size * 0.06;
        this.sunriseText.setFont(Fonts.latoRegular(fontSize));
        if (this.sunriseText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.sunriseText, maxWidth, fontSize);
        }
        this.sunsetText.setFont(Fonts.latoRegular(fontSize));
        if (this.sunsetText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.sunsetText, maxWidth, fontSize);
        }
    }

    @Override
    protected void resizeStaticText() {
        double maxWidth = this.width - this.size * 0.1;
        double fontSize = this.size * this.textSize.factor;
        boolean customFontEnabled = this.tile.isCustomFontEnabled();
        Font customFont = this.tile.getCustomFont();
        Font font = customFontEnabled && customFont != null ? Font.font(customFont.getFamily(), fontSize) : Fonts.latoRegular(fontSize);
        this.titleText.setFont(font);
        if (this.titleText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.titleText, maxWidth, fontSize);
        }
        switch (this.tile.getTitleAlignment()) {
            default: {
                this.titleText.relocate(this.size * 0.05, this.size * 0.05);
                break;
            }
            case CENTER: {
                this.titleText.relocate((this.width - this.titleText.getLayoutBounds().getWidth()) * 0.5, this.size * 0.05);
                break;
            }
            case RIGHT: {
                this.titleText.relocate(this.width - this.size * 0.05 - this.titleText.getLayoutBounds().getWidth(), this.size * 0.05);
            }
        }
        maxWidth = this.width - this.size * 0.275;
        fontSize = this.size * 0.12;
        this.unitText.setFont(Fonts.latoRegular(fontSize));
        if (this.unitText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.unitText, maxWidth, fontSize);
        }
        this.unitText.relocate(this.width - this.size * 0.05 - this.unitText.getLayoutBounds().getWidth(), this.size * 0.27);
    }

    @Override
    protected void resize() {
        super.resize();
        this.weatherSymbol.setPrefSize(this.width * 0.5, this.height - this.size * 0.4);
        this.weatherSymbol.relocate(this.contentBounds.getX(), (this.height - this.weatherSymbol.getPrefHeight()) * 0.5);
        this.sunriseBox.setPrefSize(this.width - this.size * 0.1, this.size * 0.09);
        this.sunriseBox.setSpacing(this.size * 0.025);
        this.sunriseBox.relocate(this.contentBounds.getX(), this.height * 0.6075 + this.size * 0.0);
        this.sunsetBox.setPrefSize(this.width - this.size * 0.1, this.size * 0.09);
        this.sunsetBox.setSpacing(this.size * 0.025);
        this.sunsetBox.relocate(this.contentBounds.getX(), this.height * 0.725 + this.size * 0.0);
        this.sunriseSymbol.setPrefSize(this.size * 0.1, this.size * 0.1);
        this.sunsetSymbol.setPrefSize(this.size * 0.1, this.size * 0.1);
        this.redraw();
    }

    @Override
    protected void redraw() {
        super.redraw();
        this.titleText.setText(this.tile.getTitle());
        this.resizeStaticText();
        DataPoint today = this.darkSky.getToday();
        DarkSky.Unit unit = this.darkSky.getUnit();
        if (this.tile.getCustomDecimalFormatEnabled()) {
            this.valueText.setText(this.decimalFormat.format(today.getTemperature()));
        } else {
            this.valueText.setText(String.format(this.locale, this.formatString, today.getTemperature()));
        }
        this.unitText.setText(unit.temperatureUnitString);
        this.weatherSymbol.setCondition(today.getCondition());
        this.text.setText(Helper.normalize(today.getSummary()));
        this.sunriseText.setText(TF.format(today.getSunriseTime()));
        this.sunsetText.setText(TF.format(today.getSunsetTime()));
        this.resizeDynamicText();
        this.titleText.setFill(this.tile.getTitleColor());
        this.valueText.setFill(this.tile.getValueColor());
        this.unitText.setFill(this.tile.getUnitColor());
        this.text.setFill(this.tile.getTextColor());
        this.weatherSymbol.setSymbolColor(this.tile.getForegroundColor());
        this.sunriseSymbol.setSymbolColor(this.tile.getForegroundColor());
        this.sunsetSymbol.setSymbolColor(this.tile.getForegroundColor());
    }
}

