/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx.tools;

import eu.hansolo.tilesfx.chart.ChartData;
import eu.hansolo.tilesfx.tools.Helper;
import eu.hansolo.tilesfx.tools.TimeData;
import java.time.Duration;
import java.time.Instant;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Collectors;

public class MovingAverage {
    public static final int MAX_PERIOD = 2073600;
    private static final int DEFAULT_PERIOD = 10;
    private final Queue<TimeData> window;
    private int period;
    private double sum;

    public MovingAverage() {
        this(10);
    }

    public MovingAverage(int PERIOD) {
        this.period = Helper.clamp(0, 2073600, PERIOD);
        this.window = new ConcurrentLinkedQueue<TimeData>();
    }

    public void addData(TimeData DATA) {
        this.sum += DATA.getValue();
        this.window.add(DATA);
        if (this.window.size() > this.period) {
            this.sum -= this.window.remove().getValue();
        }
    }

    public void addValue(double VALUE) {
        this.addData(new TimeData(VALUE));
    }

    public void addListOfData(List<TimeData> LIST_OF_DATA) {
        LIST_OF_DATA.forEach(data -> this.addData((TimeData)data));
    }

    public Queue<TimeData> getWindow() {
        return this.window.stream().map(item -> new TimeData(item.getValue(), item.getTimestamp())).collect(Collectors.toCollection(LinkedList::new));
    }

    public TimeData getFirstEntry() {
        return this.window.peek();
    }

    public TimeData getLastEntry() {
        return this.window.stream().reduce((first, second) -> second).orElse(null);
    }

    public Instant getTimeSpan() {
        TimeData firstEntry = this.getFirstEntry();
        TimeData lastEntry = this.getLastEntry();
        if (null == firstEntry || null == lastEntry) {
            return null;
        }
        return lastEntry.getTimestamp().minusSeconds(firstEntry.getTimestamp().getEpochSecond());
    }

    public double getAverage() {
        if (this.window.isEmpty()) {
            return 0.0;
        }
        return this.sum / (double)this.window.size();
    }

    public double getTimeBasedAverageOf(Duration DURATION) {
        assert (!DURATION.isNegative()) : "Time period must be positive";
        Instant now = Instant.now();
        return this.window.stream().filter(v -> v.getTimestamp().isAfter(now.minus(DURATION))).mapToDouble(ChartData::getValue).average().getAsDouble();
    }

    public int getPeriod() {
        return this.period;
    }

    public void setPeriod(int PERIOD) {
        this.period = Helper.clamp(0, 2073600, PERIOD);
        this.reset();
    }

    public boolean isFilling() {
        return this.window.size() < this.period;
    }

    public void reset() {
        this.window.clear();
    }
}

