/*
 * Decompiled with CFR 0.152.
 */
package mediathek.daten;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.javafx.EventObservableList;
import ca.odell.glazedlists.util.concurrent.Lock;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.SimpleTimeZone;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import mediathek.config.Konstanten;
import mediathek.daten.DatenFilm;
import mediathek.daten.FilmListMetaData;
import mediathek.tool.GermanStringSorter;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ListeFilme
extends ArrayList<DatenFilm> {
    public static final String FILMLISTE = "Filmliste";
    private static final String DATUM_ZEIT_FORMAT = "dd.MM.yyyy, HH:mm";
    private static final FastDateFormat sdf_ = FastDateFormat.getInstance("dd.MM.yyyy, HH:mm", new SimpleTimeZone(2, "UTC"));
    private static final FastDateFormat formatter = FastDateFormat.getInstance("dd.MM.yyyy, HH:mm");
    private static final Logger logger = LogManager.getLogger(ListeFilme.class);
    private final FilmListMetaData metaData = new FilmListMetaData();
    private final EventList<String> m_senderList = new BasicEventList<String>();
    private final ObservableList<String> obs_senderList = new EventObservableList<String>(this.m_senderList);
    public boolean neueFilme = false;

    public EventList<String> getBaseSenderList() {
        return this.m_senderList;
    }

    public FilmListMetaData metaData() {
        return this.metaData;
    }

    public ObservableList<String> getSenders() {
        return this.obs_senderList;
    }

    public synchronized void importFilmliste(DatenFilm film) {
        this.addInit(film);
    }

    public List<String> getThemen(String sender) {
        Stream<Object> mystream = this.parallelStream();
        if (!sender.isEmpty()) {
            mystream = mystream.filter(f -> f.getSender().equals(sender));
        }
        return mystream.map(DatenFilm::getThema).distinct().sorted(GermanStringSorter.getInstance()).collect(Collectors.toList());
    }

    public synchronized void updateFromFilmList(ListeFilme listeEinsortieren) {
        HashSet hash = new HashSet(listeEinsortieren.size() + 1, 1.0f);
        listeEinsortieren.forEach((? super E f) -> hash.add(f.getIndex()));
        this.removeIf(f -> hash.contains(f.getIndex()));
        listeEinsortieren.forEach(this::addInit);
        hash.clear();
    }

    private void addInit(DatenFilm film) {
        film.init();
        this.add(film);
    }

    @Override
    public boolean add(DatenFilm aFilm) {
        return super.add(aFilm);
    }

    @Override
    public synchronized void clear() {
        this.neueFilme = false;
        super.clear();
    }

    public synchronized void setMetaData(FilmListMetaData meta) {
        this.metaData.setDatum(meta.getDatum());
        this.metaData.setId(meta.getId());
    }

    public synchronized DatenFilm getFilmByUrl(String url) {
        return this.parallelStream().filter(f -> f.getUrl().equalsIgnoreCase(url)).findAny().orElse(null);
    }

    public synchronized DatenFilm getFilmByUrl_klein_hoch_hd(String url) {
        DatenFilm ret = null;
        for (DatenFilm f : this) {
            if (f.getUrl().equals(url)) {
                ret = f;
                break;
            }
            if (f.getUrlFuerAufloesung("hd").equals(url)) {
                ret = f;
                break;
            }
            if (!f.getUrlFuerAufloesung("klein").equals(url)) continue;
            ret = f;
            break;
        }
        return ret;
    }

    public synchronized String genDate() {
        String ret;
        String date = this.metaData.getDatum();
        try {
            Date filmDate = sdf_.parse(date);
            ret = formatter.format(filmDate);
        }
        catch (ParseException ignored) {
            ret = date;
        }
        return ret;
    }

    public synchronized String getId() {
        return this.metaData.getId();
    }

    public long getAge() {
        long ret = 0L;
        Date filmDate = this.getAgeAsDate();
        if (filmDate != null && (ret = (System.currentTimeMillis() - filmDate.getTime()) / 1000L) < 0L) {
            ret = 0L;
        }
        return ret;
    }

    private Date getAgeAsDate() {
        String date = this.metaData.getDatum();
        Date filmDate = null;
        try {
            filmDate = sdf_.parse(date);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return filmDate;
    }

    public synchronized boolean isTooOld() {
        return this.isEmpty() || this.isOlderThan(Konstanten.ALTER_FILMLISTE_SEKUNDEN_FUER_AUTOUPDATE);
    }

    public synchronized boolean isTooOldForDiff() {
        if (this.isEmpty()) {
            return true;
        }
        try {
            String dateMaxDiff_str = new SimpleDateFormat("yyyy.MM.dd__").format(new Date()) + "09:00:00";
            Date dateMaxDiff = new SimpleDateFormat("yyyy.MM.dd__HH:mm:ss").parse(dateMaxDiff_str);
            Date dateFilmliste = this.getAgeAsDate();
            if (dateFilmliste != null) {
                return dateFilmliste.getTime() < dateMaxDiff.getTime();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public boolean isOlderThan(long sekunden) {
        long ret = this.getAge();
        if (ret != 0L) {
            logger.info("Die Filmliste ist {} Minuten alt", (Object)(ret / 60L));
        }
        return ret > sekunden;
    }

    public synchronized long countNewFilms() {
        return this.stream().filter(DatenFilm::isNew).count();
    }

    public void fillSenderList() {
        Lock writeLock = this.m_senderList.getReadWriteLock().writeLock();
        List list = this.stream().map(DatenFilm::getSender).distinct().collect(Collectors.toList());
        Platform.runLater(() -> {
            writeLock.lock();
            this.m_senderList.clear();
            this.m_senderList.addAll(list);
            writeLock.unlock();
        });
    }
}

