/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.actions.export;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.concurrent.CompletableFuture;
import javafx.application.Platform;
import javafx.scene.control.Alert;
import javafx.stage.FileChooser;
import javafx.stage.Modality;
import javax.swing.AbstractAction;
import mediathek.gui.actions.export.FilmListExportWorkerTask;
import mediathek.javafx.tool.FXProgressPane;
import mediathek.mainwindow.MediathekGui;
import org.controlsfx.control.StatusBar;

public class FilmListExportAction
extends AbstractAction {
    private static final String HEADER = "Export der Filmliste";
    private final MediathekGui gui;

    public FilmListExportAction(MediathekGui gui) {
        this.gui = gui;
        this.putValue("Name", "Filmliste...");
    }

    private void export(File selectedFile) {
        StatusBar bar = this.gui.getStatusBarController().getStatusBar();
        FXProgressPane hb = new FXProgressPane();
        FilmListExportWorkerTask task = new FilmListExportWorkerTask(selectedFile);
        task.setOnSucceeded(e -> {
            bar.getRightItems().remove(hb);
            this.showSuccess();
        });
        task.setOnFailed(e -> {
            bar.getRightItems().remove(hb);
            this.showError();
        });
        bar.getRightItems().add(hb);
        hb.prog.progressProperty().bind(task.progressProperty());
        CompletableFuture.runAsync(task);
    }

    private void showError() {
        Alert alert = new Alert(Alert.AlertType.ERROR);
        alert.setTitle("MediathekView");
        alert.setHeaderText(HEADER);
        alert.setContentText("Es gab einen Fehler beim Export der Filmliste.");
        alert.initModality(Modality.APPLICATION_MODAL);
        alert.showAndWait();
    }

    private void showSuccess() {
        Alert alert = new Alert(Alert.AlertType.INFORMATION);
        alert.setTitle("MediathekView");
        alert.setHeaderText(HEADER);
        alert.setContentText("Der Export wurde erfolgreich beendet.");
        alert.initModality(Modality.APPLICATION_MODAL);
        alert.showAndWait();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.setEnabled(false);
        Platform.runLater(() -> {
            FileChooser fileChooser = new FileChooser();
            fileChooser.setTitle("Filmliste sichern");
            fileChooser.setInitialFileName("filme");
            fileChooser.getExtensionFilters().addAll((FileChooser.ExtensionFilter[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("Unkomprimiert", "*.json"), new FileChooser.ExtensionFilter("XZ Komprimiert (Standard)", "*.xz")});
            File selectedFile = fileChooser.showSaveDialog(null);
            if (selectedFile != null) {
                this.export(selectedFile);
            }
        });
        this.setEnabled(true);
    }
}

