/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.SwingWorker;
import mediathek.config.Daten;
import mediathek.config.Icons;
import mediathek.file.GetFile;
import mediathek.gui.dialog.DialogHilfe;
import mediathek.javafx.AppTerminationIndefiniteProgress;
import mediathek.mainwindow.MediathekGui;
import mediathek.tool.EscapeKeyHandler;

public class DialogBeenden
extends JDialog {
    private static final String CANCEL_AND_TERMINATE_PROGRAM = "Downloads abbrechen und Programm beenden";
    private static final String WAIT_FOR_DOWNLOADS_AND_TERMINATE = "Auf Abschlu\u00df aller Downloads warten, danach beenden";
    private static final String WAIT_FOR_RUNNING_DOWNLOADS_AND_TERMINATE = "Nur auf bereits laufende Downloads warten, danach beenden";
    private static final String DONT_TERMINATE = "Programm nicht beenden";
    private final JFrame parent;
    private boolean applicationCanTerminate = false;
    private boolean onlyRunningDownloads = false;
    private boolean shutdown = false;
    private JPanel glassPane = null;
    private SwingWorker<Void, Void> downloadMonitorWorker = null;
    private JComboBox<String> comboActions;
    private JButton btnContinue;
    private JCheckBox cbShutdownComputer;
    private JButton btnCancel;
    private JButton jButtonHilfe;

    public boolean applicationCanTerminate() {
        return this.applicationCanTerminate;
    }

    public DialogBeenden(JFrame pparent) {
        super((Frame)pparent, true);
        this.initComponents();
        this.parent = pparent;
        if (this.parent != null) {
            this.setLocationRelativeTo(this.parent);
        }
        EscapeKeyHandler.installHandler(this, this::escapeHandler);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DialogBeenden.this.escapeHandler();
            }
        });
        this.jButtonHilfe.setIcon(Icons.ICON_BUTTON_HELP);
        this.jButtonHilfe.addActionListener(e -> new DialogHilfe(this.parent, true, new GetFile().getHilfeSuchen("/mediathek/file/hilfetext_beenden.txt")).setVisible(true));
        this.jButtonHilfe.setEnabled(false);
        this.cbShutdownComputer.setEnabled(false);
        this.comboActions.addActionListener(e -> {
            String strSelectedItem;
            switch (strSelectedItem = (String)Objects.requireNonNull(this.comboActions.getSelectedItem())) {
                case "Auf Abschlu\u00df aller Downloads warten, danach beenden": 
                case "Nur auf bereits laufende Downloads warten, danach beenden": {
                    this.jButtonHilfe.setEnabled(true);
                    this.cbShutdownComputer.setEnabled(true);
                    break;
                }
                default: {
                    this.jButtonHilfe.setEnabled(false);
                    this.cbShutdownComputer.setEnabled(false);
                    this.jButtonHilfe.setEnabled(false);
                    this.cbShutdownComputer.setSelected(false);
                    this.shutdown = false;
                }
            }
        });
        this.cbShutdownComputer.addActionListener(e -> {
            this.shutdown = this.cbShutdownComputer.isSelected();
        });
        this.btnContinue.addActionListener(e -> {
            String strSelectedItem;
            switch (strSelectedItem = (String)Objects.requireNonNull(this.comboActions.getSelectedItem())) {
                case "Auf Abschlu\u00df aller Downloads warten, danach beenden": {
                    this.waitUntilDownloadsHaveFinished();
                    break;
                }
                case "Nur auf bereits laufende Downloads warten, danach beenden": {
                    this.onlyRunningDownloads = true;
                    this.waitUntilDownloadsHaveFinished();
                    break;
                }
                case "Downloads abbrechen und Programm beenden": {
                    this.applicationCanTerminate = true;
                    this.dispose();
                    break;
                }
                case "Programm nicht beenden": {
                    this.applicationCanTerminate = false;
                    this.dispose();
                }
            }
        });
        this.btnCancel.addActionListener(e -> this.escapeHandler());
        this.pack();
        this.getRootPane().setDefaultButton(this.btnContinue);
    }

    public boolean isShutdownRequested() {
        return this.shutdown;
    }

    public void setComboWaitAndTerminate() {
        this.comboActions.setSelectedItem(WAIT_FOR_DOWNLOADS_AND_TERMINATE);
        this.cbShutdownComputer.setSelected(true);
        this.shutdown = true;
    }

    private DefaultComboBoxModel<String> getComboBoxModel() {
        return new DefaultComboBoxModel<String>(new String[]{CANCEL_AND_TERMINATE_PROGRAM, WAIT_FOR_DOWNLOADS_AND_TERMINATE, WAIT_FOR_RUNNING_DOWNLOADS_AND_TERMINATE, DONT_TERMINATE});
    }

    private void escapeHandler() {
        if (this.downloadMonitorWorker != null) {
            this.downloadMonitorWorker.cancel(true);
        }
        if (this.glassPane != null) {
            this.glassPane.setVisible(false);
        }
        this.applicationCanTerminate = false;
        this.dispose();
    }

    private JPanel createGlassPane() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout(5, 5));
        AppTerminationIndefiniteProgress progPanel = new AppTerminationIndefiniteProgress(this.isShutdownRequested());
        panel.add((Component)progPanel, "Center");
        return panel;
    }

    private void waitUntilDownloadsHaveFinished() {
        this.glassPane = this.createGlassPane();
        this.setGlassPane(this.glassPane);
        this.glassPane.setVisible(true);
        if (this.onlyRunningDownloads) {
            MediathekGui.ui().tabDownloads.stopAllWaitingDownloads();
            this.onlyRunningDownloads = false;
        }
        this.downloadMonitorWorker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                while (Daten.getInstance().getListeDownloads().unfinishedDownloads() > 0L && !this.isCancelled()) {
                    TimeUnit.SECONDS.sleep(1L);
                }
                return null;
            }

            @Override
            protected void done() {
                DialogBeenden.this.applicationCanTerminate = true;
                DialogBeenden.this.glassPane.setVisible(false);
                DialogBeenden.this.dispose();
                DialogBeenden.this.downloadMonitorWorker = null;
            }
        };
        this.downloadMonitorWorker.execute();
    }

    private void initComponents() {
        JLabel jLabel1 = new JLabel();
        this.comboActions = new JComboBox();
        this.btnContinue = new JButton();
        this.cbShutdownComputer = new JCheckBox();
        this.btnCancel = new JButton();
        this.jButtonHilfe = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("MediathekView beenden");
        this.setResizable(false);
        Container contentPane = this.getContentPane();
        jLabel1.setText("<html>Es sind noch nicht alle Downloads fertig.<br>Wie m\u00f6chten Sie fortfahren?</html>");
        this.comboActions.setModel(this.getComboBoxModel());
        this.btnContinue.setText("Weiter");
        this.cbShutdownComputer.setText("Rechner herunterfahren");
        this.btnCancel.setText("Abbrechen");
        this.jButtonHilfe.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/muster/button-help.png")));
        this.jButtonHilfe.setToolTipText("Hilfe anzeigen");
        GroupLayout contentPaneLayout = new GroupLayout(contentPane);
        contentPane.setLayout(contentPaneLayout);
        contentPaneLayout.setHorizontalGroup(contentPaneLayout.createParallelGroup().addGroup(contentPaneLayout.createSequentialGroup().addContainerGap().addGroup(contentPaneLayout.createParallelGroup().addComponent(jLabel1, -1, 521, Short.MAX_VALUE).addComponent(this.comboActions, -1, 0, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, contentPaneLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButtonHilfe).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnCancel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnContinue)).addGroup(contentPaneLayout.createSequentialGroup().addComponent(this.cbShutdownComputer).addGap(0, 351, Short.MAX_VALUE))).addContainerGap()));
        contentPaneLayout.setVerticalGroup(contentPaneLayout.createParallelGroup().addGroup(GroupLayout.Alignment.TRAILING, contentPaneLayout.createSequentialGroup().addContainerGap().addComponent(jLabel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboActions, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbShutdownComputer).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(contentPaneLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(contentPaneLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnContinue).addComponent(this.btnCancel)).addComponent(this.jButtonHilfe)).addContainerGap()));
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }
}

