/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.dialog;

import java.awt.Frame;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import jiconfont.icons.FontAwesome;
import jiconfont.swing.IconFontSwing;
import mediathek.config.Daten;
import mediathek.config.Icons;
import mediathek.config.MVConfig;
import mediathek.daten.DatenMediaDB;
import mediathek.file.GetFile;
import mediathek.gui.dialog.DialogHilfe;
import mediathek.gui.messages.mediadb.MediaDbDialogVisibleEvent;
import mediathek.gui.messages.mediadb.MediaDbStartEvent;
import mediathek.gui.messages.mediadb.MediaDbStopEvent;
import mediathek.tool.CellRendererMediaDB;
import mediathek.tool.DirOpenAction;
import mediathek.tool.EscapeKeyHandler;
import mediathek.tool.FilenameUtils;
import mediathek.tool.Filter;
import mediathek.tool.GuiFunktionen;
import mediathek.tool.MVMessageDialog;
import mediathek.tool.NoSelectionErrorDialog;
import mediathek.tool.OpenPlayerAction;
import mediathek.tool.models.TModelMediaDB;
import mediathek.tool.table.MVMediaDbTable;
import mediathek.tool.table.MVTable;
import net.engio.mbassy.listener.Handler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DialogMediaDB
extends JDialog {
    private final JFrame parent;
    private final Daten daten = Daten.getInstance();
    private final MVTable tabelleFilme;
    private static final Logger logger = LogManager.getLogger(DialogMediaDB.class);
    private JButton jButtonBeenden;
    private JButton jButtonHelp;
    private JButton jButtonIndex;
    private JButton jButtonSearch;
    private JLabel jLabelSizeFound;
    private JLabel jLabelSum;
    private JScrollPane jScrollPane3;
    private JTextField jTextFieldFilmPfad;
    private JTextField jTextFieldFilmTitle;
    private JTextField jTextFieldSearch;
    private JProgressBar progress;

    @Handler
    private void handleMediaDbStartEvent(MediaDbStartEvent e) {
        SwingUtilities.invokeLater(() -> {
            this.makeIndex(true);
            this.jLabelSum.setText("0");
        });
    }

    @Handler
    private void handleMediaDbStopEvent(MediaDbStopEvent e) {
        SwingUtilities.invokeLater(() -> {
            this.makeIndex(false);
            this.jLabelSum.setText(Integer.toString(this.daten.getListeMediaDB().size()));
            this.searchFilmInDb();
        });
    }

    public DialogMediaDB(JFrame pparent) {
        super((Frame)pparent, false);
        this.initComponents();
        this.daten.getMessageBus().subscribe(this);
        this.parent = pparent;
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DialogMediaDB.this.beenden();
            }
        });
        this.setTitle("Mediensammlung durchsuchen");
        this.tabelleFilme = new MVMediaDbTable();
        this.jScrollPane3.setViewportView(this.tabelleFilme);
        TModelMediaDB modelFilm = new TModelMediaDB(new Object[0][], DatenMediaDB.COLUMN_NAMES);
        CellRendererMediaDB cellRenderer = new CellRendererMediaDB();
        this.tabelleFilme.setDefaultRenderer(Object.class, cellRenderer);
        this.tabelleFilme.setModel(modelFilm);
        this.tabelleFilme.addMouseListener(new BeobMausTabelle());
        this.tabelleFilme.getSelectionModel().addListSelectionListener(new BeobTableSelect());
        this.tabelleFilme.setAutoResizeMode(2);
        this.tabelleFilme.initTabelle();
        this.progress.setVisible(false);
        this.progress.setIndeterminate(true);
        this.progress.setMaximum(0);
        this.progress.setMinimum(0);
        this.progress.setValue(0);
        this.jTextFieldSearch.addActionListener(e -> this.searchFilmInDb());
        this.jTextFieldSearch.getDocument().addDocumentListener(new BeobDoc());
        this.jButtonIndex.addActionListener(e -> this.daten.getListeMediaDB().createMediaDB(""));
        this.jButtonHelp.setIcon(Icons.ICON_BUTTON_HELP);
        this.jButtonHelp.addActionListener(e -> new DialogHilfe(this.parent, true, new GetFile().getHilfeSuchen("hilfetext_dialog_mediaDb.txt")).setVisible(true));
        this.jButtonSearch.addActionListener(e -> this.searchFilmInDb());
        this.jButtonBeenden.addActionListener(e -> this.beenden());
        EscapeKeyHandler.installHandler(this, this::beenden);
        GuiFunktionen.setSize(MVConfig.Configs.SYSTEM_MEDIA_DB_DIALOG_GROESSE, this, this.parent);
    }

    @Override
    public void setVisible(boolean vis) {
        super.setVisible(vis);
        if (vis && this.daten.getListeMediaPath().isEmpty()) {
            JOptionPane.showMessageDialog(this.parent, "Erst in den Einstellungen eine Mediensammlung einrichten.", "Mediensammlung leer!", 0);
        }
    }

    public final void setVis() {
        this.setVisible(Boolean.parseBoolean(MVConfig.get(MVConfig.Configs.SYSTEM_MEDIA_DB_DIALOG_ANZEIGEN)));
        this.daten.getMessageBus().publishAsync(new MediaDbDialogVisibleEvent());
    }

    public void tabelleSpeichern() {
        if (this.tabelleFilme != null) {
            this.tabelleFilme.tabelleNachDatenSchreiben();
        }
    }

    public void setFilter(String titel) {
        titel = FilenameUtils.replaceLeerDateiname(titel, false, Boolean.parseBoolean(MVConfig.get(MVConfig.Configs.SYSTEM_USE_REPLACETABLE)), Boolean.parseBoolean(MVConfig.get(MVConfig.Configs.SYSTEM_ONLY_ASCII)));
        this.jTextFieldSearch.setText(titel);
    }

    private synchronized void searchFilmInDb() {
        TModelMediaDB model = new TModelMediaDB(new Object[0][], DatenMediaDB.COLUMN_NAMES);
        this.daten.getListeMediaDB().searchFilmInDB(model, this.jTextFieldSearch.getText());
        this.tabelleFilme.getSpalten();
        this.tabelleFilme.setModel(model);
        this.tabelleFilme.setSpalten();
        this.jLabelSizeFound.setText("" + model.getRowCount());
    }

    private void makeIndex(boolean makeIndex) {
        this.progress.setVisible(makeIndex);
        this.jTextFieldSearch.setEnabled(!makeIndex);
        this.jButtonSearch.setEnabled(!makeIndex);
        this.jButtonIndex.setEnabled(!makeIndex);
    }

    private void zielordnerOeffnen() {
        int row = this.tabelleFilme.getSelectedRow();
        if (row >= 0) {
            String s2 = (String)this.tabelleFilme.getModel().getValueAt(this.tabelleFilme.convertRowIndexToModel(row), 1);
            DirOpenAction.zielordnerOeffnen(this.parent, s2);
        } else {
            NoSelectionErrorDialog.show();
        }
    }

    private void filmAbspielen_() {
        int row = this.tabelleFilme.getSelectedRow();
        if (row >= 0) {
            String file = (String)this.tabelleFilme.getModel().getValueAt(this.tabelleFilme.convertRowIndexToModel(row), 0);
            String path = (String)this.tabelleFilme.getModel().getValueAt(this.tabelleFilme.convertRowIndexToModel(row), 1);
            OpenPlayerAction.filmAbspielen(this.parent, path + File.separator + file);
        } else {
            NoSelectionErrorDialog.show();
        }
    }

    private void aktFilmSetzen() {
        int row = this.tabelleFilme.getSelectedRow();
        if (row >= 0) {
            String file = (String)this.tabelleFilme.getModel().getValueAt(this.tabelleFilme.convertRowIndexToModel(row), 0);
            String path = (String)this.tabelleFilme.getModel().getValueAt(this.tabelleFilme.convertRowIndexToModel(row), 1);
            this.jTextFieldFilmTitle.setText(file);
            this.jTextFieldFilmPfad.setText(path);
        } else {
            this.jTextFieldFilmTitle.setText("");
            this.jTextFieldFilmPfad.setText("");
        }
    }

    private void filmLoeschen_() {
        Object del = "";
        int row = this.tabelleFilme.getSelectedRow();
        if (row < 0) {
            NoSelectionErrorDialog.show();
            return;
        }
        try {
            String file = (String)this.tabelleFilme.getModel().getValueAt(this.tabelleFilme.convertRowIndexToModel(row), 0);
            String path = (String)this.tabelleFilme.getModel().getValueAt(this.tabelleFilme.convertRowIndexToModel(row), 1);
            del = path + File.separator + file;
            File delFile = new File((String)del);
            if (!delFile.exists()) {
                MVMessageDialog.showMessageDialog(this.parent, "Die Datei existiert nicht!", "Film l\u00f6schen", 0);
                return;
            }
            int ret = JOptionPane.showConfirmDialog(this.parent, delFile.getAbsolutePath(), "Film L\u00f6schen?", 0);
            if (ret != 0) {
                return;
            }
            logger.info(new String[]{"Datei l\u00f6schen: ", delFile.getAbsolutePath()});
            if (!delFile.delete()) {
                throw new Exception();
            }
        }
        catch (Exception ex) {
            MVMessageDialog.showMessageDialog(this.parent, "Konnte die Datei nicht l\u00f6schen!", "Film l\u00f6schen", 0);
            logger.error("Fehler beim l\u00f6schen: " + (String)del);
        }
    }

    private void beenden() {
        MVConfig.add(MVConfig.Configs.SYSTEM_MEDIA_DB_DIALOG_ANZEIGEN, Boolean.FALSE.toString());
        this.setVis();
    }

    private void initComponents() {
        this.jButtonBeenden = new JButton();
        this.jButtonHelp = new JButton();
        this.jTextFieldSearch = new JTextField();
        this.jButtonSearch = new JButton();
        this.jScrollPane3 = new JScrollPane();
        JTable jTableFilm = new JTable();
        JLabel jLabel1 = new JLabel();
        this.jLabelSizeFound = new JLabel();
        JLabel jLabel4 = new JLabel();
        this.jButtonIndex = new JButton();
        this.jLabelSum = new JLabel();
        this.progress = new JProgressBar();
        JLabel jLabel3 = new JLabel();
        this.jTextFieldFilmTitle = new JTextField();
        JLabel jLabel5 = new JLabel();
        this.jTextFieldFilmPfad = new JTextField();
        this.setDefaultCloseOperation(2);
        this.jButtonBeenden.setText("Ok");
        this.jButtonHelp.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/muster/button-help.png")));
        this.jButtonHelp.setToolTipText("Hilfe anzeigen");
        this.jButtonSearch.setText("Suchen");
        jTableFilm.setAutoCreateRowSorter(true);
        jTableFilm.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane3.setViewportView(jTableFilm);
        jLabel1.setText("Treffer:");
        this.jLabelSizeFound.setText("0");
        jLabel4.setText("Anzahl Medien gesamt:");
        this.jButtonIndex.setText("Index neu aufbauen");
        this.jLabelSum.setText("0");
        jLabel3.setText("Titel:");
        this.jTextFieldFilmTitle.setEditable(false);
        jLabel5.setText("Pfad:");
        this.jTextFieldFilmPfad.setEditable(false);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane3, -1, 536, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jTextFieldSearch).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonSearch).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonHelp)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.progress, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonIndex).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonBeenden, -2, 93, -2)).addGroup(layout.createSequentialGroup().addComponent(jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelSum).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelSizeFound)).addGroup(layout.createSequentialGroup().addComponent(jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldFilmTitle)).addGroup(layout.createSequentialGroup().addComponent(jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldFilmPfad))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldSearch, -2, -1, -2).addComponent(this.jButtonSearch)).addComponent(this.jButtonHelp)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel4).addComponent(this.jLabelSum)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel1).addComponent(this.jLabelSizeFound))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane3, -1, 490, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel3).addComponent(this.jTextFieldFilmTitle, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel5).addComponent(this.jTextFieldFilmPfad, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.progress, -2, -1, -2).addComponent(this.jButtonIndex).addComponent(this.jButtonBeenden)).addContainerGap()));
        layout.linkSize(1, this.jButtonHelp, this.jButtonSearch, this.jTextFieldSearch);
        this.pack();
    }

    public class BeobMausTabelle
    extends MouseAdapter {
        @Override
        public void mousePressed(MouseEvent arg0) {
            if (arg0.isPopupTrigger()) {
                this.showMenu(arg0);
            }
        }

        @Override
        public void mouseReleased(MouseEvent arg0) {
            if (arg0.isPopupTrigger()) {
                this.showMenu(arg0);
            }
        }

        private void showMenu(MouseEvent evt) {
            Point p = evt.getPoint();
            int nr = DialogMediaDB.this.tabelleFilme.rowAtPoint(p);
            if (nr >= 0) {
                DialogMediaDB.this.tabelleFilme.setRowSelectionInterval(nr, nr);
            }
            JPopupMenu jPopupMenu = new JPopupMenu();
            JMenuItem itemPlayerDownload = new JMenuItem("gespeicherten Film (Datei) abspielen");
            itemPlayerDownload.setIcon(IconFontSwing.buildIcon(FontAwesome.PLAY, 16.0f));
            itemPlayerDownload.addActionListener(e -> DialogMediaDB.this.filmAbspielen_());
            jPopupMenu.add(itemPlayerDownload);
            JMenuItem itemDeleteDownload = new JMenuItem("gespeicherten Film (Datei) l\u00f6schen");
            itemDeleteDownload.setIcon(Icons.ICON_BUTTON_DEL);
            itemDeleteDownload.addActionListener(e -> DialogMediaDB.this.filmLoeschen_());
            jPopupMenu.add(itemDeleteDownload);
            JMenuItem itemOeffnen = new JMenuItem("Zielordner \u00f6ffnen");
            itemOeffnen.setIcon(Icons.ICON_MENUE_FILE_OPEN);
            jPopupMenu.add(itemOeffnen);
            itemOeffnen.addActionListener(arg0 -> DialogMediaDB.this.zielordnerOeffnen());
            jPopupMenu.addSeparator();
            JMenuItem itemResetTab = new JMenuItem("Tabelle zur\u00fccksetzen");
            jPopupMenu.add(itemResetTab);
            itemResetTab.addActionListener(arg0 -> DialogMediaDB.this.tabelleFilme.resetTabelle());
            jPopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private class BeobTableSelect
    implements ListSelectionListener {
        private BeobTableSelect() {
        }

        @Override
        public void valueChanged(ListSelectionEvent event) {
            if (!event.getValueIsAdjusting()) {
                DialogMediaDB.this.aktFilmSetzen();
            }
        }
    }

    private class BeobDoc
    implements DocumentListener {
        private BeobDoc() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.tus();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.tus();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.tus();
        }

        private void tus() {
            Filter.checkPattern1(DialogMediaDB.this.jTextFieldSearch);
            if (Boolean.parseBoolean(MVConfig.get(MVConfig.Configs.SYSTEM_MEDIA_DB_ECHTZEITSUCHE))) {
                DialogMediaDB.this.searchFilmInDb();
            }
        }
    }
}

