/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.history;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import mediathek.config.Daten;
import mediathek.controller.history.MVUsedUrl;
import mediathek.controller.history.MVUsedUrlModelHelper;
import mediathek.controller.history.MVUsedUrls;
import mediathek.daten.DatenDownload;
import mediathek.daten.DatenFilm;
import mediathek.gui.dialog.DialogAddDownload;
import mediathek.gui.dialog.DialogZiel;
import mediathek.gui.filmInformation.InfoDialog;
import mediathek.gui.history.HistoryWriterThread;
import mediathek.mainwindow.MediathekGui;
import mediathek.tool.GuiFunktionen;
import mediathek.tool.models.TModel;
import net.miginfocom.layout.AC;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;

public abstract class PanelErledigteUrls
extends JPanel {
    protected final Daten daten;
    protected MVUsedUrls<?> workList;
    protected JTable jTable1;
    private JPanel panel1;
    protected JButton jButtonLoeschen;
    protected JToggleButton jToggleButtonLaden;
    private JButton jButtonExport;
    private JLabel jLabelSum;

    public PanelErledigteUrls(Daten d) {
        this.daten = d;
        this.initComponents();
        this.jTable1.addMouseListener(new BeobMausTabelle());
        this.jButtonLoeschen.setEnabled(false);
        this.jButtonExport.addActionListener(e -> this.export());
        this.initListeners();
    }

    protected void changeListHandler() {
        if (this.jToggleButtonLaden.isSelected()) {
            this.updateModelAndRecalculate(this.createDataModel());
        }
    }

    private void initListeners() {
        this.jToggleButtonLaden.addActionListener(e -> {
            if (this.jToggleButtonLaden.isSelected()) {
                this.jButtonLoeschen.setEnabled(true);
                this.updateModelAndRecalculate(this.createDataModel());
            } else {
                this.jButtonLoeschen.setEnabled(false);
                this.updateModelAndRecalculate(new TModel(null, MVUsedUrlModelHelper.TITLE_HEADER));
            }
        });
        this.jButtonLoeschen.addActionListener(e -> {
            int ret = JOptionPane.showConfirmDialog(this, "Alle Eintr\u00e4ge werden gel\u00f6scht.", "L\u00f6schen?", 0);
            if (ret == 0) {
                this.workList.alleLoeschen();
            }
        });
    }

    private void updateModelAndRecalculate(@NotNull TModel model) {
        this.jTable1.setModel(model);
        this.setsum();
    }

    protected TModel createDataModel() {
        Object[][] data = MVUsedUrlModelHelper.getObjectData(this.workList.getListeUrlsSortDate());
        return new TModel(data, MVUsedUrlModelHelper.TITLE_HEADER);
    }

    private void setsum() {
        if (this.jTable1.getRowCount() <= 0) {
            this.jLabelSum.setText("");
        } else {
            this.jLabelSum.setText("Anzahl: " + this.jTable1.getRowCount());
        }
    }

    protected String getExportFileLocation() {
        DialogZiel dialog = new DialogZiel(null, true, GuiFunktionen.getHomePath() + File.separator + "Mediathek-Filme.txt", "Filmtitel speichern");
        dialog.setVisible(true);
        if (!dialog.ok) {
            return "";
        }
        return dialog.ziel;
    }

    protected List<MVUsedUrl> getExportableList() {
        return this.workList.getSortedList();
    }

    private void export() {
        if (this.jTable1.getModel().getRowCount() <= 0) {
            return;
        }
        String ziel = this.getExportFileLocation();
        if (!ziel.isEmpty()) {
            new HistoryWriterThread(ziel, this.getExportableList()).start();
        }
    }

    private void initComponents() {
        JScrollPane jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.panel1 = new JPanel();
        this.jButtonLoeschen = new JButton();
        this.jToggleButtonLaden = new JToggleButton();
        this.jButtonExport = new JButton();
        this.jLabelSum = new JLabel();
        this.setLayout(new MigLayout(new LC().insets("5").hideMode(3).gridGap("0", "0"), new AC().grow().fill(), new AC().grow().fill().gap().fill()));
        jScrollPane1.setViewportView(this.jTable1);
        this.add((Component)jScrollPane1, new CC().cell(0, 0));
        this.panel1.setLayout(new MigLayout(new LC().insets("5 5 0 5").hideMode(3).gridGap("5", "5"), new AC().fill().gap().grow().fill().gap().fill().gap().fill(), new AC().fill()));
        this.jButtonLoeschen.setText("Liste l\u00f6schen");
        this.panel1.add((Component)this.jButtonLoeschen, new CC().cell(3, 0));
        this.jToggleButtonLaden.setText("Laden");
        this.panel1.add((Component)this.jToggleButtonLaden, new CC().cell(0, 0));
        this.jButtonExport.setText("Liste exportieren");
        this.panel1.add((Component)this.jButtonExport, new CC().cell(2, 0));
        this.panel1.add((Component)this.jLabelSum, new CC().cell(1, 0));
        this.add((Component)this.panel1, new CC().cell(0, 1));
    }

    class BeobMausTabelle
    extends MouseAdapter {
        private final BeobLoeschen beobLoeschen = new BeobLoeschen();
        private final BeobUrl beobUrl = new BeobUrl();
        private DatenFilm film;

        BeobMausTabelle() {
        }

        @Override
        public void mousePressed(MouseEvent arg0) {
            if (arg0.isPopupTrigger()) {
                this.showMenu(arg0);
            }
        }

        @Override
        public void mouseReleased(MouseEvent arg0) {
            if (arg0.isPopupTrigger()) {
                this.showMenu(arg0);
            }
        }

        private void showMenu(MouseEvent evt) {
            Point p = evt.getPoint();
            int nr = PanelErledigteUrls.this.jTable1.rowAtPoint(p);
            if (nr >= 0) {
                PanelErledigteUrls.this.jTable1.setRowSelectionInterval(nr, nr);
                String url = PanelErledigteUrls.this.jTable1.getValueAt(PanelErledigteUrls.this.jTable1.convertRowIndexToModel(nr), 3).toString();
                this.film = PanelErledigteUrls.this.daten.getListeFilme().getFilmByUrl(url);
            }
            JPopupMenu jPopupMenu = new JPopupMenu();
            JMenuItem item = new JMenuItem("Url aus der Liste l\u00f6schen");
            item.addActionListener(this.beobLoeschen);
            jPopupMenu.add(item);
            item = new JMenuItem("URL kopieren");
            item.addActionListener(this.beobUrl);
            jPopupMenu.add(item);
            item = new JMenuItem("Infos zum Film anzeigen");
            item.addActionListener(new BeobInfo());
            jPopupMenu.add(item);
            if (this.film == null) {
                item.setEnabled(false);
            }
            item = new JMenuItem("Download noch einmal anlegen");
            item.addActionListener(new BeobDownload());
            jPopupMenu.add(item);
            if (this.film == null) {
                item.setEnabled(false);
            }
            jPopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
        }

        private class BeobLoeschen
        implements ActionListener {
            private BeobLoeschen() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                int selectedTableRow = PanelErledigteUrls.this.jTable1.getSelectedRow();
                if (selectedTableRow != -1) {
                    String del = PanelErledigteUrls.this.jTable1.getValueAt(PanelErledigteUrls.this.jTable1.convertRowIndexToModel(selectedTableRow), 3).toString();
                    PanelErledigteUrls.this.workList.urlAusLogfileLoeschen(del);
                }
            }
        }

        class BeobUrl
        implements ActionListener {
            BeobUrl() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                int selectedTableRow = PanelErledigteUrls.this.jTable1.getSelectedRow();
                if (selectedTableRow != -1) {
                    String del = PanelErledigteUrls.this.jTable1.getValueAt(PanelErledigteUrls.this.jTable1.convertRowIndexToModel(selectedTableRow), 3).toString();
                    GuiFunktionen.copyToClipboard(del);
                }
            }
        }

        class BeobInfo
        implements ActionListener {
            BeobInfo() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                InfoDialog dlg = MediathekGui.ui().getFilmInfoDialog();
                dlg.updateCurrentFilm(BeobMausTabelle.this.film);
                dlg.showInfo();
            }
        }

        class BeobDownload
        implements ActionListener {
            BeobDownload() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                int ret;
                DatenDownload datenDownload = PanelErledigteUrls.this.daten.getListeDownloads().getDownloadUrlFilm(BeobMausTabelle.this.film.getUrl());
                if (datenDownload != null && (ret = JOptionPane.showConfirmDialog(PanelErledigteUrls.this.getParent(), "Download f\u00fcr den Film existiert bereits.\nNoch einmal anlegen?", "Anlegen?", 0)) != 0) {
                    return;
                }
                DialogAddDownload dialog = new DialogAddDownload(MediathekGui.ui(), PanelErledigteUrls.this.daten, BeobMausTabelle.this.film, null, "");
                dialog.setVisible(true);
            }
        }
    }
}

