/*
 * Decompiled with CFR 0.152.
 */
package org.h2.api;

import java.io.Serializable;
import org.h2.util.DateTimeUtils;

public final class TimestampWithTimeZone
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 4413229090646777107L;
    private final long dateValue;
    private final long timeNanos;
    private final int timeZoneOffsetSeconds;

    @Deprecated
    public TimestampWithTimeZone(long l, long l2, short s2) {
        this(l, l2, s2 * 60);
    }

    public TimestampWithTimeZone(long l, long l2, int n) {
        this.dateValue = l;
        this.timeNanos = l2;
        this.timeZoneOffsetSeconds = n;
    }

    public long getYMD() {
        return this.dateValue;
    }

    public int getYear() {
        return DateTimeUtils.yearFromDateValue(this.dateValue);
    }

    public int getMonth() {
        return DateTimeUtils.monthFromDateValue(this.dateValue);
    }

    public int getDay() {
        return DateTimeUtils.dayFromDateValue(this.dateValue);
    }

    public long getNanosSinceMidnight() {
        return this.timeNanos;
    }

    @Deprecated
    public short getTimeZoneOffsetMins() {
        return (short)(this.timeZoneOffsetSeconds / 60);
    }

    public int getTimeZoneOffsetSeconds() {
        return this.timeZoneOffsetSeconds;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(35);
        DateTimeUtils.appendTimestampTimeZone(stringBuilder, this.dateValue, this.timeNanos, this.timeZoneOffsetSeconds);
        return stringBuilder.toString();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (int)(this.dateValue ^ this.dateValue >>> 32);
        n = 31 * n + (int)(this.timeNanos ^ this.timeNanos >>> 32);
        n = 31 * n + this.timeZoneOffsetSeconds;
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        TimestampWithTimeZone timestampWithTimeZone = (TimestampWithTimeZone)object;
        if (this.dateValue != timestampWithTimeZone.dateValue) {
            return false;
        }
        if (this.timeNanos != timestampWithTimeZone.timeNanos) {
            return false;
        }
        return this.timeZoneOffsetSeconds == timestampWithTimeZone.timeZoneOffsetSeconds;
    }
}

