<?php
/**
 * Aliases for special pages
 *
 * @file
 * @ingroup Extensions
 */

$specialPageAliases = [];

/** English (English) */
$specialPageAliases['en'] = [
	'ReplaceText' => [ 'ReplaceText' ],
];

/** Arabic (العربية) */
$specialPageAliases['ar'] = [
	'ReplaceText' => [ 'استبدال_نص' ],
];

/** Egyptian Arabic (مصرى) */
$specialPageAliases['arz'] = [
	'ReplaceText' => [ 'تبديل_نص' ],
];

/** Western Balochi (بلوچی رخشانی) */
$specialPageAliases['bgn'] = [
	'ReplaceText' => [ 'متنی_جاگیرکورتین' ],
];

/** Breton (brezhoneg) */
$specialPageAliases['br'] = [
	'ReplaceText' => [ 'Erlc\'hiañTestenn' ],
];

/** Bosnian (bosanski) */
$specialPageAliases['bs'] = [
	'ReplaceText' => [ 'ZamjenaTeksta' ],
];

/** Czech (čeština) */
$specialPageAliases['cs'] = [
	'ReplaceText' => [ 'Nahradit_text' ],
];

/** German (Deutsch) */
$specialPageAliases['de'] = [
	'ReplaceText' => [ 'Text_ersetzen' ],
];

/** Zazaki (Zazaki) */
$specialPageAliases['diq'] = [
	'ReplaceText' => [ 'MetinVırnayış' ],
];

/** Lower Sorbian (dolnoserbski) */
$specialPageAliases['dsb'] = [
	'ReplaceText' => [ 'Tekst wuměniś' ],
];

/** Divehi (ދިވެހިބަސް) */
$specialPageAliases['dv'] = [
	'ReplaceText' => [ 'ލިޔުން_ބަދަލުކުރައްވާ' ],
];

/** Greek (Ελληνικά) */
$specialPageAliases['el'] = [
	'ReplaceText' => [ 'ΑντικατάστασηΚειμένου' ],
];

/** Esperanto (Esperanto) */
$specialPageAliases['eo'] = [
	'ReplaceText' => [ 'Anstataŭigi_tekston' ],
];

/** Persian (فارسی) */
$specialPageAliases['fa'] = [
	'ReplaceText' => [ 'جایگزینی_متن' ],
];

/** Finnish (suomi) */
$specialPageAliases['fi'] = [
	'ReplaceText' => [ 'Korvaa_teksti' ],
];

/** French (français) */
$specialPageAliases['fr'] = [
	'ReplaceText' => [ 'Remplacer_texte', 'RemplacerTexte' ],
];

/** Arpitan (arpetan) */
$specialPageAliases['frp'] = [
	'ReplaceText' => [ 'Remplaciér_lo_tèxto', 'RemplaciérLoTèxto' ],
];

/** Galician (galego) */
$specialPageAliases['gl'] = [
	'ReplaceText' => [ 'Substituír_o_texto', 'Substituír_texto' ],
];

/** Swiss German (Alemannisch) */
$specialPageAliases['gsw'] = [
	'ReplaceText' => [ 'Täxt_ersetze' ],
];

/** Hebrew (עברית) */
$specialPageAliases['he'] = [
	'ReplaceText' => [ 'החלפת_טקסט' ],
];

/** Croatian (hrvatski) */
$specialPageAliases['hr'] = [
	'ReplaceText' => [ 'Zamjeni_tekst' ],
];

/** Upper Sorbian (hornjoserbsce) */
$specialPageAliases['hsb'] = [
	'ReplaceText' => [ 'Tekst_narunać' ],
];

/** Haitian (Kreyòl ayisyen) */
$specialPageAliases['ht'] = [
	'ReplaceText' => [ 'RanplaseTeks' ],
];

/** Hungarian (magyar) */
$specialPageAliases['hu'] = [
	'ReplaceText' => [ 'Szöveg_csere' ],
];

/** Interlingua (interlingua) */
$specialPageAliases['ia'] = [
	'ReplaceText' => [ 'Reimplaciar_texto' ],
];

/** Indonesian (Bahasa Indonesia) */
$specialPageAliases['id'] = [
	'ReplaceText' => [ 'Ganti_teks', 'GantiTeks' ],
];

/** Italian (italiano) */
$specialPageAliases['it'] = [
	'ReplaceText' => [ 'SostituisciTesto' ],
];

/** Japanese (日本語) */
$specialPageAliases['ja'] = [
	'ReplaceText' => [ '文字列置換', '文字列の置換' ],
];

/** Khmer (ភាសាខ្មែរ) */
$specialPageAliases['km'] = [
	'ReplaceText' => [ 'ជំនួសអត្ថបទ' ],
];

/** Korean (한국어) */
$specialPageAliases['ko'] = [
	'ReplaceText' => [ '찾아바꾸기' ],
];

/** Colognian (Ripoarisch) */
$specialPageAliases['ksh'] = [
	'ReplaceText' => [ 'Tex tuusche' ],
];

/** Luxembourgish (Lëtzebuergesch) */
$specialPageAliases['lb'] = [
	'ReplaceText' => [ 'Text_ersetzen' ],
];

/** Macedonian (македонски) */
$specialPageAliases['mk'] = [
	'ReplaceText' => [ 'ЗамениТекст' ],
];

/** Malayalam (മലയാളം) */
$specialPageAliases['ml'] = [
	'ReplaceText' => [ 'എഴുത്ത്മാറ്റിച്ചേർക്കുക' ],
];

/** Marathi (मराठी) */
$specialPageAliases['mr'] = [
	'ReplaceText' => [ 'मजकुरबदला' ],
];

/** Malay (Bahasa Melayu) */
$specialPageAliases['ms'] = [
	'ReplaceText' => [ 'Ganti_teks' ],
];

/** Maltese (Malti) */
$specialPageAliases['mt'] = [
	'ReplaceText' => [ 'BiddelTest' ],
];

/** Norwegian Bokmål (norsk bokmål) */
$specialPageAliases['nb'] = [
	'ReplaceText' => [ 'Teksterstatning' ],
];

/** Low Saxon (Netherlands) (Nedersaksies) */
$specialPageAliases['nds-nl'] = [
	'ReplaceText' => [ 'Tekste_vervangen' ],
];

/** Dutch (Nederlands) */
$specialPageAliases['nl'] = [
	'ReplaceText' => [ 'TekstVervangen' ],
];

/** Occitan (occitan) */
$specialPageAliases['oc'] = [
	'ReplaceText' => [ 'Remplaçar tèxte', 'RemplaçarTèxte' ],
];

/** Portuguese (português) */
$specialPageAliases['pt'] = [
	'ReplaceText' => [ 'Substituir_texto' ],
];

/** Sicilian (sicilianu) */
$specialPageAliases['scn'] = [
	'ReplaceText' => [ 'SostituisciTesto' ],
];

/** Slovak (slovenčina) */
$specialPageAliases['sk'] = [
	'ReplaceText' => [ 'NahradiťText' ],
];

/** Albanian (shqip) */
$specialPageAliases['sq'] = [
	'ReplaceText' => [ 'ZëvendësoTekstin' ],
];

/** Serbian (Cyrillic script) (српски (ћирилица)‎) */
$specialPageAliases['sr-ec'] = [
	'ReplaceText' => [ 'ЗамениТекст', 'Замени_текст' ],
];

/** Swedish (svenska) */
$specialPageAliases['sv'] = [
	'ReplaceText' => [ 'Ersätt_text' ],
];

/** Swahili (Kiswahili) */
$specialPageAliases['sw'] = [
	'ReplaceText' => [ 'PandikiziaMatini' ],
];

/** Tagalog (Tagalog) */
$specialPageAliases['tl'] = [
	'ReplaceText' => [ 'Palitan_ang_teksto' ],
];

/** Turkish (Türkçe) */
$specialPageAliases['tr'] = [
	'ReplaceText' => [ 'MetniDeğiştir' ],
];

/** Ukrainian (українська) */
$specialPageAliases['uk'] = [
	'ReplaceText' => [ 'Замінити_текст' ],
];

/** Venetian (vèneto) */
$specialPageAliases['vec'] = [
	'ReplaceText' => [ 'SostuituissiTesto' ],
];

/** Vietnamese (Tiếng Việt) */
$specialPageAliases['vi'] = [
	'ReplaceText' => [ 'Thay_văn_bản' ],
];

/** Chinese (中文) */
$specialPageAliases['zh'] = [
	'ReplaceText' => [ '替换文本', '替換文本', '取代文字' ],
];

/** Simplified Chinese (中文（简体）‎) */
$specialPageAliases['zh-hans'] = [
	'ReplaceText' => [ '替换文本' ],
];

/** Traditional Chinese (中文（繁體）‎) */
$specialPageAliases['zh-hant'] = [
	'ReplaceText' => [ '替換文字' ],
];
