/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.osmand.data.Building;
import net.osmand.data.City;
import net.osmand.data.MapObject;
import net.osmand.util.Algorithms;

public class Street
extends MapObject {
    protected List<Building> buildings = new ArrayList<Building>();
    protected List<Street> intersectedStreets = null;
    protected final City city;

    public Street(City city) {
        this.city = city;
    }

    public void addBuilding(Building building) {
        this.buildings.add(building);
    }

    public List<Street> getIntersectedStreets() {
        if (this.intersectedStreets == null) {
            return Collections.emptyList();
        }
        return this.intersectedStreets;
    }

    public void addIntersectedStreet(Street s) {
        if (this.intersectedStreets == null) {
            this.intersectedStreets = new ArrayList<Street>();
        }
        this.intersectedStreets.add(s);
    }

    public void addBuildingCheckById(Building building) {
        for (Building b : this.buildings) {
            if (b.getId().longValue() != building.getId().longValue()) continue;
            return;
        }
        this.buildings.add(building);
    }

    public List<Building> getBuildings() {
        return this.buildings;
    }

    public City getCity() {
        return this.city;
    }

    public void sortBuildings() {
        Collections.sort(this.buildings, new Comparator<Building>(){

            @Override
            public int compare(Building o1, Building o2) {
                int i2;
                String s1 = o1.getName();
                String s2 = o2.getName();
                int i1 = Algorithms.extractFirstIntegerNumber(s1);
                if (i1 == (i2 = Algorithms.extractFirstIntegerNumber(s2))) {
                    String t1 = Algorithms.extractIntegerSuffix(s1);
                    String t2 = Algorithms.extractIntegerSuffix(s2);
                    return t1.compareTo(t2);
                }
                return i1 - i2;
            }
        });
    }

    public void mergeWith(Street street) {
        this.buildings.addAll(street.getBuildings());
        this.copyNames(street);
    }

    public String getNameWithoutCityPart(String lang) {
        String nm = this.getName(lang);
        int t = nm.lastIndexOf(40);
        if (t > 0) {
            return nm.substring(0, t);
        }
        return nm;
    }
}

