/*
 * Decompiled with CFR 0.152.
 */
package pdftk.com.lowagie.text.pdf;

import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.URL;
import pdftk.com.lowagie.text.pdf.BaseFont;

public class RandomAccessFileOrArray
implements DataInput {
    String filename = null;
    RandomAccessFile rf = null;
    byte[] arrayIn = null;
    int arrayInPtr = 0;
    private byte back = 0;
    private boolean isBack = false;
    private int startOffset = 0;

    public RandomAccessFileOrArray(String filename) throws IOException {
        this(filename, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RandomAccessFileOrArray(String filename, boolean forceRead) throws IOException {
        if (filename == null) {
            throw new IllegalArgumentException("null filename passed into RandomAccessFileOrArray()");
        }
        File file = new File(filename);
        if (!file.canRead()) {
            if (filename.startsWith("file:/") || filename.startsWith("http://") || filename.startsWith("https://") || filename.startsWith("jar:")) {
                InputStream is = new URL(filename).openStream();
                try {
                    this.inputStreamToArray(is);
                }
                finally {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            InputStream is = BaseFont.getResourceStream(filename);
            if (is == null) {
                throw new IOException(filename + " not found as file or resource.");
            }
            try {
                this.inputStreamToArray(is);
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (forceRead) {
            FileInputStream is = null;
            try {
                is = new FileInputStream(file);
                this.inputStreamToArray(is);
            }
            finally {
                try {
                    if (is != null) {
                        ((InputStream)is).close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        this.rf = new RandomAccessFile(file, "r");
        if (this.rf == null) {
            throw new IOException("Unable to open: " + filename);
        }
        this.filename = filename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RandomAccessFileOrArray(URL url) throws IOException {
        if (url == null) {
            throw new IllegalArgumentException("null url passed into RandomAccessFileOrArray()");
        }
        InputStream is = url.openStream();
        try {
            this.inputStreamToArray(is);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
    }

    public RandomAccessFileOrArray(InputStream is) throws IOException {
        this.inputStreamToArray(is);
    }

    public RandomAccessFileOrArray(byte[] arrayIn) {
        this.arrayIn = arrayIn;
    }

    public RandomAccessFileOrArray(RandomAccessFileOrArray file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("null file passed into RandomAccessFileOrArray() copy constructor");
        }
        if (file.filename != null) {
            this.filename = file.filename;
            this.rf = null;
        } else if (file.arrayIn != null) {
            this.arrayIn = file.arrayIn;
            this.arrayInPtr = 0;
        }
        this.startOffset = file.startOffset;
    }

    private void inputStreamToArray(InputStream is) throws IOException {
        byte[] bb = new byte[8192];
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int len = 0;
        while (1 < (len = is.read(bb))) {
            out.write(bb, 0, len);
        }
        this.arrayIn = out.toByteArray();
        this.arrayInPtr = 0;
    }

    public void pushBack(byte b) throws IOException {
        if (this.isBack) {
            throw new IOException("Tried to pushBack a byte when isBack is true.");
        }
        this.back = b;
        this.isBack = true;
    }

    public int popBack() {
        int retVal = -1;
        if (this.isBack) {
            retVal = this.back & 0xFF;
            this.back = 0;
            this.isBack = false;
        }
        return retVal;
    }

    public boolean isBack() {
        return this.isBack;
    }

    public int getBack() {
        return this.back & 0xFF;
    }

    public void clearBack() {
        this.back = 0;
        this.isBack = false;
    }

    public int read() throws IOException {
        int retVal = -1;
        if (this.isBack) {
            retVal = this.getBack();
            this.clearBack();
        } else if (this.rf != null) {
            retVal = this.rf.read();
        } else if (this.arrayIn != null && 0 <= this.arrayInPtr && this.arrayInPtr < this.arrayIn.length) {
            retVal = this.arrayIn[this.arrayInPtr++] & 0xFF;
        }
        return retVal;
    }

    public int read(byte[] bb, int off, int len) throws IOException {
        if (bb == null) {
            throw new IllegalArgumentException("read() argument bb is null.");
        }
        if (len == 0 || bb.length == 0) {
            return 0;
        }
        if (len < 0 || off < 0 || bb.length <= off || bb.length < off + len) {
            throw new IllegalArgumentException("read() arguments are out of bounds: len: " + len + " off: " + off + " bb.length: " + bb.length);
        }
        int retVal = -1;
        if (this.isBack) {
            bb[off++] = this.back;
            --len;
        }
        if (this.rf != null) {
            retVal = this.rf.read(bb, off, len);
        } else if (this.arrayIn != null && 0 <= this.arrayInPtr && this.arrayInPtr < this.arrayIn.length) {
            if (this.arrayIn.length < this.arrayInPtr + len) {
                len = this.arrayIn.length - this.arrayInPtr;
            }
            if (0 < len) {
                System.arraycopy(this.arrayIn, this.arrayInPtr, bb, off, len);
                this.arrayInPtr += len;
                retVal = len;
            }
        }
        if (this.isBack) {
            retVal = retVal == -1 ? 1 : ++retVal;
        }
        this.clearBack();
        return retVal;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public void readFully(byte[] bb, int off, int len) throws IOException {
        int nn = 0;
        for (int bytesRead = 0; bytesRead < len; bytesRead += nn) {
            nn = this.read(bb, off + bytesRead, len - bytesRead);
            if (nn >= 0) continue;
            throw new EOFException();
        }
    }

    @Override
    public void readFully(byte[] bb) throws IOException {
        this.readFully(bb, 0, bb.length);
    }

    public void reOpen() throws IOException {
        if (this.filename != null && this.rf == null) {
            this.rf = new RandomAccessFile(this.filename, "r");
            if (this.rf == null) {
                throw new IOException("Unable to reOpen: " + this.filename);
            }
        }
        this.seek(0);
    }

    protected void insureOpen() throws IOException {
        if (this.filename != null && this.rf == null) {
            this.reOpen();
        }
    }

    public boolean isOpen() {
        return this.filename == null || this.rf != null;
    }

    public void close() throws IOException {
        if (this.rf != null) {
            this.rf.close();
            this.rf = null;
        }
        this.clearBack();
    }

    public int length() throws IOException {
        if (this.filename != null) {
            this.insureOpen();
            return (int)this.rf.length() - this.startOffset;
        }
        if (this.arrayIn != null) {
            return this.arrayIn.length - this.startOffset;
        }
        return 0;
    }

    public int getFilePointer() throws IOException {
        int nn;
        this.insureOpen();
        int n = nn = this.isBack ? 1 : 0;
        if (this.filename != null) {
            return (int)this.rf.getFilePointer() - nn - this.startOffset;
        }
        if (this.arrayIn != null) {
            return this.arrayInPtr - nn - this.startOffset;
        }
        return 0;
    }

    public void seek(int pos) throws IOException {
        pos += this.startOffset;
        this.clearBack();
        if (this.filename != null) {
            if (this.rf == null) {
                this.rf = new RandomAccessFile(this.filename, "r");
                if (this.rf == null) {
                    throw new IOException("Unable to open: " + this.filename + " in seek()");
                }
            }
            this.rf.seek(pos);
        } else if (this.arrayIn != null) {
            this.arrayInPtr = pos;
        }
    }

    public void seek(long pos) throws IOException {
        this.seek((int)pos);
    }

    @Override
    public int skipBytes(int nn) throws IOException {
        int len;
        if (nn <= 0) {
            return 0;
        }
        if (nn == 1 && this.isBack) {
            this.clearBack();
            return 1;
        }
        int pos = this.getFilePointer();
        int newpos = pos + nn;
        if (newpos > (len = this.length())) {
            newpos = len;
        }
        this.seek(newpos);
        return newpos - pos;
    }

    public long skip(long n) throws IOException {
        return this.skipBytes((int)n);
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public void setStartOffset(int startOffset) throws IOException {
        this.startOffset = startOffset;
        this.seek(0);
    }

    @Override
    public boolean readBoolean() throws IOException {
        int ch = this.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return ch != 0;
    }

    @Override
    public byte readByte() throws IOException {
        int ch = this.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return (byte)ch;
    }

    @Override
    public int readUnsignedByte() throws IOException {
        int ch = this.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return ch;
    }

    @Override
    public short readShort() throws IOException {
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (short)((ch1 << 8) + ch2);
    }

    public final short readShortLE() throws IOException {
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (short)((ch2 << 8) + (ch1 << 0));
    }

    @Override
    public int readUnsignedShort() throws IOException {
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (ch1 << 8) + ch2;
    }

    public final int readUnsignedShortLE() throws IOException {
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (ch2 << 8) + (ch1 << 0);
    }

    @Override
    public char readChar() throws IOException {
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (char)((ch1 << 8) + ch2);
    }

    public final char readCharLE() throws IOException {
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (char)((ch2 << 8) + (ch1 << 0));
    }

    @Override
    public int readInt() throws IOException {
        int ch4;
        int ch3;
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read()) | (ch3 = this.read()) | (ch4 = this.read())) < 0) {
            throw new EOFException();
        }
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + ch4;
    }

    public final int readIntLE() throws IOException {
        int ch4;
        int ch3;
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read()) | (ch3 = this.read()) | (ch4 = this.read())) < 0) {
            throw new EOFException();
        }
        return (ch4 << 24) + (ch3 << 16) + (ch2 << 8) + (ch1 << 0);
    }

    public final long readUnsignedInt() throws IOException {
        long ch4;
        long ch3;
        long ch2;
        long ch1 = this.read();
        if ((ch1 | (ch2 = (long)this.read()) | (ch3 = (long)this.read()) | (ch4 = (long)this.read())) < 0L) {
            throw new EOFException();
        }
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    public final long readUnsignedIntLE() throws IOException {
        long ch4;
        long ch3;
        long ch2;
        long ch1 = this.read();
        if ((ch1 | (ch2 = (long)this.read()) | (ch3 = (long)this.read()) | (ch4 = (long)this.read())) < 0L) {
            throw new EOFException();
        }
        return (ch4 << 24) + (ch3 << 16) + (ch2 << 8) + (ch1 << 0);
    }

    @Override
    public long readLong() throws IOException {
        return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
    }

    public final long readLongLE() throws IOException {
        int i1 = this.readIntLE();
        int i2 = this.readIntLE();
        return ((long)i2 << 32) + ((long)i1 & 0xFFFFFFFFL);
    }

    @Override
    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public final float readFloatLE() throws IOException {
        return Float.intBitsToFloat(this.readIntLE());
    }

    @Override
    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public final double readDoubleLE() throws IOException {
        return Double.longBitsToDouble(this.readLongLE());
    }

    @Override
    public String readLine() throws IOException {
        StringBuffer input = new StringBuffer();
        int c = -1;
        boolean eol = false;
        block4: while (!eol) {
            c = this.read();
            switch (c) {
                case -1: 
                case 10: {
                    eol = true;
                    continue block4;
                }
                case 13: {
                    eol = true;
                    int cur = this.getFilePointer();
                    if (this.read() == 10) continue block4;
                    this.seek(cur);
                    continue block4;
                }
            }
            input.append((char)c);
        }
        if (c == -1 && input.length() == 0) {
            return null;
        }
        return input.toString();
    }

    @Override
    public String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }
}

