/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractFtile;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class FtileMarged
extends AbstractFtile {
    private final Ftile tile;
    private final double margin1;
    private final double margin2;

    public FtileMarged(Ftile tile, double margin1, double margin2) {
        super(tile.skinParam());
        this.tile = tile;
        this.margin1 = margin1;
        this.margin2 = margin2;
    }

    @Override
    public Collection<Ftile> getMyChildren() {
        return Collections.singleton(this.tile);
    }

    @Override
    public LinkRendering getInLinkRendering() {
        return this.tile.getInLinkRendering();
    }

    @Override
    public LinkRendering getOutLinkRendering() {
        return this.tile.getOutLinkRendering();
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        return this.tile.getSwimlanes();
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.tile.getSwimlaneIn();
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.tile.getSwimlaneOut();
    }

    @Override
    protected FtileGeometry calculateDimensionFtile(StringBounder stringBounder) {
        FtileGeometry orig = this.tile.calculateDimension(stringBounder);
        return new FtileGeometry(orig.getWidth() + this.margin1 + this.margin2, orig.getHeight(), orig.getLeft() + this.margin1, orig.getInY(), orig.getOutY());
    }

    @Override
    public UTranslate getTranslateFor(Ftile child, StringBounder stringBounder) {
        if (child == this.tile) {
            return this.getTranslate();
        }
        UTranslate result = this.tile.getTranslateFor(child, stringBounder);
        result = result.compose(this.getTranslate());
        return result;
    }

    private UTranslate getTranslate() {
        return UTranslate.dx(this.margin1);
    }

    @Override
    public void drawU(UGraphic ug) {
        ug.apply(this.getTranslate()).draw(this.tile);
    }
}

