/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.code;

import java.io.IOException;
import java.io.StringReader;
import net.sourceforge.plantuml.StringLocated;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.code.StringCompressor;
import net.sourceforge.plantuml.command.regex.Matcher2;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.command.regex.Pattern2;
import net.sourceforge.plantuml.preproc.ReadLineReader;
import net.sourceforge.plantuml.preproc.UncommentReadLine;

public class ArobaseStringCompressor
implements StringCompressor {
    private static final Pattern2 p = MyPattern.cmpile("(?s)(?i)^[%s]*(@startuml[^\\n\\r]*)?[%s]*(.*?)[%s]*(@enduml)?[%s]*$");

    @Override
    public String compress(String data) throws IOException {
        UncommentReadLine r = new UncommentReadLine(ReadLineReader.create(new StringReader(data), "COMPRESS"));
        StringBuilder sb = new StringBuilder();
        StringBuilder full = new StringBuilder();
        StringLocated s = null;
        boolean startDone = false;
        while ((s = r.readLine()) != null) {
            this.append(full, s);
            if (s.getString().startsWith("@startuml")) {
                startDone = true;
                continue;
            }
            if (s.getString().startsWith("@enduml")) {
                return sb.toString();
            }
            if (!startDone) continue;
            this.append(sb, s);
        }
        if (!startDone) {
            return this.compressOld(full.toString());
        }
        return sb.toString();
    }

    private void append(StringBuilder sb, StringLocated s) {
        if (sb.length() > 0) {
            sb.append('\n');
        }
        sb.append(s.getString());
    }

    private String compressOld(String s) throws IOException {
        Matcher2 m = p.matcher(s);
        if (m.find()) {
            return this.clean(m.group(2));
        }
        return "";
    }

    @Override
    public String decompress(String s) {
        String result = this.clean(s);
        if (result.startsWith("@start")) {
            return result;
        }
        result = "@startuml\n" + result;
        if (!result.endsWith("\n")) {
            result = result + "\n";
        }
        result = result + "@enduml";
        return result;
    }

    private String clean(String s) {
        s = StringUtils.trin(s);
        s = this.clean1(s);
        s = s.replaceAll("@enduml[^\\n\\r]*", "");
        s = s.replaceAll("@startuml[^\\n\\r]*", "");
        s = StringUtils.trin(s);
        return s;
    }

    private String clean1(String s) {
        Matcher2 m = p.matcher(s);
        if (m.matches()) {
            return m.group(2);
        }
        return s;
    }
}

