/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.UmlDiagram;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.api.ImageDataSimple;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.creole.CreoleMode;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.CodeImpl;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.EntityGender;
import net.sourceforge.plantuml.cucadiagram.EntityPortion;
import net.sourceforge.plantuml.cucadiagram.EntityPosition;
import net.sourceforge.plantuml.cucadiagram.EntityUtils;
import net.sourceforge.plantuml.cucadiagram.GroupHierarchy;
import net.sourceforge.plantuml.cucadiagram.GroupType;
import net.sourceforge.plantuml.cucadiagram.HideOrShow2;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.IGroup;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.Ident;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.LinkConstraint;
import net.sourceforge.plantuml.cucadiagram.Magma;
import net.sourceforge.plantuml.cucadiagram.MagmaList;
import net.sourceforge.plantuml.cucadiagram.NamespaceStrategy;
import net.sourceforge.plantuml.cucadiagram.PortionShower;
import net.sourceforge.plantuml.cucadiagram.SuperGroup;
import net.sourceforge.plantuml.cucadiagram.dot.CucaDiagramTxtMaker;
import net.sourceforge.plantuml.cucadiagram.entity.EntityFactory;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.jdot.CucaDiagramFileMakerJDot;
import net.sourceforge.plantuml.security.SecurityUtils;
import net.sourceforge.plantuml.skin.VisibilityModifier;
import net.sourceforge.plantuml.statediagram.StateDiagram;
import net.sourceforge.plantuml.svek.CucaDiagramFileMaker;
import net.sourceforge.plantuml.svek.CucaDiagramFileMakerSvek;
import net.sourceforge.plantuml.ugraphic.color.ColorMapper;
import net.sourceforge.plantuml.xmi.CucaDiagramXmiMaker;
import net.sourceforge.plantuml.xmlsc.StateDiagramScxmlMaker;

public abstract class CucaDiagram
extends UmlDiagram
implements GroupHierarchy,
PortionShower {
    private static final boolean G1972 = false;
    private String namespaceSeparator = null;
    private boolean namespaceSeparatorHasBeenSet = false;
    private int horizontalPages = 1;
    private int verticalPages = 1;
    private final List<HideOrShow2> hides2 = new ArrayList<HideOrShow2>();
    private final List<HideOrShow2> removed = new ArrayList<HideOrShow2>();
    protected final EntityFactory entityFactory = new EntityFactory(this.hides2, this.removed, this);
    private IGroup currentGroup = this.entityFactory.getRootGroup();
    private List<Ident> stacks2 = new ArrayList<Ident>();
    private List<IGroup> stacks = new ArrayList<IGroup>();
    private boolean visibilityModifierPresent;
    private String warningOrError;
    private final List<HideOrShow> hideOrShows = new ArrayList<HideOrShow>();
    private final Set<VisibilityModifier> hides = new HashSet<VisibilityModifier>();
    private ILeaf lastEntity = null;

    public final boolean V1972() {
        if (this.getPragma().backToLegacyPackage()) {
            return false;
        }
        return this.getPragma().useNewPackage();
    }

    public final boolean mergeIntricated() {
        if (this.getNamespaceSeparator() == null) {
            return false;
        }
        return this.V1972() && this.getUmlDiagramType() == UmlDiagramType.CLASS;
    }

    @Override
    public Set<SuperGroup> getAllSuperGroups() {
        return this.entityFactory.getAllSuperGroups();
    }

    public abstract IEntity getOrCreateLeaf(Ident var1, Code var2, LeafType var3, USymbol var4);

    public Ident cleanIdent(Ident ident) {
        return ident;
    }

    public CucaDiagram(ISkinSimple orig) {
        super(orig);
        this.stacks2.add(Ident.empty());
    }

    private Ident getLastID() {
        if (this.stacks2.size() == 0) {
            return Ident.empty();
        }
        return this.stacks2.get(this.stacks2.size() - 1);
    }

    public final void setNamespaceSeparator(String namespaceSeparator) {
        this.namespaceSeparatorHasBeenSet = true;
        this.namespaceSeparator = namespaceSeparator;
    }

    public final String getNamespaceSeparator() {
        if (!this.namespaceSeparatorHasBeenSet) {
            return this.V1972() ? "::" : ".";
        }
        return this.namespaceSeparator;
    }

    @Override
    public boolean hasUrl() {
        for (IEntity iEntity : this.getGroups(true)) {
            if (!iEntity.hasUrl()) continue;
            return true;
        }
        for (IEntity iEntity : this.entityFactory.leafs()) {
            if (!iEntity.hasUrl()) continue;
            return true;
        }
        for (Link link : this.getLinks()) {
            if (!link.hasUrl()) continue;
            return true;
        }
        return false;
    }

    public final void setLastEntity(ILeaf foo) {
        this.lastEntity = foo;
    }

    protected final ILeaf getOrCreateLeafDefault(Ident idNewLong, Code code, LeafType type, USymbol symbol) {
        this.checkNotNull(idNewLong);
        if (type == null) {
            throw new IllegalArgumentException();
        }
        ILeaf result = this.V1972() ? this.entityFactory.getLeafStrict(idNewLong) : this.entityFactory.getLeaf(code);
        if (result == null) {
            result = this.createLeafInternal(idNewLong, code, Display.getWithNewlines(code), type, symbol);
            result.setUSymbol(symbol);
        }
        if (result.getLeafType() == LeafType.CLASS && type == LeafType.OBJECT && !result.muteToType(type, symbol)) {
            return null;
        }
        this.lastEntity = result;
        return result;
    }

    public ILeaf createLeaf(Ident idNewLong, Code code, Display display, LeafType type, USymbol symbol) {
        this.checkNotNull(idNewLong);
        if (this.entityFactory.getLeafStrict(idNewLong) != null) {
            return null;
        }
        return this.createLeafInternal(idNewLong, code, display, type, symbol);
    }

    protected final ILeaf createLeafInternal(Ident newIdent, Code code, Display display, LeafType type, USymbol symbol) {
        this.checkNotNull(newIdent);
        if (Display.isNull(display)) {
            display = Display.getWithNewlines(code).withCreoleMode(CreoleMode.SIMPLE_LINE);
        }
        ILeaf leaf = this.entityFactory.createLeaf(newIdent, code, display, type, this.getCurrentGroup(), this.getHides(), this.getNamespaceSeparator());
        this.entityFactory.addLeaf(leaf);
        this.lastEntity = leaf;
        leaf.setUSymbol(symbol);
        return leaf;
    }

    public final Ident buildLeafIdent(String id) {
        return this.getLastID().add(id, this.getNamespaceSeparator());
    }

    public final Ident buildLeafIdentSpecial(String id) {
        return this.buildFullyQualified(id);
    }

    private Ident buildLeafIdentSpecialUnused(String id) {
        return Ident.empty().add(id, ".");
    }

    public final Ident buildFullyQualified(String id) {
        return this.entityFactory.buildFullyQualified(this.getLastID(), Ident.empty().add(id, this.getNamespaceSeparator()));
    }

    public final Code buildCode(String s) {
        if (this.V1972()) {
            throw new UnsupportedOperationException();
        }
        return CodeImpl.of(s);
    }

    protected final void checkNotNull(Object id) {
        if (id == null) {
            throw new IllegalArgumentException();
        }
    }

    public boolean leafExist(Code code) {
        if (this.V1972()) {
            throw new UnsupportedOperationException();
        }
        return this.entityFactory.getLeaf(code) != null;
    }

    public boolean leafExistSmart(Ident ident) {
        return this.entityFactory.getLeafSmart(ident) != null;
    }

    public boolean leafExistStrict(Ident ident) {
        return this.entityFactory.getLeafStrict(ident) != null;
    }

    @Override
    public final Collection<IGroup> getChildrenGroups(IGroup parent) {
        if (this.V1972()) {
            return this.getChildrenGroupsIdent1972(parent);
        }
        ArrayList<IGroup> result = new ArrayList<IGroup>();
        for (IGroup gg : this.getGroups(false)) {
            if (gg.getParentContainer() != parent) continue;
            result.add(gg);
        }
        return Collections.unmodifiableCollection(result);
    }

    private Collection<IGroup> getChildrenGroupsIdent1972(IGroup parent) {
        ArrayList<IGroup> result = new ArrayList<IGroup>();
        for (IGroup gg : this.entityFactory.groups2()) {
            if (!gg.getIdent().parent().equals(parent.getIdent())) continue;
            result.add(gg);
        }
        return Collections.unmodifiableCollection(result);
    }

    public final void gotoGroup(Ident ident, Code code, Display display, GroupType type, IGroup parent, NamespaceStrategy strategy) {
        if (this.V1972()) {
            this.gotoGroupInternalWithNamespace(ident, code, display, code, type, parent);
            return;
        }
        if (strategy == NamespaceStrategy.MULTIPLE) {
            if (this.getNamespaceSeparator() != null) {
                code = this.getFullyQualifiedCode1972(code);
            }
            this.gotoGroupInternalWithNamespace(ident, code, display, code, type, parent);
        } else if (strategy == NamespaceStrategy.SINGLE) {
            Ident newIdLong = this.buildLeafIdentSpecial(ident.toString(this.getNamespaceSeparator()));
            this.gotoGroupExternal(newIdLong, code, display, null, type, parent);
            this.stacks2.add(newIdLong);
        } else {
            throw new IllegalArgumentException();
        }
    }

    protected final String getNamespace1972(Code fullyCode, String separator) {
        int x;
        String name = fullyCode.getName();
        if (separator == null) {
            throw new IllegalArgumentException(this.toString());
        }
        do {
            if ((x = name.lastIndexOf(separator)) != -1) continue;
            return null;
        } while (this.entityFactory.getLeaf(this.buildCode(name = name.substring(0, x))) != null);
        return name;
    }

    private void gotoGroupInternalWithNamespace(Ident idNewLong, Code code, Display display, Code namespaceNew, GroupType type, IGroup parent) {
        this.stacks.add(this.currentGroup);
        this.stacks2.add(idNewLong);
        if (this.V1972()) {
            this.gotoGroupInternal(idNewLong, code, display, namespaceNew, type, parent);
            return;
        }
        if (this.getNamespaceSeparator() == null) {
            this.gotoGroupInternal(idNewLong, code, display, namespaceNew, type, parent);
            return;
        }
        String namespaceCurrent = this.getNamespace1972(code, this.getNamespaceSeparator());
        if (namespaceCurrent == null) {
            this.gotoGroupInternal(idNewLong, code, display, namespaceNew, type, parent);
            return;
        }
        IGroup realParent = this.entityFactory.getGroup(this.buildCode(namespaceCurrent));
        if (realParent == null) {
            this.gotoGroupInternal(idNewLong, code, display, namespaceNew, type, parent);
            return;
        }
        display = Display.create(idNewLong.getLast());
        IGroup result = this.entityFactory.createGroup(idNewLong, code, display, namespaceNew, type, realParent, this.getHides(), this.getNamespaceSeparator());
        this.entityFactory.addGroup(result);
        this.currentGroup = result;
    }

    public void endGroup() {
        if (this.stacks2.size() > 0) {
            this.stacks2.remove(this.stacks2.size() - 1);
        }
        if (EntityUtils.groupRoot(this.currentGroup)) {
            Log.error("No parent group");
            return;
        }
        this.currentGroup = this.stacks.size() > 0 ? this.stacks.remove(this.stacks.size() - 1) : this.currentGroup.getParentContainer();
    }

    private void gotoGroupInternal(Ident idNewLong, Code code, Display display, Code namespace, GroupType type, IGroup parent) {
        if (this.V1972()) {
            this.gotoGroupInternal1972(idNewLong, code, display, namespace, type, parent);
            return;
        }
        IGroup result = this.entityFactory.getGroup(code);
        if (result != null) {
            this.currentGroup = result;
            return;
        }
        if (this.entityFactory.getLeafStrict(idNewLong) != null) {
            result = this.entityFactory.muteToGroup(code.getName(), namespace, type, parent);
            result.setDisplay(display);
        } else {
            result = this.entityFactory.createGroup(idNewLong, code, display, namespace, type, parent, this.getHides(), this.getNamespaceSeparator());
        }
        this.entityFactory.addGroup(result);
        this.currentGroup = result;
    }

    private void gotoGroupInternal1972(Ident idNewLong, Code code, Display display, Code namespace, GroupType type, IGroup parent) {
        boolean mutation;
        IGroup result = this.entityFactory.getGroupStrict(idNewLong);
        if (result != null) {
            this.currentGroup = result;
            return;
        }
        if (this.getNamespaceSeparator() == null) {
            mutation = this.entityFactory.getLeafVerySmart(idNewLong) != null;
        } else {
            boolean bl = mutation = this.entityFactory.getLeafStrict(idNewLong) != null;
        }
        if (mutation) {
            result = this.entityFactory.muteToGroup1972(idNewLong, namespace, type, parent);
            result.setDisplay(display);
        } else {
            result = this.entityFactory.createGroup(idNewLong, code, display, namespace, type, parent, this.getHides(), this.getNamespaceSeparator());
        }
        this.entityFactory.addGroup(result);
        this.currentGroup = result;
        this.stacks2.set(this.stacks2.size() - 1, result.getIdent());
    }

    protected final void gotoGroupExternal(Ident newIdLong, Code code, Display display, Code namespace, GroupType type, IGroup parent) {
        IGroup result = this.entityFactory.getGroup(code);
        if (result != null) {
            this.currentGroup = result;
            return;
        }
        if (this.entityFactory.getLeaf(code) != null) {
            result = this.entityFactory.muteToGroup(code.getName(), namespace, type, parent);
            result.setDisplay(display);
        } else {
            result = this.entityFactory.createGroup(newIdLong, code, display, namespace, type, parent, this.getHides(), this.getNamespaceSeparator());
        }
        this.entityFactory.addGroup(result);
        this.currentGroup = result;
    }

    public final void gotoThisGroup(IGroup group) {
        this.currentGroup = group;
    }

    protected final Code getFullyQualifiedCode1972(Code code) {
        String separator = this.getNamespaceSeparator();
        if (separator == null) {
            throw new IllegalArgumentException();
        }
        String full = code.getName();
        if (full.startsWith(separator)) {
            return this.buildCode(full.substring(separator.length()));
        }
        if (full.contains(separator)) {
            return this.buildCode(full);
        }
        if (EntityUtils.groupRoot(this.currentGroup)) {
            return this.buildCode(full);
        }
        Code namespace = this.currentGroup.getNamespace();
        if (namespace == null) {
            return this.buildCode(full);
        }
        return this.buildCode(namespace.getName() + separator + full);
    }

    public final IGroup getCurrentGroup() {
        return this.currentGroup;
    }

    public final IGroup getGroup(Code code) {
        IGroup p = this.entityFactory.getGroup(code);
        if (p == null) {
            throw new IllegalArgumentException();
        }
        return p;
    }

    public final IGroup getGroupStrict(Ident ident) {
        if (!this.V1972()) {
            throw new UnsupportedOperationException();
        }
        IGroup p = this.entityFactory.getGroupStrict(ident);
        if (p == null) {
            throw new IllegalArgumentException();
        }
        return p;
    }

    public final IGroup getGroupVerySmart(Ident ident) {
        if (!this.V1972()) {
            throw new UnsupportedOperationException();
        }
        IGroup p = this.entityFactory.getGroupVerySmart(ident);
        if (p == null) {
            throw new IllegalArgumentException();
        }
        return p;
    }

    public final boolean isGroup(Code code) {
        if (this.V1972()) {
            return this.isGroupStrict((Ident)code);
        }
        return !this.leafExist(code) && this.entityFactory.getGroup(code) != null;
    }

    public final boolean isGroupStrict(Ident ident) {
        if (!this.V1972()) {
            throw new UnsupportedOperationException();
        }
        return !this.leafExistStrict(ident) && this.entityFactory.getGroupStrict(ident) != null;
    }

    public final boolean isGroupVerySmart(Ident ident) {
        if (!this.V1972()) {
            throw new UnsupportedOperationException();
        }
        return !this.leafExistSmart(ident) && this.entityFactory.getGroupVerySmart(ident) != null;
    }

    public final Collection<IGroup> getGroups(boolean withRootGroup) {
        if (!withRootGroup) {
            return this.entityFactory.groups();
        }
        ArrayList<IGroup> result = new ArrayList<IGroup>();
        result.add(this.getRootGroup());
        result.addAll(this.entityFactory.groups());
        return Collections.unmodifiableCollection(result);
    }

    @Override
    public IGroup getRootGroup() {
        return this.entityFactory.getRootGroup();
    }

    @Override
    public SuperGroup getRootSuperGroup() {
        return this.entityFactory.getRootSuperGroup();
    }

    public final Collection<ILeaf> getLeafsvalues() {
        return this.entityFactory.leafs2();
    }

    public final int getLeafssize() {
        return this.getLeafsvalues().size();
    }

    public final ILeaf getLeaf(Code code) {
        return this.entityFactory.getLeaf(code);
    }

    public final ILeaf getLeafStrict(Ident ident) {
        return this.entityFactory.getLeafStrict(ident);
    }

    public final ILeaf getLeafSmart(Ident ident) {
        return this.entityFactory.getLeafSmart(ident);
    }

    public ILeaf getLeafVerySmart(Ident ident) {
        return this.entityFactory.getLeafVerySmart(ident);
    }

    public final void addLink(Link link) {
        this.entityFactory.addLink(link);
    }

    protected final void removeLink(Link link) {
        this.entityFactory.removeLink(link);
    }

    public final List<Link> getLinks() {
        return this.entityFactory.getLinks();
    }

    public final int getHorizontalPages() {
        return this.horizontalPages;
    }

    public final void setHorizontalPages(int horizontalPages) {
        this.horizontalPages = horizontalPages;
    }

    public final int getVerticalPages() {
        return this.verticalPages;
    }

    public final void setVerticalPages(int verticalPages) {
        this.verticalPages = verticalPages;
    }

    @Override
    public int getNbImages() {
        return this.horizontalPages * this.verticalPages;
    }

    protected abstract List<String> getDotStrings();

    public final String[] getDotStringSkek() {
        String ratio;
        ArrayList<String> result = new ArrayList<String>();
        for (String s : this.getDotStrings()) {
            if (!s.startsWith("nodesep") && !s.startsWith("ranksep")) continue;
            result.add(s);
        }
        String aspect = this.getPragma().getValue("aspect");
        if (aspect != null) {
            result.add("aspect=" + aspect + ";");
        }
        if ((ratio = this.getPragma().getValue("ratio")) != null) {
            result.add("ratio=" + ratio + ";");
        }
        return result.toArray(new String[result.size()]);
    }

    private void createFilesXmi(OutputStream suggestedFile, FileFormat fileFormat) throws IOException {
        CucaDiagramXmiMaker maker = new CucaDiagramXmiMaker(this, fileFormat);
        maker.createFiles(suggestedFile);
    }

    private void createFilesScxml(OutputStream suggestedFile) throws IOException {
        StateDiagramScxmlMaker maker = new StateDiagramScxmlMaker((StateDiagram)this);
        maker.createFiles(suggestedFile);
    }

    @Override
    protected ImageData exportDiagramInternal(OutputStream os, int index, FileFormatOption fileFormatOption) throws IOException {
        FileFormat fileFormat = fileFormatOption.getFileFormat();
        if (fileFormat == FileFormat.ATXT || fileFormat == FileFormat.UTXT) {
            try {
                this.createFilesTxt(os, index, fileFormat);
            }
            catch (Throwable t) {
                t.printStackTrace(SecurityUtils.createPrintStream(os));
            }
            return ImageDataSimple.ok();
        }
        if (fileFormat.name().startsWith("XMI")) {
            this.createFilesXmi(os, fileFormat);
            return ImageDataSimple.ok();
        }
        if (fileFormat == FileFormat.SCXML) {
            this.createFilesScxml(os);
            return ImageDataSimple.ok();
        }
        if (this.getUmlDiagramType() == UmlDiagramType.COMPOSITE) {
            throw new UnsupportedOperationException();
        }
        this.entityFactory.buildSuperGroups();
        CucaDiagramFileMaker maker = this.isUseJDot() ? new CucaDiagramFileMakerJDot(this, fileFormatOption.getDefaultStringBounder()) : new CucaDiagramFileMakerSvek(this);
        ImageData result = maker.createFile(os, this.getDotStrings(), fileFormatOption);
        if (result == null) {
            return ImageDataSimple.error();
        }
        this.warningOrError = result.getWarningOrError();
        return result;
    }

    @Override
    public String getWarningOrError() {
        String generalWarningOrError = super.getWarningOrError();
        if (this.warningOrError == null) {
            return generalWarningOrError;
        }
        if (generalWarningOrError == null) {
            return this.warningOrError;
        }
        return generalWarningOrError + "\n" + this.warningOrError;
    }

    private void createFilesTxt(OutputStream os, int index, FileFormat fileFormat) throws IOException {
        CucaDiagramTxtMaker maker = new CucaDiagramTxtMaker(this, fileFormat);
        maker.createFiles(os, index);
    }

    public boolean isAutarkic(IGroup g) {
        if (g.getGroupType() == GroupType.PACKAGE) {
            return false;
        }
        if (g.getGroupType() == GroupType.INNER_ACTIVITY) {
            return true;
        }
        if (g.getGroupType() == GroupType.CONCURRENT_ACTIVITY) {
            return true;
        }
        if (g.getGroupType() == GroupType.CONCURRENT_STATE) {
            return true;
        }
        if (this.getChildrenGroups(g).size() > 0) {
            return false;
        }
        for (Link link : this.getLinks()) {
            if (EntityUtils.isPureInnerLink3(g, link)) continue;
            return false;
        }
        for (ILeaf leaf : g.getLeafsDirect()) {
            if (leaf.getEntityPosition() == EntityPosition.NORMAL) continue;
            return false;
        }
        return true;
    }

    private static boolean isNumber(String s) {
        return s.matches("[+-]?(\\.?\\d+|\\d+\\.\\d*)");
    }

    public void resetPragmaLabel() {
        this.getPragma().undefine("labeldistance");
        this.getPragma().undefine("labelangle");
    }

    public String getLabeldistance() {
        String s;
        if (this.getPragma().isDefine("labeldistance") && CucaDiagram.isNumber(s = this.getPragma().getValue("labeldistance"))) {
            return s;
        }
        if (this.getPragma().isDefine("defaultlabeldistance") && CucaDiagram.isNumber(s = this.getPragma().getValue("defaultlabeldistance"))) {
            return s;
        }
        return "1.7";
    }

    public String getLabelangle() {
        String s;
        if (this.getPragma().isDefine("labelangle") && CucaDiagram.isNumber(s = this.getPragma().getValue("labelangle"))) {
            return s;
        }
        if (this.getPragma().isDefine("defaultlabelangle") && CucaDiagram.isNumber(s = this.getPragma().getValue("defaultlabelangle"))) {
            return s;
        }
        return "25";
    }

    @Override
    public final boolean isEmpty(IGroup gToTest) {
        for (IEntity iEntity : this.getGroups(false)) {
            if (iEntity == gToTest || iEntity.getParentContainer() != gToTest) continue;
            return false;
        }
        return gToTest.size() == 0;
    }

    public final boolean isVisibilityModifierPresent() {
        return this.visibilityModifierPresent;
    }

    public final void setVisibilityModifierPresent(boolean visibilityModifierPresent) {
        this.visibilityModifierPresent = visibilityModifierPresent;
    }

    @Override
    public final boolean showPortion(EntityPortion portion, IEntity entity) {
        if (this.getSkinParam().strictUmlStyle() && portion == EntityPortion.CIRCLED_CHARACTER) {
            return false;
        }
        boolean result = true;
        for (HideOrShow cmd : this.hideOrShows) {
            if (cmd.portion != portion || !cmd.gender.contains(entity)) continue;
            result = cmd.show;
        }
        return result;
    }

    public final void hideOrShow(EntityGender gender, EntityPortion portions, boolean show) {
        for (EntityPortion portion : portions.asSet()) {
            this.hideOrShows.add(new HideOrShow(gender, portion, show));
        }
    }

    public void hideOrShow(Set<VisibilityModifier> visibilities, boolean show) {
        if (show) {
            this.hides.removeAll(visibilities);
        } else {
            this.hides.addAll(visibilities);
        }
    }

    public void hideOrShow2(String what, boolean show) {
        this.hides2.add(new HideOrShow2(what, show));
    }

    public void removeOrRestore(String what, boolean show) {
        this.removed.add(new HideOrShow2(what, show));
    }

    public final Set<VisibilityModifier> getHides() {
        return Collections.unmodifiableSet(this.hides);
    }

    public ColorMapper getColorMapper() {
        return this.getSkinParam().getColorMapper();
    }

    public final boolean isStandalone(IEntity ent) {
        for (Link link : this.getLinks()) {
            if (link.getEntity1() != ent && link.getEntity2() != ent) continue;
            return false;
        }
        return true;
    }

    public final Link getLastLink() {
        List<Link> links = this.getLinks();
        for (int i = links.size() - 1; i >= 0; --i) {
            Link link = links.get(i);
            if (link.getEntity1().getLeafType() == LeafType.NOTE || link.getEntity2().getLeafType() == LeafType.NOTE) continue;
            return link;
        }
        return null;
    }

    public final List<Link> getTwoLastLinks() {
        ArrayList<Link> result = new ArrayList<Link>();
        List<Link> links = this.getLinks();
        for (int i = links.size() - 1; i >= 0; --i) {
            Link link = links.get(i);
            if (link.getEntity1().getLeafType() == LeafType.NOTE || link.getEntity2().getLeafType() == LeafType.NOTE) continue;
            result.add(link);
            if (result.size() != 2) continue;
            return Collections.unmodifiableList(result);
        }
        return null;
    }

    public final ILeaf getLastEntity() {
        return this.lastEntity;
    }

    public final EntityFactory getEntityFactory() {
        return this.entityFactory;
    }

    public void applySingleStrategy() {
        MagmaList magmaList = new MagmaList();
        for (IGroup g : this.getGroups(true)) {
            ArrayList<ILeaf> standalones = new ArrayList<ILeaf>();
            for (ILeaf ent : g.getLeafsDirect()) {
                if (!this.isStandalone(ent)) continue;
                standalones.add(ent);
            }
            if (standalones.size() < 3) continue;
            Magma magma = new Magma(this, standalones);
            magma.putInSquare();
            magmaList.add(magma);
        }
        for (IGroup g : this.getGroups(true)) {
            MagmaList magmas = magmaList.getMagmas(g);
            if (magmas.size() < 3) continue;
            magmas.putInSquare();
        }
    }

    public boolean isHideEmptyDescriptionForState() {
        return false;
    }

    protected void incRawLayout() {
        this.entityFactory.incRawLayout();
    }

    public CommandExecutionResult constraintOnLinks(Link link1, Link link2, Display display) {
        LinkConstraint linkConstraint = new LinkConstraint(link1, link2, display);
        link1.setLinkConstraint(linkConstraint);
        link2.setLinkConstraint(linkConstraint);
        return CommandExecutionResult.ok();
    }

    static class HideOrShow {
        private final EntityGender gender;
        private final EntityPortion portion;
        private final boolean show;

        public HideOrShow(EntityGender gender, EntityPortion portion, boolean show) {
            this.gender = gender;
            this.portion = portion;
            this.show = show;
        }
    }
}

