/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.SkinParameter;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UGraphicStencil;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

class USymbolCollections
extends USymbol {
    private final SkinParameter skinParameter;

    public USymbolCollections(SkinParameter skinParameter) {
        this.skinParameter = skinParameter;
    }

    @Override
    public SkinParameter getSkinParameter() {
        return this.skinParameter;
    }

    private void drawCollections(UGraphic ug, double width, double height, boolean shadowing, double roundCorner) {
        URectangle small = new URectangle(width - this.getDeltaCollection(), height - this.getDeltaCollection()).rounded(roundCorner);
        if (shadowing) {
            small.setDeltaShadow(3.0);
        }
        ug.apply(new UTranslate(this.getDeltaCollection(), this.getDeltaCollection())).draw(small);
        small.setDeltaShadow(0.0);
        ug.apply(UTranslate.dy(0.0)).draw(small);
    }

    private USymbol.Margin getMargin() {
        return new USymbol.Margin(10.0, 10.0, 10.0, 10.0);
    }

    private double getDeltaCollection() {
        return 4.0;
    }

    @Override
    public TextBlock asSmall(TextBlock name, final TextBlock label, final TextBlock stereotype, final SymbolContext symbolContext, final HorizontalAlignment stereoAlignment) {
        return new AbstractTextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                Dimension2D dim = this.calculateDimension(ug.getStringBounder());
                ug = UGraphicStencil.create(ug, USymbolCollections.this.getRectangleStencil(dim), new UStroke());
                ug = symbolContext.apply(ug);
                USymbolCollections.this.drawCollections(ug, dim.getWidth(), dim.getHeight(), symbolContext.isShadowing(), symbolContext.getRoundCorner());
                USymbol.Margin margin = USymbolCollections.this.getMargin();
                TextBlock tb = TextBlockUtils.mergeTB(stereotype, label, stereoAlignment);
                tb.drawU(ug.apply(new UTranslate(margin.getX1() - USymbolCollections.this.getDeltaCollection() / 2.0, margin.getY1() - USymbolCollections.this.getDeltaCollection() / 2.0)));
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                Dimension2D dimLabel = label.calculateDimension(stringBounder);
                Dimension2D dimStereo = stereotype.calculateDimension(stringBounder);
                return USymbolCollections.this.getMargin().addDimension(Dimension2DDouble.mergeTB(dimStereo, dimLabel));
            }
        };
    }

    @Override
    public TextBlock asBig(final TextBlock title, HorizontalAlignment labelAlignment, final TextBlock stereotype, final double width, final double height, final SymbolContext symbolContext, final HorizontalAlignment stereoAlignment) {
        return new AbstractTextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                double posStereoY;
                double posStereoX;
                Dimension2D dim = this.calculateDimension(ug.getStringBounder());
                ug = symbolContext.apply(ug);
                USymbolCollections.this.drawCollections(ug, dim.getWidth(), dim.getHeight(), symbolContext.isShadowing(), symbolContext.getRoundCorner());
                Dimension2D dimStereo = stereotype.calculateDimension(ug.getStringBounder());
                if (stereoAlignment == HorizontalAlignment.RIGHT) {
                    posStereoX = width - dimStereo.getWidth() - USymbolCollections.this.getMargin().getX1() / 2.0;
                    posStereoY = USymbolCollections.this.getMargin().getY1() / 2.0;
                } else {
                    posStereoX = (width - dimStereo.getWidth()) / 2.0;
                    posStereoY = 2.0;
                }
                stereotype.drawU(ug.apply(new UTranslate(posStereoX, posStereoY)));
                Dimension2D dimTitle = title.calculateDimension(ug.getStringBounder());
                double posTitle = (width - dimTitle.getWidth()) / 2.0;
                title.drawU(ug.apply(new UTranslate(posTitle, 2.0 + dimStereo.getHeight())));
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                return new Dimension2DDouble(width, height);
            }
        };
    }

    @Override
    public boolean manageHorizontalLine() {
        return true;
    }
}

