/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.time;

import java.util.Date;
import net.sourceforge.plantuml.project.lang.Complement;
import net.sourceforge.plantuml.project.lang.Subject;
import net.sourceforge.plantuml.project.time.DayOfWeek;
import net.sourceforge.plantuml.project.time.Month;
import net.sourceforge.plantuml.project.time.MonthYear;
import net.sourceforge.plantuml.project.time.Wink;

public class Day
implements Complement,
Comparable<Day>,
Subject {
    private final int dayOfMonth;
    private final MonthYear monthYear;

    public static Day create(int year, String month, int dayOfMonth) {
        return new Day(year, Month.fromString(month), dayOfMonth);
    }

    public static Day create(int year, int month, int dayOfMonth) {
        return new Day(year, Month.values()[month - 1], dayOfMonth);
    }

    public static Day today() {
        Date now = new Date();
        int year = now.getYear() + 1900;
        int month = now.getMonth() + 1;
        int dayOfMonth = now.getDate();
        return Day.create(year, month, dayOfMonth);
    }

    private Day(int year, Month month, int dayOfMonth) {
        this(MonthYear.create(year, month), dayOfMonth);
    }

    private Day(MonthYear monthYear, int dayOfMonth) {
        this.dayOfMonth = dayOfMonth;
        this.monthYear = monthYear;
    }

    public int year() {
        return this.monthYear.year();
    }

    private int internalNumber() {
        return this.year() * 100 * 100 + this.month().ordinal() * 100 + this.dayOfMonth;
    }

    public String toString() {
        return this.monthYear.toString() + "/" + this.dayOfMonth;
    }

    public int hashCode() {
        return this.monthYear.hashCode() + this.dayOfMonth * 17;
    }

    public boolean equals(Object obj) {
        Day other = (Day)obj;
        return other.internalNumber() == this.internalNumber();
    }

    public final int getDayOfMonth() {
        return this.dayOfMonth;
    }

    private int daysPerMonth() {
        return this.month().getDaysPerMonth(this.year());
    }

    public Day next() {
        int newDayOfMonth = this.dayOfMonth + 1;
        if (newDayOfMonth <= this.daysPerMonth()) {
            return new Day(this.year(), this.month(), newDayOfMonth);
        }
        assert (newDayOfMonth > this.daysPerMonth());
        return new Day(this.monthYear.next(), 1);
    }

    public Month month() {
        return this.monthYear.month();
    }

    public MonthYear monthYear() {
        return this.monthYear;
    }

    public DayOfWeek getDayOfWeek() {
        int q = this.dayOfMonth;
        int m = this.month().m();
        int y = m >= 13 ? this.year() - 1 : this.year();
        int k = y % 100;
        int j = y / 100;
        int h = (q + 13 * (m + 1) / 5 + k + k / 4 + j / 4 + 5 * j) % 7;
        return DayOfWeek.fromH(h);
    }

    public static int DOW(int y_, int m_, int d_) {
        int q = d_;
        int m = 3 + (m_ - 1 + 10) % 12;
        int y = m >= 13 ? y_ - 1 : y_;
        int k = y % 100;
        int j = y / 100;
        int h = (q + 13 * (m + 1) / 5 + k + k / 4 + j / 4 + 5 * j) % 7;
        return h;
    }

    public Wink asInstantDay(Day reference) {
        int cmp = 0;
        Day current = reference;
        while (current.compareTo(this) < 0) {
            current = current.next();
            ++cmp;
        }
        return new Wink(cmp);
    }

    public int ISO_WN() {
        int y = this.year();
        int m = this.month().ordinal() + 1;
        int d = this.dayOfMonth;
        int dow = Day.DOW(y, m, d);
        int dow0101 = Day.DOW(y, 1, 1);
        if (m == 1 && 3 < dow0101 && dow0101 < 7 - (d - 1)) {
            dow = dow0101 - 1;
            dow0101 = Day.DOW(y - 1, 1, 1);
            m = 12;
            d = 31;
        } else if (m == 12 && 30 - (d - 1) < Day.DOW(y + 1, 1, 1) && Day.DOW(y + 1, 1, 1) < 4) {
            return 1;
        }
        return Day.DOW(y, 1, 1) < 4 ? 1 : 0 + 4 * (m - 1) + (2 * (m - 1) + (d - 1) + dow0101 - dow + 6) * 36 / 256;
    }

    @Override
    public int compareTo(Day other) {
        return this.internalNumber() - other.internalNumber();
    }
}

