/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.command;

import net.sourceforge.plantuml.LineLocation;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.sequencediagram.LifeEventType;
import net.sourceforge.plantuml.sequencediagram.Participant;
import net.sourceforge.plantuml.sequencediagram.SequenceDiagram;

public class CommandActivate2
extends SingleLineCommand2<SequenceDiagram> {
    public CommandActivate2() {
        super(CommandActivate2.getRegexConcat());
    }

    static IRegex getRegexConcat() {
        return RegexConcat.build(CommandActivate2.class.getName(), RegexLeaf.start(), new RegexLeaf("NAME", "([\\p{L}0-9_.@]+)"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("TYPE", "(\\+\\+|--)"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("COLOR", "(#\\w+)?"), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeArg(SequenceDiagram diagram, LineLocation location, RegexResult arg) {
        LifeEventType type = arg.get("TYPE", 0).equals("++") ? LifeEventType.ACTIVATE : LifeEventType.DEACTIVATE;
        Participant p = diagram.getOrCreateParticipant(arg.get("NAME", 0));
        String error = diagram.activate(p, type, diagram.getSkinParam().getIHtmlColorSet().getColorIfValid(arg.get("COLOR", 0)));
        if (error == null) {
            return CommandExecutionResult.ok();
        }
        return CommandExecutionResult.error(error);
    }
}

