/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.timingdiagram.graphic;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.timingdiagram.ChangeState;
import net.sourceforge.plantuml.timingdiagram.TimeConstraint;
import net.sourceforge.plantuml.timingdiagram.TimeTick;
import net.sourceforge.plantuml.timingdiagram.TimingRuler;
import net.sourceforge.plantuml.timingdiagram.graphic.IntricatedPoint;
import net.sourceforge.plantuml.timingdiagram.graphic.PDrawing;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColorUtils;

public class Histogram
implements PDrawing {
    private final List<ChangeState> changes = new ArrayList<ChangeState>();
    private final List<TimeConstraint> constraints = new ArrayList<TimeConstraint>();
    private List<String> allStates;
    private final ISkinParam skinParam;
    private final TimingRuler ruler;
    private final boolean compact;
    private String initialState;
    private final TextBlock title;
    private final int suggestedHeight;

    public Histogram(TimingRuler ruler, ISkinParam skinParam, Collection<String> someStates, boolean compact, TextBlock title, int suggestedHeight) {
        this.suggestedHeight = suggestedHeight;
        this.ruler = ruler;
        this.skinParam = skinParam;
        this.allStates = new ArrayList<String>(someStates);
        this.compact = compact;
        this.title = title;
        Collections.reverse(this.allStates);
    }

    @Override
    public IntricatedPoint getTimeProjection(StringBounder stringBounder, TimeTick tick) {
        double x = this.ruler.getPosInPixel(tick);
        List<String> states = this.getStatesAt(tick);
        if (states.size() == 0) {
            return null;
        }
        double heightForConstraints = this.getHeightForConstraints(stringBounder);
        if (states.size() == 1) {
            double y = this.yOfState(states.get(0)) + heightForConstraints;
            return new IntricatedPoint(new Point2D.Double(x, y), new Point2D.Double(x, y));
        }
        assert (states.size() == 2);
        double y1 = this.yOfState(states.get(0)) + heightForConstraints;
        double y2 = this.yOfState(states.get(1)) + heightForConstraints;
        assert (y1 != y2);
        return new IntricatedPoint(new Point2D.Double(x, y1), new Point2D.Double(x, y2));
    }

    private List<String> getStatesAt(TimeTick tick) {
        if (this.changes.size() == 0) {
            return Collections.emptyList();
        }
        for (int i = 0; i < this.changes.size(); ++i) {
            int tickWithCurrentChangeTimeComparisonResult = this.changes.get(i).getWhen().compareTo(tick);
            if (tickWithCurrentChangeTimeComparisonResult == 0) {
                if (i == 0 && this.initialState == null) {
                    return Arrays.asList(this.changes.get(i).getState());
                }
                if (i == 0 && this.initialState != null) {
                    return Arrays.asList(this.initialState, this.changes.get(i).getState());
                }
                return Arrays.asList(this.changes.get(i - 1).getState(), this.changes.get(i).getState());
            }
            if (tickWithCurrentChangeTimeComparisonResult <= 0) continue;
            int changeIndex = i == 0 ? 0 : i - 1;
            return Collections.singletonList(this.changes.get(changeIndex).getState());
        }
        return Collections.singletonList(this.changes.get(this.changes.size() - 1).getState());
    }

    @Override
    public void addChange(ChangeState change) {
        String[] states;
        this.changes.add(change);
        for (String state : states = change.getStates()) {
            if (this.allStates.contains(state)) continue;
            this.allStates.add(state);
        }
    }

    private Point2D[] getPoints(int n) {
        ChangeState change = this.changes.get(n);
        double x = this.ruler.getPosInPixel(change.getWhen());
        String[] states = change.getStates();
        if (states.length == 2) {
            return new Point2D[]{new Point2D.Double(x, this.yOfState(states[0])), new Point2D.Double(x, this.yOfState(states[1]))};
        }
        return new Point2D[]{new Point2D.Double(x, this.yOfState(states[0]))};
    }

    private double getPointx(int n) {
        ChangeState change = this.changes.get(n);
        return this.ruler.getPosInPixel(change.getWhen());
    }

    private double getPointMinY(int n) {
        String[] states = this.changes.get(n).getStates();
        if (states.length == 2) {
            return Math.min(this.yOfState(states[0]), this.yOfState(states[1]));
        }
        return this.yOfState(states[0]);
    }

    private double getPointMaxY(int n) {
        String[] states = this.changes.get(n).getStates();
        if (states.length == 2) {
            return Math.max(this.yOfState(states[0]), this.yOfState(states[1]));
        }
        return this.yOfState(states[0]);
    }

    private SymbolContext getContext() {
        return new SymbolContext(HColorUtils.COL_D7E0F2, HColorUtils.COL_038048).withStroke(new UStroke(1.5));
    }

    @Override
    public TextBlock getPart1(final double fullAvailableWidth) {
        return new AbstractTextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                Histogram.this.drawPart1(ug, fullAvailableWidth);
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                return Histogram.this.calculateDimensionPart1(stringBounder);
            }
        };
    }

    @Override
    public UDrawable getPart2() {
        return new UDrawable(){

            @Override
            public void drawU(UGraphic ug) {
                Histogram.this.drawPart2(ug);
            }
        };
    }

    private Dimension2D calculateDimensionPart1(StringBounder stringBounder) {
        double width = 0.0;
        for (String state : this.allStates) {
            TextBlock label = this.getTextBlock(state);
            Dimension2D dim = label.calculateDimension(stringBounder);
            width = Math.max(width, dim.getWidth());
        }
        if (this.initialState != null) {
            width += this.getInitialWidth();
        }
        if (this.compact) {
            width += this.title.calculateDimension(stringBounder).getWidth() + 15.0;
        }
        return new Dimension2DDouble(width, this.getFullHeight(stringBounder));
    }

    private void drawPart1(UGraphic ug, double fullAvailableWidth) {
        StringBounder stringBounder = ug.getStringBounder();
        ug = ug.apply(UTranslate.dy(this.getHeightForConstraints(stringBounder)));
        if (this.compact) {
            double titleHeight = this.title.calculateDimension(stringBounder).getHeight();
            double dy = (this.getFullHeight(stringBounder) - titleHeight) / 2.0;
            this.title.drawU(ug.apply(UTranslate.dy(dy)));
        }
        double width = this.getStatesWidth(stringBounder);
        if (this.initialState != null) {
            width += this.getInitialWidth();
        }
        ug = fullAvailableWidth > width + 5.0 ? ug.apply(UTranslate.dx(fullAvailableWidth - width - 5.0)) : ug.apply(UTranslate.dx(fullAvailableWidth - width));
        for (String state : this.allStates) {
            TextBlock label = this.getTextBlock(state);
            Dimension2D dim = label.calculateDimension(stringBounder);
            label.drawU(ug.apply(UTranslate.dy(this.yOfState(state) - dim.getHeight() / 2.0 + 1.0)));
        }
    }

    private double getStatesWidth(StringBounder stringBounder) {
        double result = 0.0;
        for (String state : this.allStates) {
            TextBlock label = this.getTextBlock(state);
            Dimension2D dim = label.calculateDimension(stringBounder);
            result = Math.max(result, dim.getWidth());
        }
        return result;
    }

    private void drawPart2(UGraphic ug) {
        if (this.changes.size() == 0) {
            return;
        }
        ug = this.getContext().apply(ug);
        ug = ug.apply(UTranslate.dy(this.getHeightForConstraints(ug.getStringBounder())));
        this.drawHlines(ug);
        this.drawVlines(ug);
        this.drawLabels(ug);
        this.drawConstraints(ug.apply(UTranslate.dy(-TimeConstraint.getTopMargin())));
    }

    private void drawHlines(UGraphic ug) {
        if (this.initialState != null) {
            for (Point2D pt : this.getPoints(0)) {
                this.drawHLine(ug, this.getInitialPoint(), this.getInitialWidth() + pt.getX());
            }
        }
        for (int i = 0; i < this.changes.size(); ++i) {
            double x2 = i < this.changes.size() - 1 ? this.getPointx(i + 1) : this.ruler.getWidth();
            double len = x2 - this.getPointx(i);
            Point2D[] points = this.getPoints(i);
            if (points.length == 2) {
                this.drawHBlock(ug.apply(this.changes.get(i).getBackColor().bg()), points[0], points[1], len);
            }
            if (i >= this.changes.size() - 1) continue;
            for (Point2D pt : points) {
                this.drawHLine(ug, pt, len);
            }
        }
        for (Point2D pt : this.getPoints(this.changes.size() - 1)) {
            double len = this.ruler.getWidth() - pt.getX();
            this.drawHLine(ug, pt, len);
        }
    }

    private void drawHBlock(UGraphic ug, Point2D pt1, Point2D pt2, double len) {
        double minY = Math.min(pt1.getY(), pt2.getY());
        double maxY = Math.max(pt1.getY(), pt2.getY());
        Point2D.Double pt = new Point2D.Double(pt1.getX(), minY);
        ug = ug.apply(new UTranslate(pt));
        ug.draw(new URectangle(len, maxY - minY));
        for (double x = 0.0; x < len; x += 5.0) {
            ug.apply(UTranslate.dx(x)).draw(ULine.vline(maxY - minY));
        }
    }

    private void drawHLine(UGraphic ug, Point2D pt, double len) {
        ug.apply(new UTranslate(pt)).draw(ULine.hline(len));
    }

    private void drawVlines(UGraphic ug) {
        if (this.initialState != null) {
            Point2D.Double before = this.getInitialPoint();
            Point2D current = this.getPoints(0)[0];
            ug.apply(new UTranslate(current)).draw(ULine.vline(((Point2D)before).getY() - current.getY()));
        }
        for (int i = 1; i < this.changes.size(); ++i) {
            double minY = Math.min(this.getPointMinY(i), this.getPointMinY(i - 1));
            double maxY = Math.max(this.getPointMaxY(i), this.getPointMaxY(i - 1));
            ug.apply(new UTranslate(this.getPointx(i), minY)).draw(ULine.vline(maxY - minY));
        }
    }

    private void drawLabels(UGraphic ug) {
        for (int i = 0; i < this.changes.size(); ++i) {
            Point2D ptLabel = this.getPoints(i)[0];
            String comment = this.changes.get(i).getComment();
            if (comment == null) continue;
            TextBlock label = this.getTextBlock(comment);
            Dimension2D dim = label.calculateDimension(ug.getStringBounder());
            label.drawU(ug.apply(new UTranslate(ptLabel).compose(new UTranslate(2.0, -dim.getHeight()))));
        }
    }

    private void drawConstraints(UGraphic ug) {
        for (TimeConstraint constraint : this.constraints) {
            String state1 = Histogram.last(this.getStatesAt(constraint.getTick1()));
            String state2 = this.getStatesAt(constraint.getTick2()).get(0);
            double y1 = this.yOfState(state1);
            double y2 = this.yOfState(state2);
            constraint.drawU(ug.apply(UTranslate.dy(y1)), this.ruler);
        }
    }

    private static String last(List<String> list) {
        return list.get(list.size() - 1);
    }

    private Point2D.Double getInitialPoint() {
        return new Point2D.Double(-this.getInitialWidth(), this.yOfState(this.initialState));
    }

    private double getHeightForConstraints(StringBounder stringBounder) {
        return TimeConstraint.getHeightForConstraints(stringBounder, this.constraints);
    }

    @Override
    public double getFullHeight(StringBounder stringBounder) {
        return this.getHeightForConstraints(stringBounder) + this.stepHeight() * (double)(this.allStates.size() - 1) + this.getBottomMargin();
    }

    private double getBottomMargin() {
        return 12.0;
    }

    private double yOfState(String state) {
        int nb = this.allStates.size() - 1 - this.allStates.indexOf(state);
        return this.stepHeight() * (double)nb;
    }

    private double stepHeight() {
        if (this.suggestedHeight == 0 || this.allStates.size() <= 1) {
            return 20.0;
        }
        return this.suggestedHeight / (this.allStates.size() - 1);
    }

    private FontConfiguration getFontConfiguration() {
        return new FontConfiguration(this.skinParam, FontParam.TIMING, null);
    }

    private TextBlock getTextBlock(String value) {
        Display display = Display.getWithNewlines(value);
        return display.create(this.getFontConfiguration(), HorizontalAlignment.LEFT, this.skinParam);
    }

    @Override
    public void setInitialState(String initialState, Colors initialColors) {
        this.initialState = initialState;
        if (initialState != null && !this.allStates.contains(initialState)) {
            this.allStates.add(initialState);
        }
    }

    private double getInitialWidth() {
        return 40.0;
    }

    @Override
    public void addConstraint(TimeConstraint constraint) {
        this.constraints.add(constraint);
    }
}

