/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.anim.values;

import org.apache.batik.anim.values.AnimatableColorValue;
import org.apache.batik.anim.values.AnimatableValue;
import org.apache.batik.dom.anim.AnimationTarget;

public class AnimatablePaintValue
extends AnimatableColorValue {
    public static final int PAINT_NONE = 0;
    public static final int PAINT_CURRENT_COLOR = 1;
    public static final int PAINT_COLOR = 2;
    public static final int PAINT_URI = 3;
    public static final int PAINT_URI_NONE = 4;
    public static final int PAINT_URI_CURRENT_COLOR = 5;
    public static final int PAINT_URI_COLOR = 6;
    public static final int PAINT_INHERIT = 7;
    protected int paintType;
    protected String uri;

    protected AnimatablePaintValue(AnimationTarget animationTarget) {
        super(animationTarget);
    }

    protected AnimatablePaintValue(AnimationTarget animationTarget, float f, float f2, float f3) {
        super(animationTarget, f, f2, f3);
    }

    public static AnimatablePaintValue createNonePaintValue(AnimationTarget animationTarget) {
        AnimatablePaintValue animatablePaintValue = new AnimatablePaintValue(animationTarget);
        animatablePaintValue.paintType = 0;
        return animatablePaintValue;
    }

    public static AnimatablePaintValue createCurrentColorPaintValue(AnimationTarget animationTarget) {
        AnimatablePaintValue animatablePaintValue = new AnimatablePaintValue(animationTarget);
        animatablePaintValue.paintType = 1;
        return animatablePaintValue;
    }

    public static AnimatablePaintValue createColorPaintValue(AnimationTarget animationTarget, float f, float f2, float f3) {
        AnimatablePaintValue animatablePaintValue = new AnimatablePaintValue(animationTarget, f, f2, f3);
        animatablePaintValue.paintType = 2;
        return animatablePaintValue;
    }

    public static AnimatablePaintValue createURIPaintValue(AnimationTarget animationTarget, String string) {
        AnimatablePaintValue animatablePaintValue = new AnimatablePaintValue(animationTarget);
        animatablePaintValue.uri = string;
        animatablePaintValue.paintType = 3;
        return animatablePaintValue;
    }

    public static AnimatablePaintValue createURINonePaintValue(AnimationTarget animationTarget, String string) {
        AnimatablePaintValue animatablePaintValue = new AnimatablePaintValue(animationTarget);
        animatablePaintValue.uri = string;
        animatablePaintValue.paintType = 4;
        return animatablePaintValue;
    }

    public static AnimatablePaintValue createURICurrentColorPaintValue(AnimationTarget animationTarget, String string) {
        AnimatablePaintValue animatablePaintValue = new AnimatablePaintValue(animationTarget);
        animatablePaintValue.uri = string;
        animatablePaintValue.paintType = 5;
        return animatablePaintValue;
    }

    public static AnimatablePaintValue createURIColorPaintValue(AnimationTarget animationTarget, String string, float f, float f2, float f3) {
        AnimatablePaintValue animatablePaintValue = new AnimatablePaintValue(animationTarget, f, f2, f3);
        animatablePaintValue.uri = string;
        animatablePaintValue.paintType = 6;
        return animatablePaintValue;
    }

    public static AnimatablePaintValue createInheritPaintValue(AnimationTarget animationTarget) {
        AnimatablePaintValue animatablePaintValue = new AnimatablePaintValue(animationTarget);
        animatablePaintValue.paintType = 7;
        return animatablePaintValue;
    }

    public AnimatableValue interpolate(AnimatableValue animatableValue, AnimatableValue animatableValue2, float f, AnimatableValue animatableValue3, int n) {
        float f2;
        float f3;
        float f4;
        Object object;
        int n2;
        AnimatablePaintValue animatablePaintValue = animatableValue == null ? new AnimatablePaintValue(this.target) : (AnimatablePaintValue)animatableValue;
        if (this.paintType == 2) {
            n2 = 1;
            if (animatableValue2 != null) {
                object = (AnimatablePaintValue)animatableValue2;
                int n3 = n2 = ((AnimatablePaintValue)object).paintType == 2 ? 1 : 0;
            }
            if (animatableValue3 != null) {
                object = (AnimatablePaintValue)animatableValue3;
                int n4 = n2 = n2 != 0 && ((AnimatablePaintValue)object).paintType == 2 ? 1 : 0;
            }
            if (n2 != 0) {
                animatablePaintValue.paintType = 2;
                return super.interpolate(animatablePaintValue, animatableValue2, f, animatableValue3, n);
            }
        }
        if (animatableValue2 != null && (double)f >= 0.5) {
            AnimatablePaintValue animatablePaintValue2 = (AnimatablePaintValue)animatableValue2;
            n2 = animatablePaintValue2.paintType;
            object = animatablePaintValue2.uri;
            f4 = animatablePaintValue2.red;
            f3 = animatablePaintValue2.green;
            f2 = animatablePaintValue2.blue;
        } else {
            n2 = this.paintType;
            object = this.uri;
            f4 = this.red;
            f3 = this.green;
            f2 = this.blue;
        }
        if (animatablePaintValue.paintType != n2 || animatablePaintValue.uri == null || !animatablePaintValue.uri.equals(object) || animatablePaintValue.red != f4 || animatablePaintValue.green != f3 || animatablePaintValue.blue != f2) {
            animatablePaintValue.paintType = n2;
            animatablePaintValue.uri = object;
            animatablePaintValue.red = f4;
            animatablePaintValue.green = f3;
            animatablePaintValue.blue = f2;
            animatablePaintValue.hasChanged = true;
        }
        return animatablePaintValue;
    }

    public int getPaintType() {
        return this.paintType;
    }

    public String getURI() {
        return this.uri;
    }

    public boolean canPace() {
        return false;
    }

    public float distanceTo(AnimatableValue animatableValue) {
        return 0.0f;
    }

    public AnimatableValue getZeroValue() {
        return AnimatablePaintValue.createColorPaintValue(this.target, 0.0f, 0.0f, 0.0f);
    }

    public String getCssText() {
        switch (this.paintType) {
            case 0: {
                return "none";
            }
            case 1: {
                return "currentColor";
            }
            case 2: {
                return super.getCssText();
            }
            case 3: {
                return "url(" + this.uri + ")";
            }
            case 4: {
                return "url(" + this.uri + ") none";
            }
            case 5: {
                return "url(" + this.uri + ") currentColor";
            }
            case 6: {
                return "url(" + this.uri + ") " + super.getCssText();
            }
        }
        return "inherit";
    }
}

