/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen;

import java.awt.Rectangle;
import java.awt.image.BufferedImageOp;
import java.awt.image.ByteLookupTable;
import java.awt.image.LookupOp;
import java.awt.image.LookupTable;
import java.util.Arrays;
import org.apache.batik.svggen.AbstractSVGFilterConverter;
import org.apache.batik.svggen.SVGFilterDescriptor;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGGraphics2DRuntimeException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SVGLookupOp
extends AbstractSVGFilterConverter {
    private static final double GAMMA = 0.4166666666666667;
    private static final int[] linearToSRGBLut = new int[256];
    private static final int[] sRGBToLinear = new int[256];

    public SVGLookupOp(SVGGeneratorContext sVGGeneratorContext) {
        super(sVGGeneratorContext);
    }

    public SVGFilterDescriptor toSVG(BufferedImageOp bufferedImageOp, Rectangle rectangle) {
        if (bufferedImageOp instanceof LookupOp) {
            return this.toSVG((LookupOp)bufferedImageOp);
        }
        return null;
    }

    public SVGFilterDescriptor toSVG(LookupOp lookupOp) {
        SVGFilterDescriptor sVGFilterDescriptor = (SVGFilterDescriptor)this.descMap.get(lookupOp);
        Document document = this.generatorContext.domFactory;
        if (sVGFilterDescriptor == null) {
            Element element = document.createElementNS("http://www.w3.org/2000/svg", "filter");
            Element element2 = document.createElementNS("http://www.w3.org/2000/svg", "feComponentTransfer");
            String[] stringArray = this.convertLookupTables(lookupOp);
            Element element3 = document.createElementNS("http://www.w3.org/2000/svg", "feFuncR");
            Element element4 = document.createElementNS("http://www.w3.org/2000/svg", "feFuncG");
            Element element5 = document.createElementNS("http://www.w3.org/2000/svg", "feFuncB");
            Element element6 = null;
            String string = "table";
            if (stringArray.length == 1) {
                element3.setAttributeNS(null, "type", string);
                element4.setAttributeNS(null, "type", string);
                element5.setAttributeNS(null, "type", string);
                element3.setAttributeNS(null, "tableValues", stringArray[0]);
                element4.setAttributeNS(null, "tableValues", stringArray[0]);
                element5.setAttributeNS(null, "tableValues", stringArray[0]);
            } else if (stringArray.length >= 3) {
                element3.setAttributeNS(null, "type", string);
                element4.setAttributeNS(null, "type", string);
                element5.setAttributeNS(null, "type", string);
                element3.setAttributeNS(null, "tableValues", stringArray[0]);
                element4.setAttributeNS(null, "tableValues", stringArray[1]);
                element5.setAttributeNS(null, "tableValues", stringArray[2]);
                if (stringArray.length == 4) {
                    element6 = document.createElementNS("http://www.w3.org/2000/svg", "feFuncA");
                    element6.setAttributeNS(null, "type", string);
                    element6.setAttributeNS(null, "tableValues", stringArray[3]);
                }
            }
            element2.appendChild(element3);
            element2.appendChild(element4);
            element2.appendChild(element5);
            if (element6 != null) {
                element2.appendChild(element6);
            }
            element.appendChild(element2);
            element.setAttributeNS(null, "id", this.generatorContext.idGenerator.generateID("componentTransfer"));
            String string2 = "url(#" + element.getAttributeNS(null, "id") + ")";
            sVGFilterDescriptor = new SVGFilterDescriptor(string2, element);
            this.defSet.add(element);
            this.descMap.put(lookupOp, sVGFilterDescriptor);
        }
        return sVGFilterDescriptor;
    }

    private String[] convertLookupTables(LookupOp lookupOp) {
        int n;
        int n2;
        int n3;
        Object[] objectArray;
        Object[] objectArray2;
        LookupTable lookupTable = lookupOp.getTable();
        int n4 = lookupTable.getNumComponents();
        if (n4 != 1 && n4 != 3 && n4 != 4) {
            throw new SVGGraphics2DRuntimeException("BufferedImage LookupOp should have 1, 3 or 4 lookup arrays");
        }
        StringBuffer[] stringBufferArray = new StringBuffer[n4];
        for (int i = 0; i < n4; ++i) {
            stringBufferArray[i] = new StringBuffer();
        }
        if (!(lookupTable instanceof ByteLookupTable)) {
            objectArray2 = new int[n4];
            objectArray = new int[n4];
            n3 = lookupTable.getOffset();
            for (n2 = 0; n2 < n3; ++n2) {
                for (n = 0; n < n4; ++n) {
                    stringBufferArray[n].append(this.doubleString((double)n2 / 255.0)).append(" ");
                }
            }
            for (n2 = n3; n2 <= 255; ++n2) {
                Arrays.fill(objectArray2, n2);
                lookupTable.lookupPixel((int[])objectArray2, (int[])objectArray);
                for (n = 0; n < n4; ++n) {
                    stringBufferArray[n].append(this.doubleString((double)objectArray[n] / 255.0)).append(" ");
                }
            }
        } else {
            objectArray2 = new byte[n4];
            objectArray = new byte[n4];
            n3 = lookupTable.getOffset();
            for (n2 = 0; n2 < n3; ++n2) {
                for (n = 0; n < n4; ++n) {
                    stringBufferArray[n].append(this.doubleString((double)n2 / 255.0)).append(" ");
                }
            }
            for (n2 = 0; n2 <= 255; ++n2) {
                Arrays.fill((byte[])objectArray2, (byte)(0xFF & n2));
                ((ByteLookupTable)lookupTable).lookupPixel((byte[])objectArray2, (byte[])objectArray);
                for (n = 0; n < n4; ++n) {
                    stringBufferArray[n].append(this.doubleString((double)(0xFF & objectArray[n]) / 255.0)).append(" ");
                }
            }
        }
        objectArray2 = new String[n4];
        for (int i = 0; i < n4; ++i) {
            objectArray2[i] = (int)stringBufferArray[i].toString().trim();
        }
        return objectArray2;
    }

    static {
        for (int i = 0; i < 256; ++i) {
            float f = (float)i / 255.0f;
            f = (double)f <= 0.0031308 ? (f *= 12.92f) : 1.055f * (float)Math.pow(f, 0.4166666666666667) - 0.055f;
            SVGLookupOp.linearToSRGBLut[i] = Math.round(f * 255.0f);
            f = (float)i / 255.0f;
            f = (double)f <= 0.04045 ? (f /= 12.92f) : (float)Math.pow((f + 0.055f) / 1.055f, 2.4);
            SVGLookupOp.sRGBToLinear[i] = Math.round(f * 255.0f);
        }
    }
}

