/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.log;

import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.protege.editor.core.ProtegeApplication;
import org.protege.editor.core.prefs.Preferences;
import org.protege.editor.core.prefs.PreferencesManager;

public class LogPreferences {
    private static final String PREFERENCES_SET_KEY_ = "org.protege.editor.core.log";
    private static final String LOG_LEVEL_KEY_ = "LOG_LEVEL";
    private static final String LOG_WRAP_LINES_KEY_ = "LOG_WRAP_LINES";
    private static final String LOG_LIMIT_OUTPUT_KEY_ = "LOG_LIMIT_OUTPUT";
    private static final String LOG_CHARACTER_LIMIT_KEY_ = "LOG_CHARACTER_LIMIT";
    private static final String LOG_PATTERN_KEY_ = "LOG_PATTERN";
    private static final String LOG_STYLES_NAMES_KEY_ = "LOG_STYLES_NAME";
    private static final String LOG_STYLES_FOREGTROUD_KEY_ = "LOG_STYLES_FORGROUND";
    private static final String DEFAULT_LOG_LEVEL_ = "INFO";
    private static final Boolean DEFAULT_WRAP_LINES_ = false;
    private static final Boolean DEFAULT_LOG_LIMIT_OUTPUT_ = true;
    private static final int DEFAULT_LOG_CHARACTER_LIMIT_ = 80000;
    private static final String DEFAULT_LOG_PATTERN_ = "%7level  %date{HH:mm:ss}  %message%n";
    private static final List<String> DEFAULT_LOG_SYTLE_LEVELS_ = Collections.emptyList();
    private static final List<byte[]> DEFAULT_LOG_SYTLE_FOREGROUNDS_ = Collections.emptyList();
    public String logLevel;
    public Boolean wrapLines;
    public Boolean limitLogOutput;
    public int logCharacterLimit;
    public String logPattern;
    public Map<String, Color> logStyleForegrounds;

    private LogPreferences() {
    }

    public static LogPreferences create() {
        return new LogPreferences().reset();
    }

    private static Preferences getPrefs() {
        PreferencesManager prefMan = PreferencesManager.getInstance();
        return prefMan.getPreferencesForSet(PREFERENCES_SET_KEY_, LogPreferences.class);
    }

    public LogPreferences load() {
        Preferences prefs = LogPreferences.getPrefs();
        this.logLevel = prefs.getString(LOG_LEVEL_KEY_, DEFAULT_LOG_LEVEL_);
        this.wrapLines = prefs.getBoolean(LOG_WRAP_LINES_KEY_, DEFAULT_WRAP_LINES_);
        this.limitLogOutput = prefs.getBoolean(LOG_LIMIT_OUTPUT_KEY_, DEFAULT_LOG_LIMIT_OUTPUT_);
        this.logCharacterLimit = prefs.getInt(LOG_CHARACTER_LIMIT_KEY_, 80000);
        this.logPattern = prefs.getString(LOG_PATTERN_KEY_, DEFAULT_LOG_PATTERN_);
        List<String> names = prefs.getStringList(LOG_STYLES_NAMES_KEY_, DEFAULT_LOG_SYTLE_LEVELS_);
        List<byte[]> foregrounds = prefs.getByteArrayList(LOG_STYLES_FOREGTROUD_KEY_, DEFAULT_LOG_SYTLE_FOREGROUNDS_);
        this.logStyleForegrounds = new HashMap<String, Color>(foregrounds.size());
        try {
            for (int i = 0; i < foregrounds.size(); ++i) {
                this.logStyleForegrounds.put(names.get(i), (Color)LogPreferences.deserialize(foregrounds.get(i)));
            }
        }
        catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
        }
        return this;
    }

    public LogPreferences save() {
        Preferences prefs = LogPreferences.getPrefs();
        prefs.putString(LOG_LEVEL_KEY_, this.logLevel);
        prefs.putBoolean(LOG_WRAP_LINES_KEY_, this.wrapLines);
        prefs.putBoolean(LOG_LIMIT_OUTPUT_KEY_, this.limitLogOutput);
        prefs.putInt(LOG_CHARACTER_LIMIT_KEY_, this.logCharacterLimit);
        prefs.putString(LOG_PATTERN_KEY_, this.logPattern);
        try {
            ArrayList<String> names = new ArrayList<String>(this.logStyleForegrounds.keySet());
            ArrayList<byte[]> foregroundColors = new ArrayList<byte[]>(names.size());
            for (int i = 0; i < names.size(); ++i) {
                foregroundColors.add(LogPreferences.serialize(this.logStyleForegrounds.get(names.get(i))));
            }
            prefs.putStringList(LOG_STYLES_NAMES_KEY_, names);
            prefs.putByteArrayList(LOG_STYLES_FOREGTROUD_KEY_, foregroundColors);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ProtegeApplication.applyLogPreferences();
        return this;
    }

    public LogPreferences reset() {
        this.logLevel = DEFAULT_LOG_LEVEL_;
        this.wrapLines = DEFAULT_WRAP_LINES_;
        this.limitLogOutput = DEFAULT_LOG_LIMIT_OUTPUT_;
        this.logCharacterLimit = 80000;
        this.logPattern = DEFAULT_LOG_PATTERN_;
        this.logStyleForegrounds = Collections.emptyMap();
        return this;
    }

    public static byte[] serialize(Object obj) throws IOException {
        try (ByteArrayOutputStream b = new ByteArrayOutputStream();){
            try (ObjectOutputStream o = new ObjectOutputStream(b);){
                o.writeObject(obj);
            }
            byte[] byArray = b.toByteArray();
            return byArray;
        }
    }

    public static Object deserialize(byte[] bytes) throws IOException, ClassNotFoundException {
        try (ByteArrayInputStream b = new ByteArrayInputStream(bytes);){
            Object object;
            try (ObjectInputStream o = new ObjectInputStream(b);){
                object = o.readObject();
            }
            return object;
        }
    }
}

