/*
 * Decompiled with CFR 0.152.
 */
package org.protege.osgi.framework;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.xml.parsers.ParserConfigurationException;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.launch.FrameworkFactory;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.framework.wiring.BundleRevision;
import org.protege.osgi.framework.BundleSearchPath;
import org.protege.osgi.framework.FrameworkSlf4jLogger;
import org.protege.osgi.framework.Parser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class Launcher {
    public static final String ARG_PROPERTY = "command.line.arg.";
    public static final String LAUNCH_LOCATION_PROPERTY = "org.protege.launch.config";
    public static final String PROTEGE_DIR_PROPERTY = "protege.dir";
    public static final String DEFAULT_CONFIG_XML_FILE_PATH_NAME = "conf/config.xml";
    public static String PROTEGE_DIR = System.getProperty("protege.dir");
    private final Logger logger = LoggerFactory.getLogger((String)Launcher.class.getCanonicalName());
    private final Map<String, String> frameworkProperties = new HashMap<String, String>();
    private final List<BundleSearchPath> searchPaths = new ArrayList<BundleSearchPath>();
    private final File frameworkDir;
    private final String factoryClass;
    private Framework framework;

    public Launcher(File config) throws IOException, ParserConfigurationException, SAXException {
        this.parseConfig(config);
        this.factoryClass = Launcher.locateOSGi();
        this.frameworkDir = new File(System.getProperty("java.io.tmpdir"), "ProtegeCache-" + UUID.randomUUID().toString());
        this.frameworkProperties.put("org.osgi.framework.storage", this.frameworkDir.getCanonicalPath());
        this.frameworkProperties.put("org.osgi.framework.startlevel.beginning", Integer.toString(this.searchPaths.size()));
    }

    public Framework getFramework() {
        return this.framework;
    }

    private void parseConfig(File config) throws ParserConfigurationException, SAXException, IOException {
        Parser p = new Parser();
        p.parse(config);
        this.setSystemProperties(p);
        Launcher.setLogger(this.frameworkProperties);
        this.searchPaths.addAll(p.getSearchPaths());
        this.frameworkProperties.putAll(p.getFrameworkProperties());
    }

    private static String locateOSGi() throws IOException {
        InputStream frameworkFactory = Launcher.class.getClassLoader().getResourceAsStream("META-INF/services/org.osgi.framework.launch.FrameworkFactory");
        try (BufferedReader factoryReader = new BufferedReader(new InputStreamReader(frameworkFactory));){
            String string = factoryReader.readLine().trim();
            return string;
        }
    }

    private void setSystemProperties(Parser p) {
        Map<String, String> systemProperties = p.getSystemProperties();
        System.setProperty("org.protege.osgi.launcherHandlesExit", "True");
        for (Map.Entry<String, String> entry : systemProperties.entrySet()) {
            System.setProperty(entry.getKey(), entry.getValue());
        }
    }

    private static void setLogger(Map configurationMap) {
        FrameworkSlf4jLogger logger = new FrameworkSlf4jLogger();
        configurationMap.put("felix.log.logger", logger);
    }

    public void start(boolean exitOnOSGiShutDown) throws InstantiationException, IllegalAccessException, ClassNotFoundException, BundleException, IOException, InterruptedException {
        this.printBanner();
        this.logger.info("----------------- Initialising and Starting the OSGi Framework -----------------");
        this.logger.info("FrameworkFactory Class: {}", (Object)this.factoryClass);
        this.logger.info("");
        FrameworkFactory factory = (FrameworkFactory)Class.forName(this.factoryClass).newInstance();
        this.framework = factory.newFramework(this.frameworkProperties);
        this.framework.init();
        this.logger.info("The OSGi framework has been initialised");
        BundleContext context = this.framework.getBundleContext();
        ArrayList<Bundle> bundles = new ArrayList<Bundle>();
        int startLevel = 1;
        for (BundleSearchPath searchPath : this.searchPaths) {
            bundles.addAll(this.installBundles(context, searchPath, startLevel++));
        }
        this.startBundles(bundles);
        try {
            this.framework.start();
            this.logger.info("The OSGi framework has been started");
            this.logger.info("");
        }
        catch (BundleException e) {
            this.logger.error("An error occurred when starting the OSGi framework: {}", (Object)e.getMessage(), (Object)e);
        }
        this.addShutdownHook();
        this.addCleanupOnExit(exitOnOSGiShutDown);
    }

    private void addShutdownHook() {
        Thread hook = new Thread(() -> {
            try {
                this.logger.info("----------------------- Shutting down Protege -----------------------");
                if (this.framework.getState() == 32) {
                    this.framework.stop();
                    this.framework.waitForStop(0L);
                }
                this.cleanup();
            }
            catch (Throwable t) {
                this.logger.error("Error shutting down OSGi session: {}", (Object)t.getMessage(), (Object)t);
            }
        }, "Close OSGi Session");
        Runtime.getRuntime().addShutdownHook(hook);
    }

    private void addCleanupOnExit(boolean exitOnOSGiShutDown) {
        Thread shutdownThread = new Thread(() -> {
            try {
                this.framework.waitForStop(0L);
                if (exitOnOSGiShutDown) {
                    System.exit(0);
                }
            }
            catch (Throwable t) {
                this.logger.error("Error on shutdown: {}", (Object)t.getMessage(), (Object)t);
            }
        }, "OSGi Shutdown Thread");
        shutdownThread.start();
    }

    private List<Bundle> installBundles(BundleContext context, BundleSearchPath searchPath, int startLevel) throws BundleException {
        Collection<File> bundles = searchPath.search();
        ArrayList<Bundle> core = new ArrayList<Bundle>();
        for (File bundleFile : bundles) {
            try {
                String bundleURI = bundleFile.getAbsoluteFile().toURI().toString();
                this.logger.debug("Installing bundle.  StartLevel: {}; Bundle: {}", (Object)startLevel, (Object)bundleFile.getAbsolutePath());
                Bundle newBundle = context.installBundle(bundleURI);
                ((BundleStartLevel)newBundle.adapt(BundleStartLevel.class)).setStartLevel(startLevel);
                core.add(newBundle);
            }
            catch (Throwable t) {
                this.logger.warn("Bundle {} failed to install: {}", (Object)bundleFile, (Object)t);
            }
        }
        return core;
    }

    private void startBundles(List<Bundle> bundles) throws BundleException {
        this.logger.info("------------------------------- Starting Bundles -------------------------------");
        for (Bundle b : bundles) {
            try {
                if (!Launcher.isFragmentBundle(b)) {
                    b.start();
                    this.logger.info("Starting bundle {}", (Object)b.getSymbolicName());
                    continue;
                }
                this.logger.info("Not starting bundle {} explicitly because it is a fragment bundle.", (Object)b.getSymbolicName());
            }
            catch (Throwable t) {
                this.logger.error("Core Bundle {} failed to start: {}", (Object)b.getBundleId(), (Object)t);
            }
        }
        this.logger.debug("-------------------------------------------------------------------------------");
    }

    private static boolean isFragmentBundle(Bundle b) {
        return (((BundleRevision)b.adapt(BundleRevision.class)).getTypes() & 1) != 0;
    }

    protected void cleanup() {
        this.logger.info("Cleaning up temporary directories");
        this.delete(this.frameworkDir);
    }

    private void delete(File f) {
        File[] files;
        if (f.isDirectory() && (files = f.listFiles()) != null) {
            for (File child : files) {
                this.delete(child);
            }
        }
        if (!f.delete()) {
            this.logger.warn("File could not be deleted ({})", (Object)f.getAbsolutePath());
        }
    }

    public static void setArguments(String ... args) {
        if (args != null) {
            int counter = 0;
            for (String arg : args) {
                System.setProperty(ARG_PROPERTY + counter++, arg);
            }
        }
    }

    private void printBanner() {
        this.logger.info("********************************************************************************");
        this.logger.info("**                                  Protege                                   **");
        this.logger.info("********************************************************************************");
        this.logger.info("");
    }

    public static void main(String[] args) throws Exception {
        Launcher.setArguments(args);
        String config = System.getProperty(LAUNCH_LOCATION_PROPERTY, DEFAULT_CONFIG_XML_FILE_PATH_NAME);
        File configFile = PROTEGE_DIR != null ? new File(PROTEGE_DIR, config) : new File(config);
        Launcher launcher = new Launcher(configFile);
        launcher.start(true);
    }
}

