/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.io;

import com.google.common.base.Preconditions;
import java.io.File;
import java.net.URI;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.eclipse.jgit.annotations.NonNull;
import org.protege.editor.owl.model.library.OntologyCatalogManager;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntologyIRIMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoMappedRepositoryIRIMapper
implements OWLOntologyIRIMapper {
    private static final Logger logger = LoggerFactory.getLogger(AutoMappedRepositoryIRIMapper.class);
    private static final String FILE_SCHEME = "file";
    @NonNull
    private final OntologyCatalogManager ontologyCatalogManager;
    @NonNull
    private final Optional<URI> rootOntologyDocument;

    @Deprecated
    public AutoMappedRepositoryIRIMapper(@NonNull OntologyCatalogManager ontologyCatalogManager) {
        this.ontologyCatalogManager = (OntologyCatalogManager)Preconditions.checkNotNull((Object)ontologyCatalogManager);
        this.rootOntologyDocument = Optional.empty();
    }

    public AutoMappedRepositoryIRIMapper(@NonNull OntologyCatalogManager ontologyCatalogManager, @NonNull URI rootOntologyDocument) {
        this.ontologyCatalogManager = (OntologyCatalogManager)Preconditions.checkNotNull((Object)ontologyCatalogManager);
        this.rootOntologyDocument = Optional.of(rootOntologyDocument);
    }

    @NonNull
    public IRI getDocumentIRI(@Nonnull IRI importedIRI) {
        URI uri = importedIRI.toURI();
        this.rootOntologyDocument.ifPresent(rootOntologyDocument -> {
            if (FILE_SCHEME.equals(rootOntologyDocument.getScheme())) {
                File rootOntologyDocumentDirectory = new File((URI)rootOntologyDocument).getParentFile();
                this.ontologyCatalogManager.addFolder(rootOntologyDocumentDirectory);
            }
        });
        Optional<URI> redirect = this.ontologyCatalogManager.getRedirectForUri(uri);
        if (redirect.isPresent()) {
            logger.info("Imported ontology document {} was resolved to {} by the ontology catalog.", (Object)importedIRI, redirect);
        } else {
            logger.info("Imported ontology document {} was not resolved to any documents defined in the ontology catalog.", (Object)importedIRI);
        }
        return redirect.map(IRI::create).orElse(null);
    }
}

