/*
 * Decompiled with CFR 0.152.
 */
package org.protege.xmlcatalog.swing;

import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.protege.xmlcatalog.EntryVisitor;
import org.protege.xmlcatalog.entry.DelegatePublicEntry;
import org.protege.xmlcatalog.entry.DelegateSystemEntry;
import org.protege.xmlcatalog.entry.DelegateUriEntry;
import org.protege.xmlcatalog.entry.GroupEntry;
import org.protege.xmlcatalog.entry.NextCatalogEntry;
import org.protege.xmlcatalog.entry.PublicEntry;
import org.protege.xmlcatalog.entry.RewriteSystemEntry;
import org.protege.xmlcatalog.entry.RewriteUriEntry;
import org.protege.xmlcatalog.entry.SystemEntry;
import org.protege.xmlcatalog.entry.UriEntry;
import org.protege.xmlcatalog.swing.CatalogTreeNode;
import org.protege.xmlcatalog.swing.EntryTreeNode;

public class AltCellRenderer
extends DefaultTreeCellRenderer {
    private static final long serialVersionUID = 5872637762761958584L;
    private EntryRenderingVisitor visitor = new EntryRenderingVisitor();

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        JLabel label = (JLabel)super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        if (value instanceof CatalogTreeNode) {
            label.setText("" + ((CatalogTreeNode)value).getCatalog().getXmlBase());
        } else {
            EntryTreeNode node = (EntryTreeNode)value;
            if (node.getEditor() != null) {
                label.setText(node.getEditor().getDescription(node.getEntry()));
            } else {
                node.getEntry().accept(this.visitor);
                label.setText(this.visitor.getText());
            }
        }
        if (selected) {
            label.setBackground(this.backgroundSelectionColor);
        } else {
            label.setBackground(this.backgroundNonSelectionColor);
        }
        return label;
    }

    private class EntryRenderingVisitor
    implements EntryVisitor {
        private String text;

        private EntryRenderingVisitor() {
        }

        public String getText() {
            return this.text;
        }

        @Override
        public void visit(GroupEntry entry) {
            this.text = "Group Entry";
        }

        @Override
        public void visit(PublicEntry entry) {
            this.text = "Not implemented yet";
        }

        @Override
        public void visit(SystemEntry entry) {
            this.text = "Not implemented yet";
        }

        @Override
        public void visit(RewriteSystemEntry entry) {
            this.text = "Not implemented yet";
        }

        @Override
        public void visit(DelegatePublicEntry entry) {
            this.text = "Not implemented yet";
        }

        @Override
        public void visit(DelegateSystemEntry entry) {
            this.text = "Not implemented yet";
        }

        @Override
        public void visit(UriEntry entry) {
            this.text = entry.getName() + " \u2192 " + entry.getUri();
        }

        @Override
        public void visit(RewriteUriEntry entry) {
            this.text = "Not implemented yet";
        }

        @Override
        public void visit(DelegateUriEntry entry) {
            this.text = "Not implemented yet";
        }

        @Override
        public void visit(NextCatalogEntry entry) {
            this.text = "Not implemented yet";
        }
    }
}

