# -*- coding: utf-8 -*-
info = {
    "name": "fur",
    "date_order": "DMY",
    "january": [
        "zenâr",
        "zen"
    ],
    "february": [
        "fevrâr",
        "fev"
    ],
    "march": [
        "març",
        "mar"
    ],
    "april": [
        "avrîl",
        "avr"
    ],
    "may": [
        "mai"
    ],
    "june": [
        "jugn",
        "jug"
    ],
    "july": [
        "lui"
    ],
    "august": [
        "avost",
        "avo"
    ],
    "september": [
        "setembar",
        "set"
    ],
    "october": [
        "otubar",
        "otu"
    ],
    "november": [
        "novembar",
        "nov"
    ],
    "december": [
        "dicembar",
        "dic"
    ],
    "monday": [
        "lunis",
        "lun"
    ],
    "tuesday": [
        "martars",
        "mar"
    ],
    "wednesday": [
        "miercus",
        "mie"
    ],
    "thursday": [
        "joibe",
        "joi"
    ],
    "friday": [
        "vinars",
        "vin"
    ],
    "saturday": [
        "sabide",
        "sab"
    ],
    "sunday": [
        "domenie",
        "dom"
    ],
    "am": [
        "a"
    ],
    "pm": [
        "p"
    ],
    "year": [
        "an"
    ],
    "month": [
        "mês"
    ],
    "week": [
        "setemane"
    ],
    "day": [
        "dì"
    ],
    "hour": [
        "ore"
    ],
    "minute": [
        "minût"
    ],
    "second": [
        "secont"
    ],
    "relative-type": {
        "1 year ago": [
            "last year"
        ],
        "0 year ago": [
            "this year"
        ],
        "in 1 year": [
            "next year"
        ],
        "1 month ago": [
            "last month"
        ],
        "0 month ago": [
            "this month"
        ],
        "in 1 month": [
            "next month"
        ],
        "1 week ago": [
            "last week"
        ],
        "0 week ago": [
            "this week"
        ],
        "in 1 week": [
            "next week"
        ],
        "1 day ago": [
            "îr"
        ],
        "0 day ago": [
            "vuê"
        ],
        "in 1 day": [
            "doman"
        ],
        "0 hour ago": [
            "this hour"
        ],
        "0 minute ago": [
            "this minute"
        ],
        "0 second ago": [
            "now"
        ]
    },
    "relative-type-regex": {
        "in \\1 year": [
            "ca di (\\d+) an",
            "ca di (\\d+) agns"
        ],
        "\\1 year ago": [
            "(\\d+) an indaûr",
            "(\\d+) agns indaûr"
        ],
        "in \\1 month": [
            "ca di (\\d+) mês"
        ],
        "\\1 month ago": [
            "(\\d+) mês indaûr"
        ],
        "in \\1 week": [
            "ca di (\\d+) setemane",
            "ca di (\\d+) setemanis"
        ],
        "\\1 week ago": [
            "(\\d+) setemane indaûr",
            "(\\d+) setemanis indaûr"
        ],
        "in \\1 day": [
            "ca di (\\d+) zornade",
            "ca di (\\d+) zornadis"
        ],
        "\\1 day ago": [
            "(\\d+) zornade indaûr",
            "(\\d+) zornadis indaûr"
        ],
        "in \\1 hour": [
            "ca di (\\d+) ore",
            "ca di (\\d+) oris"
        ],
        "\\1 hour ago": [
            "(\\d+) ore indaûr",
            "(\\d+) oris indaûr"
        ],
        "in \\1 minute": [
            "ca di (\\d+) minût",
            "ca di (\\d+) minûts"
        ],
        "\\1 minute ago": [
            "(\\d+) minût indaûr",
            "(\\d+) minûts indaûr"
        ],
        "in \\1 second": [
            "ca di (\\d+) secont",
            "ca di (\\d+) seconts"
        ],
        "\\1 second ago": [
            "(\\d+) secont indaûr",
            "(\\d+) seconts indaûr"
        ]
    },
    "locale_specific": {},
    "skip": [
        " ",
        ".",
        ",",
        ";",
        "-",
        "/",
        "'",
        "|",
        "@",
        "[",
        "]",
        "，"
    ]
}
