#!/usr/bin/python

# ----------------------------------------------------------------------------
#
#  Copyright (C) 2008-2020 Fons Adriaensen <fons@linuxaudio.org>
#    
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http:#www.gnu.org/licenses/>.
#
# ----------------------------------------------------------------------------


import numpy as np
from audiotools.audiofile import AudioFile
from jacktools.jacksignal import JackSignal


# Simple example using Audiofile and Jacksignal.
# Skip 10 seconds then play 20 seconds of a stereo audio file.


F = AudioFile()
# Replace by your favourite track...
#
rv = F.open_read("/audio/audiofiles/tracks/susheela_raman-maya.wav")
if rv == None:
    print ("Failed to open audio file.")
    exit (1)

F.seek (10 * F.sampfreq ())
nsam = 20 * F.sampfreq ()
A2 = np.empty ([nsam, 2], dtype = np.float32)
F.read (A2)
F.close ()

J = JackSignal ("JackSignal")
if J.get_state () < 0:
    print ("Failed to create JackSignal -- is the server running ?")
    exit (1)

J.create_output (0, "out-1")
J.create_output (1, "out-2")
J.silence()
J.connect_output (0, "system:playback_1")
J.connect_output (1, "system:playback_2")

# Assign slices to outputs.
#
J.set_output_data (0, A2 [:,0])  
J.set_output_data (1, A2 [:,1])

# Set gains.
#
J.set_output_gain (0, 0.1)
J.set_output_gain (1, 0.1)

# Play.
#
J.process ()
J.wait ()
