/*
 * Decompiled with CFR 0.152.
 */
package scala.concurrent;

import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.ivy.core.LogOptions;
import scala.Function1;
import scala.Option;
import scala.concurrent.ExecutionContext;
import scala.concurrent.forkjoin.ForkJoinPool;
import scala.concurrent.forkjoin.ForkJoinTask;
import scala.concurrent.forkjoin.ForkJoinWorkerThread;
import scala.concurrent.impl.ExecutionContextImpl$$anon$3;
import scala.concurrent.impl.ExecutionContextImpl$$anon$4;
import scala.concurrent.impl.ExecutionContextImpl$$anonfun$1;
import scala.concurrent.impl.ExecutionContextImpl$$anonfun$2;
import scala.concurrent.impl.ExecutionContextImpl$$anonfun$3;
import scala.concurrent.impl.ExecutionContextImpl$DefaultThreadFactory;
import scala.math.package$;
import scala.util.control.NonFatal$;

public final class ExecutionContextExecutor
implements Executor,
ExecutionContext {
    public final Function1 scala$concurrent$impl$ExecutionContextImpl$$reporter;
    public final Thread.UncaughtExceptionHandler scala$concurrent$impl$ExecutionContextImpl$$uncaughtExceptionHandler;
    private final Executor executor;

    @Override
    public final ExecutionContext prepare() {
        return this;
    }

    private ExecutorService createExecutorService() {
        int n = ExecutionContextExecutor.getInt$1("scala.concurrent.context.maxThreads", new ExecutionContextImpl$$anonfun$3());
        int n2 = ExecutionContextExecutor.getInt$1("scala.concurrent.context.numThreads", new ExecutionContextImpl$$anonfun$2());
        int n3 = ExecutionContextExecutor.getInt$1("scala.concurrent.context.minThreads", new ExecutionContextImpl$$anonfun$1());
        while (n < n3) {
            int n4 = n;
            n = n3;
            n3 = n4;
        }
        int n5 = package$.min(package$.max(n2, n3), n);
        ExecutionContextImpl$DefaultThreadFactory executionContextImpl$DefaultThreadFactory = new ExecutionContextImpl$DefaultThreadFactory(this);
        try {
            return new ForkJoinPool(n5, executionContextImpl$DefaultThreadFactory, this.scala$concurrent$impl$ExecutionContextImpl$$uncaughtExceptionHandler, true);
        }
        catch (Throwable throwable) {
            Option option = NonFatal$.unapply(throwable);
            if (option.isEmpty()) {
                throw throwable;
            }
            System.err.println("Failed to create ForkJoinPool for the default ExecutionContext, falling back to ThreadPoolExecutor");
            ((Throwable)option.get()).printStackTrace(System.err);
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(n5, n5, 5L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(), executionContextImpl$DefaultThreadFactory);
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            return threadPoolExecutor;
        }
    }

    @Override
    public final void execute(Runnable runnable) {
        ExecutionContextExecutor executionContextExecutor = this;
        Executor executor = executionContextExecutor.executor;
        if (executor instanceof ForkJoinPool) {
            ForkJoinPool forkJoinPool = (ForkJoinPool)executor;
            ForkJoinTask forkJoinTask = runnable instanceof ForkJoinTask ? (ForkJoinTask)((Object)runnable) : new ExecutionContextImpl$$anon$3(runnable);
            Thread thread = Thread.currentThread();
            if (thread instanceof ForkJoinWorkerThread && ((ForkJoinWorkerThread)thread).getPool() == forkJoinPool) {
                forkJoinTask.fork();
                return;
            }
            forkJoinPool.execute(forkJoinTask);
            return;
        }
        executor.execute(runnable);
    }

    @Override
    public final void reportFailure(Throwable throwable) {
        this.scala$concurrent$impl$ExecutionContextImpl$$reporter.apply(throwable);
    }

    private static int getInt$1(String string, Function1 function1) {
        try {
            return LogOptions.unboxToInt(function1.apply(System.getProperty(string)));
        }
        catch (Exception exception) {
            return Runtime.getRuntime().availableProcessors();
        }
    }

    public ExecutionContextExecutor(Executor executor, Function1 function1) {
        this.scala$concurrent$impl$ExecutionContextImpl$$reporter = function1;
        this.scala$concurrent$impl$ExecutionContextImpl$$uncaughtExceptionHandler = new ExecutionContextImpl$$anon$4(this);
        Executor executor2 = executor == null ? this.createExecutorService() : executor;
        this.executor = executor2;
    }
}

