/*
 * Decompiled with CFR 0.152.
 */
package com.swoval.files;

import com.swoval.files.CachedDirectory;
import com.swoval.files.Entries;
import com.swoval.files.FileTreeDataViews;
import com.swoval.files.FileTreeView;
import com.swoval.files.FileTreeViews;
import com.swoval.files.LockableMap;
import com.swoval.files.MapOps;
import com.swoval.files.TypedPath;
import com.swoval.files.TypedPaths;
import com.swoval.functional.Either;
import com.swoval.functional.Filter;
import com.swoval.functional.Filters;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

class CachedDirectoryImpl<T>
implements CachedDirectory<T> {
    private final AtomicReference<FileTreeDataViews.Entry<T>> _cacheEntry;
    private final int depth;
    private final FileTreeView fileTreeView;
    private final boolean followLinks;
    private final FileTreeDataViews.Converter<T> converter;
    private final Filter<? super TypedPath> pathFilter;
    private final LockableMap<Path, CachedDirectoryImpl<T>> subdirectories = new LockableMap();
    private final Map<Path, FileTreeDataViews.Entry<T>> files = new HashMap<Path, FileTreeDataViews.Entry<T>>();

    CachedDirectoryImpl(TypedPath typedPath, FileTreeDataViews.Converter<T> converter, int n, Filter<? super TypedPath> filter, boolean bl, FileTreeView fileTreeView) {
        this.converter = converter;
        this.depth = n;
        this._cacheEntry = new AtomicReference<FileTreeDataViews.Entry<T>>(Entries.get(typedPath, converter, typedPath));
        this.pathFilter = filter;
        this.fileTreeView = fileTreeView;
        this.followLinks = bl;
    }

    CachedDirectoryImpl(TypedPath typedPath, FileTreeDataViews.Converter<T> converter, int n, Filter<? super TypedPath> filter, boolean bl) {
        this(typedPath, converter, n, filter, bl, FileTreeViews.getDefault(bl));
    }

    private static List<Path> parts(Path path) {
        Iterator<Path> iterator = path.iterator();
        ArrayList<Path> arrayList = new ArrayList<Path>();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList;
    }

    @Override
    public int getMaxDepth() {
        return this.depth;
    }

    @Override
    public Path getPath() {
        return this.getTypedPath().getPath();
    }

    @Override
    public TypedPath getTypedPath() {
        return this.getEntry().getTypedPath();
    }

    @Override
    public List<TypedPath> list(int n, Filter<? super TypedPath> filter) {
        return this.list(this.getPath(), n, filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TypedPath> list(Path path, int n, Filter<? super TypedPath> filter) {
        if (this.subdirectories.lock()) {
            try {
                Either<FileTreeDataViews.Entry<T>, CachedDirectoryImpl<T>> either = this.find(path);
                if (either != null) {
                    if (either.isRight()) {
                        ArrayList<TypedPath> arrayList = new ArrayList<TypedPath>();
                        super.listImpl(n, filter, arrayList, new ListTransformer<T, TypedPath>(){

                            @Override
                            public TypedPath apply(FileTreeDataViews.Entry<T> entry) {
                                return TypedPaths.getDelegate(entry.getTypedPath().getPath(), entry.getTypedPath());
                            }
                        });
                        ArrayList<TypedPath> arrayList2 = arrayList;
                        return arrayList2;
                    }
                    FileTreeDataViews.Entry<T> entry = Either.leftProjection(either).getValue();
                    ArrayList<TypedPath> arrayList = new ArrayList<TypedPath>();
                    if (entry != null && filter.accept(entry.getTypedPath()) && n == -1) {
                        arrayList.add(TypedPaths.getDelegate(entry.getTypedPath().getPath(), entry.getTypedPath()));
                    }
                    ArrayList<TypedPath> arrayList3 = arrayList;
                    return arrayList3;
                }
                List<TypedPath> list = Collections.emptyList();
                return list;
            }
            finally {
                this.subdirectories.unlock();
            }
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<FileTreeDataViews.Entry<T>> listEntries(Path path, int n, Filter<? super FileTreeDataViews.Entry<T>> filter) {
        if (this.subdirectories.lock()) {
            try {
                Either<FileTreeDataViews.Entry<T>, CachedDirectoryImpl<T>> either = this.find(path);
                if (either != null) {
                    if (either.isRight()) {
                        ArrayList<FileTreeDataViews.Entry<T>> arrayList = new ArrayList<FileTreeDataViews.Entry<T>>();
                        super.listImpl(n, filter, arrayList, new ListTransformer<T, FileTreeDataViews.Entry<T>>(){

                            @Override
                            public FileTreeDataViews.Entry<T> apply(FileTreeDataViews.Entry<T> entry) {
                                return entry;
                            }
                        });
                        ArrayList<FileTreeDataViews.Entry<T>> arrayList2 = arrayList;
                        return arrayList2;
                    }
                    FileTreeDataViews.Entry<T> entry = Either.leftProjection(either).getValue();
                    ArrayList<FileTreeDataViews.Entry<T>> arrayList = new ArrayList<FileTreeDataViews.Entry<T>>();
                    if (entry != null && filter.accept(entry)) {
                        arrayList.add(entry);
                    }
                    ArrayList<FileTreeDataViews.Entry<T>> arrayList3 = arrayList;
                    return arrayList3;
                }
                List<FileTreeDataViews.Entry<T>> list = Collections.emptyList();
                return list;
            }
            finally {
                this.subdirectories.unlock();
            }
        }
        return Collections.emptyList();
    }

    @Override
    public List<FileTreeDataViews.Entry<T>> listEntries(int n, Filter<? super FileTreeDataViews.Entry<T>> filter) {
        return this.listEntries(this.getPath(), n, filter);
    }

    @Override
    public FileTreeDataViews.Entry<T> getEntry() {
        return this._cacheEntry.get();
    }

    @Override
    public void close() {
        this.subdirectories.clear();
        this.files.clear();
    }

    @Override
    public FileTreeViews.Updates<T> update(TypedPath typedPath) throws IOException {
        return this.update(typedPath, true);
    }

    @Override
    public FileTreeViews.Updates<T> update(TypedPath typedPath, boolean bl) throws IOException {
        if (this.pathFilter.accept(typedPath)) {
            if (typedPath.exists()) {
                return this.updateImpl(typedPath.getPath().equals(this.getPath()) ? new ArrayList() : CachedDirectoryImpl.parts(this.getPath().relativize(typedPath.getPath())), typedPath, bl);
            }
            Iterator<FileTreeDataViews.Entry<T>> iterator = this.remove(typedPath.getPath()).iterator();
            FileTreeViews.Updates<T> updates = new FileTreeViews.Updates<T>();
            while (iterator.hasNext()) {
                updates.onDelete(iterator.next());
            }
            return updates;
        }
        return new FileTreeViews.Updates();
    }

    @Override
    public List<FileTreeDataViews.Entry<T>> remove(Path path) {
        if (path.isAbsolute() && path.startsWith(this.getPath())) {
            return this.removeImpl(CachedDirectoryImpl.parts(this.getPath().relativize(path)));
        }
        return Collections.emptyList();
    }

    public String toString() {
        return "CachedDirectory(" + this.getPath() + ", maxDepth = " + this.depth + ")";
    }

    private int subdirectoryDepth() {
        return this.depth == Integer.MAX_VALUE ? this.depth : (this.depth > 0 ? this.depth - 1 : 0);
    }

    private void addDirectory(CachedDirectoryImpl<T> cachedDirectoryImpl, TypedPath typedPath, FileTreeViews.Updates<T> updates) {
        Iterator<FileTreeDataViews.Entry<T>> iterator;
        Path path = typedPath.getPath();
        CachedDirectoryImpl<T> cachedDirectoryImpl2 = new CachedDirectoryImpl<T>(typedPath, this.converter, super.subdirectoryDepth(), this.pathFilter, this.followLinks);
        boolean bl = true;
        try {
            iterator = cachedDirectoryImpl2.getEntry().getTypedPath();
            if (iterator.isDirectory() && (this.followLinks || !iterator.isSymbolicLink())) {
                cachedDirectoryImpl2.init();
            } else {
                cachedDirectoryImpl.files.put(iterator.getPath(), cachedDirectoryImpl2.getEntry());
                bl = false;
            }
        }
        catch (NoSuchFileException noSuchFileException) {
            bl = false;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (bl) {
            iterator = new HashMap();
            HashMap<Path, FileTreeDataViews.Entry<T>> hashMap = new HashMap<Path, FileTreeDataViews.Entry<T>>();
            CachedDirectoryImpl<T> cachedDirectoryImpl3 = cachedDirectoryImpl.subdirectories.put(path.getFileName(), cachedDirectoryImpl2);
            if (cachedDirectoryImpl3 != null) {
                iterator.put(cachedDirectoryImpl3.getPath(), cachedDirectoryImpl3.getEntry());
                for (FileTreeDataViews.Entry<T> entry : cachedDirectoryImpl3.listEntries(Integer.MAX_VALUE, Filters.AllPass)) {
                    iterator.put(entry.getTypedPath().getPath(), entry);
                }
                cachedDirectoryImpl3.close();
            }
            hashMap.put(cachedDirectoryImpl2.getPath(), cachedDirectoryImpl2.getEntry());
            for (FileTreeDataViews.Entry<T> entry : cachedDirectoryImpl2.listEntries(Integer.MAX_VALUE, Filters.AllPass)) {
                hashMap.put(entry.getTypedPath().getPath(), entry);
            }
            MapOps.diffDirectoryEntries(iterator, hashMap, updates);
        } else {
            iterator = this.remove(cachedDirectoryImpl2.getPath()).iterator();
            while (iterator.hasNext()) {
                updates.onDelete(iterator.next());
            }
        }
    }

    private boolean isLoop(Path path, Path path2) {
        return path.startsWith(path2) && !path.equals(path2);
    }

    private void updateDirectory(CachedDirectoryImpl<T> cachedDirectoryImpl, FileTreeViews.Updates<T> updates, FileTreeDataViews.Entry<T> entry) {
        updates.onUpdate(cachedDirectoryImpl.getEntry(), entry);
        cachedDirectoryImpl._cacheEntry.set(entry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileTreeViews.Updates<T> updateImpl(List<Path> list, TypedPath typedPath, boolean bl) throws IOException {
        FileTreeViews.Updates<T> updates = new FileTreeViews.Updates<T>();
        if (this.subdirectories.lock()) {
            try {
                if (!list.isEmpty()) {
                    Iterator<Path> iterator = list.iterator();
                    CachedDirectoryImpl<T> cachedDirectoryImpl = this;
                    while (iterator.hasNext() && cachedDirectoryImpl != null && cachedDirectoryImpl.depth >= 0) {
                        Object object;
                        Path path = iterator.next();
                        if (path.toString().isEmpty()) {
                            object = updates;
                            return object;
                        }
                        object = cachedDirectoryImpl.getPath().resolve(path);
                        if (!iterator.hasNext()) {
                            boolean bl2;
                            boolean bl3 = bl2 = typedPath.isDirectory() && (this.followLinks || !typedPath.isSymbolicLink());
                            if (!bl2 || cachedDirectoryImpl.depth <= 0 || super.isLoop((Path)object, TypedPaths.expanded(typedPath))) {
                                CachedDirectoryImpl<T> cachedDirectoryImpl2;
                                CachedDirectoryImpl<T> cachedDirectoryImpl3 = bl2 ? cachedDirectoryImpl.subdirectories.get(path) : null;
                                FileTreeDataViews.Entry<T> entry = cachedDirectoryImpl.files.remove(path);
                                FileTreeDataViews.Entry<T> entry2 = entry != null ? entry : (cachedDirectoryImpl3 != null ? cachedDirectoryImpl3.getEntry() : null);
                                FileTreeDataViews.Entry<T> entry3 = Entries.get(TypedPaths.getDelegate((Path)object, typedPath), this.converter, TypedPaths.getDelegate((Path)object, typedPath));
                                if (bl2) {
                                    cachedDirectoryImpl2 = cachedDirectoryImpl.subdirectories.get(path);
                                    if (cachedDirectoryImpl2 == null || bl) {
                                        cachedDirectoryImpl.subdirectories.put(path, new CachedDirectoryImpl<T>(TypedPaths.getDelegate((Path)object, typedPath), this.converter, -1, this.pathFilter, this.followLinks));
                                    } else {
                                        super.updateDirectory(cachedDirectoryImpl2, updates, entry3);
                                    }
                                } else {
                                    cachedDirectoryImpl.files.put(path, entry3);
                                }
                                CachedDirectoryImpl<T> cachedDirectoryImpl4 = cachedDirectoryImpl2 = entry2 == null ? null : Entries.resolve(cachedDirectoryImpl.getPath(), entry2);
                                if (cachedDirectoryImpl2 == null) {
                                    updates.onCreate(Entries.resolve(cachedDirectoryImpl.getPath(), entry3));
                                } else {
                                    updates.onUpdate((FileTreeDataViews.Entry<T>)((Object)cachedDirectoryImpl2), Entries.resolve(cachedDirectoryImpl.getPath(), entry3));
                                }
                                FileTreeViews.Updates<T> updates2 = updates;
                                return updates2;
                            }
                            CachedDirectoryImpl<T> cachedDirectoryImpl5 = cachedDirectoryImpl.subdirectories.get(path);
                            if (cachedDirectoryImpl5 == null || bl) {
                                super.addDirectory(cachedDirectoryImpl, typedPath, updates);
                            } else {
                                super.updateDirectory(cachedDirectoryImpl5, updates, Entries.get(typedPath, this.converter, typedPath));
                            }
                            FileTreeViews.Updates<T> updates3 = updates;
                            return updates3;
                        }
                        CachedDirectoryImpl<T> cachedDirectoryImpl6 = cachedDirectoryImpl.subdirectories.get(path);
                        if (cachedDirectoryImpl6 == null && cachedDirectoryImpl.depth > 0) {
                            super.addDirectory(cachedDirectoryImpl, TypedPaths.get(cachedDirectoryImpl.getPath().resolve(path)), updates);
                        }
                        cachedDirectoryImpl = cachedDirectoryImpl6;
                    }
                } else if (typedPath.isDirectory() && bl) {
                    List<FileTreeDataViews.Entry<T>> list2 = this.listEntries(this.getMaxDepth(), Filters.AllPass);
                    this.init();
                    List<FileTreeDataViews.Entry<T>> list3 = this.listEntries(this.getMaxDepth(), Filters.AllPass);
                    MapOps.diffDirectoryEntries(list2, list3, updates);
                } else {
                    FileTreeDataViews.Entry<T> entry = this.getEntry();
                    TypedPath typedPath2 = TypedPaths.getDelegate(TypedPaths.expanded(this.getTypedPath()), typedPath);
                    FileTreeDataViews.Entry<T> entry4 = Entries.get(typedPath, this.converter, typedPath2);
                    this._cacheEntry.set(entry4);
                    updates.onUpdate(entry, this.getEntry());
                }
            }
            finally {
                this.subdirectories.unlock();
            }
        }
        return updates;
    }

    private Either<FileTreeDataViews.Entry<T>, CachedDirectoryImpl<T>> findImpl(List<Path> list) {
        Iterator<Path> iterator = list.iterator();
        CachedDirectoryImpl<T> cachedDirectoryImpl = this;
        Either either = null;
        while (iterator.hasNext() && cachedDirectoryImpl != null && either == null) {
            Path path = iterator.next();
            if (!iterator.hasNext()) {
                CachedDirectoryImpl<T> cachedDirectoryImpl2 = cachedDirectoryImpl.subdirectories.get(path);
                if (cachedDirectoryImpl2 != null) {
                    either = Either.right(cachedDirectoryImpl2);
                    continue;
                }
                FileTreeDataViews.Entry<T> entry = cachedDirectoryImpl.files.get(path);
                if (entry == null) continue;
                either = Either.left(Entries.resolve(cachedDirectoryImpl.getPath(), entry));
                continue;
            }
            cachedDirectoryImpl = cachedDirectoryImpl.subdirectories.get(path);
        }
        return either;
    }

    private Either<FileTreeDataViews.Entry<T>, CachedDirectoryImpl<T>> find(Path path) {
        if (!this.getEntry().getTypedPath().exists()) {
            return null;
        }
        if (path.equals(this.getPath())) {
            return Either.right(this);
        }
        if (!path.isAbsolute()) {
            return this.findImpl(CachedDirectoryImpl.parts(path));
        }
        if (path.startsWith(this.getPath())) {
            return this.findImpl(CachedDirectoryImpl.parts(this.getPath().relativize(path)));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <R> void listImpl(int n, Filter<? super R> filter, List<R> list, ListTransformer<T, R> listTransformer) {
        if (this.depth < 0 || n < 0) {
            list.add(listTransformer.apply(this.getEntry()));
        } else if (this.subdirectories.lock()) {
            try {
                ArrayList<FileTreeDataViews.Entry<T>> arrayList = new ArrayList<FileTreeDataViews.Entry<T>>(this.files.values());
                ArrayList<CachedDirectoryImpl<T>> arrayList2 = new ArrayList<CachedDirectoryImpl<T>>(this.subdirectories.values());
                for (FileTreeDataViews.Entry object : arrayList) {
                    R r = listTransformer.apply(Entries.resolve(this.getPath(), object));
                    if (!filter.accept(r)) continue;
                    list.add(r);
                }
                for (CachedDirectoryImpl cachedDirectoryImpl : arrayList2) {
                    FileTreeDataViews.Entry<T> entry = cachedDirectoryImpl.getEntry();
                    R r = listTransformer.apply(Entries.resolve(this.getPath(), entry));
                    if (filter.accept(r)) {
                        list.add(r);
                    }
                    if (n <= 0) continue;
                    cachedDirectoryImpl.listImpl(n - 1, filter, list, listTransformer);
                }
            }
            finally {
                this.subdirectories.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private List<FileTreeDataViews.Entry<T>> removeImpl(List<Path> list) {
        ArrayList<FileTreeDataViews.Entry<T>> arrayList = new ArrayList<FileTreeDataViews.Entry<T>>();
        if (this.subdirectories.lock()) {
            try {
                if (list.isEmpty()) {
                    for (CachedDirectoryImpl<T> object2 : this.subdirectories.values()) {
                        arrayList.addAll(object2.remove(object2.getPath()));
                    }
                    Iterator<FileTreeDataViews.Entry<T>> cachedDirectoryImpl = this.files.values().iterator();
                    while (cachedDirectoryImpl.hasNext()) {
                        arrayList.add(Entries.setExists(cachedDirectoryImpl.next(), false));
                    }
                    this._cacheEntry.set(Entries.setExists(this.getEntry(), false));
                } else {
                    void var4_8;
                    Iterator<Path> iterator = list.iterator();
                    CachedDirectoryImpl cachedDirectoryImpl = this;
                    while (iterator.hasNext() && var4_8 != null) {
                        Path path = iterator.next();
                        if (!iterator.hasNext()) {
                            CachedDirectoryImpl<T> cachedDirectoryImpl2;
                            FileTreeDataViews.Entry<T> entry = var4_8.files.remove(path);
                            if (entry != null) {
                                arrayList.add(Entries.setExists(Entries.resolve(var4_8.getPath(), entry), false));
                            }
                            if ((cachedDirectoryImpl2 = var4_8.subdirectories.remove(path)) == null) continue;
                            Iterator<FileTreeDataViews.Entry<T>> iterator2 = cachedDirectoryImpl2.listEntries(Integer.MAX_VALUE, Filters.AllPass).iterator();
                            while (iterator2.hasNext()) {
                                arrayList.add(Entries.setExists(iterator2.next(), false));
                            }
                            arrayList.add(Entries.setExists(cachedDirectoryImpl2.getEntry(), false));
                            continue;
                        }
                        CachedDirectoryImpl<T> cachedDirectoryImpl3 = var4_8.subdirectories.get(path);
                    }
                }
            }
            finally {
                this.subdirectories.unlock();
            }
        }
        return arrayList;
    }

    CachedDirectoryImpl<T> init() throws IOException {
        return this.init(this.getTypedPath().getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CachedDirectoryImpl<T> init(Path path) throws IOException {
        if (this.subdirectories.lock()) {
            try {
                this.subdirectories.clear();
                this.files.clear();
                if (this.depth >= 0 && (!this.getPath().startsWith(path) || this.getPath().equals(path))) {
                    for (TypedPath typedPath : this.fileTreeView.list(this.getPath(), 0, this.pathFilter)) {
                        Path path2 = typedPath.getPath();
                        Path path3 = this.getTypedPath().getPath().relativize(path2).getFileName();
                        if (typedPath.isDirectory()) {
                            if (this.depth > 0) {
                                if (!typedPath.isSymbolicLink() || !this.isLoop(path2, TypedPaths.expanded(typedPath))) {
                                    CachedDirectoryImpl<T> cachedDirectoryImpl = new CachedDirectoryImpl<T>(typedPath, this.converter, this.subdirectoryDepth(), this.pathFilter, this.followLinks);
                                    try {
                                        cachedDirectoryImpl.init();
                                        this.subdirectories.put(path3, cachedDirectoryImpl);
                                    }
                                    catch (IOException iOException) {
                                        if (!Files.exists(cachedDirectoryImpl.getPath(), new LinkOption[0])) continue;
                                        this.subdirectories.put(path3, cachedDirectoryImpl);
                                    }
                                    continue;
                                }
                                this.subdirectories.put(path3, new CachedDirectoryImpl<T>(typedPath, this.converter, -1, this.pathFilter, this.followLinks));
                                continue;
                            }
                            this.files.put(path3, Entries.get(TypedPaths.getDelegate(path3, typedPath), this.converter, typedPath));
                            continue;
                        }
                        this.files.put(path3, Entries.get(TypedPaths.getDelegate(path3, typedPath), this.converter, typedPath));
                    }
                }
            }
            finally {
                this.subdirectories.unlock();
            }
        }
        return this;
    }

    private static interface ListTransformer<T, R> {
        public R apply(FileTreeDataViews.Entry<T> var1);
    }
}

