/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal;

import java.io.Serializable;
import java.net.URI;
import sbt.AutoPlugin;
import sbt.Extracted;
import sbt.Keys$;
import sbt.Plugins;
import sbt.Plugins$;
import sbt.Project$;
import sbt.ProjectRef;
import sbt.Reference;
import sbt.ResolvedProject;
import sbt.SettingKey;
import sbt.State;
import sbt.State$;
import sbt.internal.BuildUtil$;
import sbt.internal.LoadedBuildUnit;
import sbt.internal.PluginsDebug;
import sbt.internal.util.AttributeKey;
import sbt.internal.util.Dag$;
import sbt.internal.util.Relation;
import sbt.internal.util.Relation$;
import sbt.util.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenSetLike;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;

public final class PluginsDebug$ {
    public static PluginsDebug$ MODULE$;

    static {
        new PluginsDebug$();
    }

    public String helpAll(State s) {
        String string;
        if (Project$.MODULE$.isProjectLoaded(s)) {
            Extracted extracted = Project$.MODULE$.extract(s);
            scala.collection.immutable.Iterable buildStrings = (scala.collection.immutable.Iterable)extracted.structure().units().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)PluginsDebug$.$anonfun$helpAll$4(check$ifrefutable$1))).map((Function1 & Serializable & scala.Serializable)x$10 -> {
                Tuple2 tuple2 = x$10;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                URI uri = (URI)tuple2._1();
                LoadedBuildUnit build = (LoadedBuildUnit)tuple2._2();
                String string = this.helpBuild$1(uri, build);
                return string;
            }, Iterable$.MODULE$.canBuildFrom());
            string = buildStrings.mkString("\n");
        } else {
            string = "No project is currently loaded.";
        }
        return string;
    }

    public Map<String, AutoPlugin> autoPluginMap(State s) {
        Extracted extracted = Project$.MODULE$.extract(s);
        return ((TraversableOnce)((List)extracted.structure().units().values().toList().flatMap((Function1 & Serializable & scala.Serializable)build -> MODULE$.availableAutoPlugins((LoadedBuildUnit)build), List$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)plugin -> new Tuple2((Object)plugin.label(), plugin), List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private Seq<AutoPlugin> availableAutoPlugins(LoadedBuildUnit build) {
        return (Seq)build.unit().plugins().detected().autoPlugins().map((Function1 & Serializable & scala.Serializable)x$11 -> x$11.value(), Seq$.MODULE$.canBuildFrom());
    }

    public String help(AutoPlugin plugin, State s) {
        String string;
        LazyRef context$lzy = new LazyRef();
        LazyRef debug$lzy = new LazyRef();
        Extracted extracted = Project$.MODULE$.extract(s);
        Map perBuild = extracted.structure().units().mapValues((Function1 & Serializable & scala.Serializable)unit -> MODULE$.availableAutoPlugins((LoadedBuildUnit)unit).toSet());
        List pluginsThisBuild = ((TraversableOnce)perBuild.getOrElse((Object)extracted.currentRef().build(), (Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Set().empty())).toList();
        if (!pluginsThisBuild.contains((Object)plugin)) {
            List availableInBuilds = (List)((List)perBuild.toList().filter((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)PluginsDebug$.$anonfun$help$3(plugin, x$12)))).map((Function1 & Serializable & scala.Serializable)x$13 -> (URI)x$13._1(), List$.MODULE$.canBuildFrom());
            String s1 = new StringBuilder(36).append("Plugin ").append(plugin.label()).append(" is only available in builds:").toString();
            String s2 = availableInBuilds.mkString("\n\t");
            String s3 = "Switch to a project in one of those builds using `project` and rerun this command for more information.";
            string = new StringBuilder(3).append(s1).append("\n\t").append(s2).append("\n").append(s3).toString();
        } else if (PluginsDebug$.definesPlugin$1(extracted.currentProject(), plugin)) {
            string = PluginsDebug$.debug$1(debug$lzy, context$lzy, extracted, pluginsThisBuild, s).sbt$internal$PluginsDebug$$activatedHelp(plugin);
        } else {
            Seq thisAggregated = (Seq)BuildUtil$.MODULE$.dependencies(extracted.structure().units()).aggregateTransitive().getOrElse((Object)extracted.currentRef(), (Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
            Seq definedInAggregated = (Seq)thisAggregated.filter((Function1 & Serializable & scala.Serializable)ref -> BoxesRunTime.boxToBoolean((boolean)PluginsDebug$.definesPlugin$1(PluginsDebug$.projectForRef$1(ref, extracted), plugin)));
            if (definedInAggregated.nonEmpty()) {
                Seq projectNames = (Seq)definedInAggregated.map((Function1 & Serializable & scala.Serializable)x$14 -> x$14.project(), Seq$.MODULE$.canBuildFrom());
                String s2 = projectNames.mkString("\n\t");
                string = new StringBuilder(103).append("Plugin ").append(plugin.label()).append(" is not activated on this project, but this project aggregates projects where it is activated:\n\t").append(s2).toString();
            } else {
                String base = PluginsDebug$.debug$1(debug$lzy, context$lzy, extracted, pluginsThisBuild, s).sbt$internal$PluginsDebug$$deactivatedHelp(plugin, PluginsDebug$.context$2(context$lzy, extracted, pluginsThisBuild, s));
                String aggNote = thisAggregated.nonEmpty() ? "Note: This project aggregates other projects and this" : "Note: This";
                String common = " information is for this project only.";
                String helpOther = "To see how to activate this plugin for another project, change to the project using `project <name>` and rerun this command.";
                string = new StringBuilder(2).append(base).append("\n").append(aggNote).append(common).append("\n").append(helpOther).toString();
            }
        }
        return string;
    }

    public PluginsDebug apply(List<AutoPlugin> available) {
        Relation<AutoPlugin, AttributeKey<?>> keyR = this.definedKeys(available);
        Map nameToKey = ((TraversableOnce)keyR._2s().toList().map((Function1 & Serializable & scala.Serializable)key -> new Tuple2((Object)key.label(), key), List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        return new PluginsDebug(available, nameToKey, keyR);
    }

    public PluginsDebug.PluginEnable pluginEnable(PluginsDebug.Context context, AutoPlugin plugin) {
        return context.enabled().contains((Object)plugin) ? new PluginsDebug.PluginActivated(plugin, context) : this.enableDeactivated(context, plugin);
    }

    private PluginsDebug.PluginEnable enableDeactivated(PluginsDebug.Context context, AutoPlugin plugin) {
        PluginsDebug.EnableDeactivated enableDeactivated;
        Set initialModel = context.enabled().toSet();
        Seq<Plugins.Basic> initial = Plugins$.MODULE$.flatten(context.initial());
        Set<AutoPlugin> initialPlugins = this.plugins(initial);
        Set<AutoPlugin> initialExcludes = this.excludes(initial);
        Seq<Plugins.Basic> minModel = this.minimalModel(plugin);
        Set<AutoPlugin> minRequiredPlugins = this.plugins(minModel);
        Set<AutoPlugin> minAbsentPlugins = this.excludes(minModel);
        Set contradictions = (Set)minAbsentPlugins.$amp(minRequiredPlugins);
        if (contradictions.nonEmpty()) {
            enableDeactivated = new PluginsDebug.PluginImpossible(plugin, context, (Set<AutoPlugin>)contradictions);
        } else {
            Set addToExistingPlugins = (Set)minRequiredPlugins.$minus$minus(initialPlugins);
            Set blockingExcludes = (Set)initialExcludes.$amp(minRequiredPlugins);
            Plugins incrementalInputs = Plugins$.MODULE$.and(this.includeAll((Set)minRequiredPlugins.$plus$plus(initialPlugins)), this.excludeAll((Set<AutoPlugin>)((Set)minAbsentPlugins.$plus$plus(initialExcludes).$minus$minus(minRequiredPlugins))));
            Set incrementalModel = ((TraversableOnce)context.deducePlugin().apply((Object)incrementalInputs, (Object)context.log())).toSet();
            Set extraPlugins = (Set)incrementalModel.$minus$minus(minRequiredPlugins).$minus$minus((GenTraversableOnce)initialModel);
            Set willRemove = (Set)initialModel.$minus$minus((GenTraversableOnce)incrementalModel);
            Set minDeactivate = (Set)minAbsentPlugins.filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)Plugins$.MODULE$.satisfied(p.requires(), (Set<AutoPlugin>)incrementalModel)));
            List deactivate = (List)minDeactivate.toList().map((Function1 & Serializable & scala.Serializable)d -> {
                Set removeToDeactivate = (Set)MODULE$.plugins(MODULE$.minimalModel((AutoPlugin)d)).$minus$minus((GenTraversableOnce)minRequiredPlugins);
                boolean newlySelected = !initialModel.apply(d);
                return new PluginsDebug.DeactivatePlugin((AutoPlugin)d, (Set<AutoPlugin>)removeToDeactivate, newlySelected);
            }, List$.MODULE$.canBuildFrom());
            enableDeactivated = new PluginsDebug.PluginRequirements(plugin, context, (Set<AutoPlugin>)blockingExcludes, (Set<AutoPlugin>)addToExistingPlugins, (Set<AutoPlugin>)extraPlugins, (Set<AutoPlugin>)willRemove, (List<PluginsDebug.DeactivatePlugin>)deactivate);
        }
        return enableDeactivated;
    }

    private <T extends Plugins.Basic> Plugins includeAll(Set<T> basic) {
        return new Plugins.And((List<Plugins.Basic>)basic.toList());
    }

    private Plugins excludeAll(Set<AutoPlugin> plugins2) {
        return new Plugins.And((List<Plugins.Basic>)((TraversableOnce)plugins2.map((Function1 & Serializable & scala.Serializable)p -> new Plugins.Exclude((AutoPlugin)p), Set$.MODULE$.canBuildFrom())).toList());
    }

    private Set<AutoPlugin> excludes(Seq<Plugins.Basic> bs) {
        return ((TraversableOnce)bs.collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Plugins.Basic, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof Plugins.Exclude) {
                    Plugins.Exclude exclude = (Plugins.Exclude)A1;
                    AutoPlugin b = exclude.n();
                    object = b;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Plugins.Basic x1) {
                Plugins.Basic basic = x1;
                boolean bl = basic instanceof Plugins.Exclude;
                return bl;
            }
        }, Seq$.MODULE$.canBuildFrom())).toSet();
    }

    private Set<AutoPlugin> plugins(Seq<Plugins.Basic> bs) {
        return ((TraversableOnce)bs.collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Plugins.Basic, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof AutoPlugin) {
                    AutoPlugin autoPlugin = (AutoPlugin)A1;
                    object = autoPlugin;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Plugins.Basic x1) {
                Plugins.Basic basic = x1;
                boolean bl = basic instanceof AutoPlugin;
                return bl;
            }
        }, Seq$.MODULE$.canBuildFrom())).toSet();
    }

    private Seq<Plugins.Basic> minimalModel(AutoPlugin plugin) {
        return Dag$.MODULE$.topologicalSortUnchecked((Object)plugin, (Function1 & Serializable & scala.Serializable)x0$1 -> {
            Nil$ nil$;
            Plugins.Basic basic = x0$1;
            if (basic instanceof Plugins.Exclude) {
                nil$ = Nil$.MODULE$;
            } else if (basic instanceof AutoPlugin) {
                AutoPlugin autoPlugin = (AutoPlugin)basic;
                nil$ = (Iterable)Plugins$.MODULE$.flatten(autoPlugin.requires()).$colon$plus((Object)plugin, Seq$.MODULE$.canBuildFrom());
            } else {
                throw new MatchError((Object)basic);
            }
            return nil$;
        });
    }

    public String explainPluginEnable(PluginsDebug.PluginEnable ps) {
        String string;
        PluginsDebug.PluginEnable pluginEnable = ps;
        if (pluginEnable instanceof PluginsDebug.PluginRequirements) {
            PluginsDebug.PluginRequirements pluginRequirements = (PluginsDebug.PluginRequirements)pluginEnable;
            AutoPlugin plugin = pluginRequirements.plugin();
            Set<AutoPlugin> blockingExcludes = pluginRequirements.blockingExcludes();
            Set<AutoPlugin> enablingPlugins = pluginRequirements.enablingPlugins();
            Set<AutoPlugin> extraEnabledPlugins = pluginRequirements.extraEnabledPlugins();
            Set<AutoPlugin> toBeRemoved = pluginRequirements.willRemove();
            List<PluginsDebug.DeactivatePlugin> deactivate = pluginRequirements.deactivate();
            String string2 = PluginsDebug$.indent$1(this.excludedError(false, (List<AutoPlugin>)blockingExcludes.toList()));
            String string3 = PluginsDebug$.indent$1(this.required((List<AutoPlugin>)enablingPlugins.toList()));
            String string4 = PluginsDebug$.indent$1(this.needToDeactivate(deactivate));
            String string5 = PluginsDebug$.note$1(this.willAdd(plugin, (List<AutoPlugin>)extraEnabledPlugins.toList()));
            String string6 = PluginsDebug$.note$1(this.willRemove(plugin, (List<AutoPlugin>)toBeRemoved.toList()));
            List parts = Nil$.MODULE$.$colon$colon((Object)string6).$colon$colon((Object)string5).$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2);
            string = ((TraversableOnce)parts.filterNot((Function1 & Serializable & scala.Serializable)x$20 -> BoxesRunTime.boxToBoolean((boolean)x$20.isEmpty()))).mkString("\n");
        } else if (pluginEnable instanceof PluginsDebug.PluginImpossible) {
            PluginsDebug.PluginImpossible pluginImpossible = (PluginsDebug.PluginImpossible)pluginEnable;
            AutoPlugin plugin = pluginImpossible.plugin();
            Set<AutoPlugin> contradictions = pluginImpossible.contradictions();
            string = this.pluginImpossible(plugin, contradictions);
        } else if (pluginEnable instanceof PluginsDebug.PluginActivated) {
            PluginsDebug.PluginActivated pluginActivated = (PluginsDebug.PluginActivated)pluginEnable;
            AutoPlugin plugin = pluginActivated.plugin();
            string = new StringBuilder(26).append("Plugin ").append(plugin.label()).append(" already activated.").toString();
        } else {
            throw new MatchError((Object)pluginEnable);
        }
        return string;
    }

    public Relation<AutoPlugin, AttributeKey<?>> definedKeys(List<AutoPlugin> available) {
        Relation empty = Relation$.MODULE$.empty();
        return (Relation)available.foldLeft((Object)empty, (Function2 & Serializable & scala.Serializable)(r, p) -> r.$plus(p, (Traversable)PluginsDebug$.extractDefinedKeys$1(PluginsDebug$.allSettings$1(p))));
    }

    private String excludedError(boolean transitive, List<AutoPlugin> dependencies2) {
        return this.str(dependencies2, (Function1 & Serializable & scala.Serializable)dependency -> MODULE$.excludedPluginError(transitive, (AutoPlugin)dependency), (Function1 & Serializable & scala.Serializable)dependencies -> MODULE$.excludedPluginsError(transitive, (List<AutoPlugin>)dependencies));
    }

    private String excludedPluginError(boolean transitive, AutoPlugin dependency) {
        return new StringBuilder(34).append("Required ").append(this.transitiveString(transitive)).append("dependency ").append(dependency.label()).append(" was excluded.").toString();
    }

    private String excludedPluginsError(boolean transitive, List<AutoPlugin> dependencies) {
        return new StringBuilder(38).append("Required ").append(this.transitiveString(transitive)).append("dependencies were excluded:\n\t").append(this.labels(dependencies).mkString("\n\t")).toString();
    }

    private String transitiveString(boolean transitive) {
        return transitive ? "(transitive) " : "";
    }

    private String required(List<AutoPlugin> plugins3) {
        return this.str(plugins3, (Function1 & Serializable & scala.Serializable)plugin -> MODULE$.requiredPlugin((AutoPlugin)plugin), (Function1 & Serializable & scala.Serializable)plugins2 -> MODULE$.requiredPlugins((List<AutoPlugin>)plugins2));
    }

    private String requiredPlugin(AutoPlugin plugin) {
        return new StringBuilder(29).append("Required plugin ").append(plugin.label()).append(" not present.").toString();
    }

    private String requiredPlugins(List<AutoPlugin> plugins2) {
        return new StringBuilder(31).append("Required plugins not present:\n\t").append(((TraversableOnce)plugins2.map((Function1 & Serializable & scala.Serializable)x$22 -> x$22.label(), List$.MODULE$.canBuildFrom())).mkString("\n\t")).toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <A> String str(List<A> list, Function1<A, String> f, Function1<List<A>, String> fs) {
        List<A> list2 = list;
        if (Nil$.MODULE$.equals(list2)) {
            return "";
        }
        if (!(list2 instanceof .colon.colon)) return (String)fs.apply(list);
        .colon.colon colon2 = (.colon.colon)list2;
        Object single = colon2.head();
        List list3 = colon2.tl$access$1();
        if (!Nil$.MODULE$.equals(list3)) return (String)fs.apply(list);
        return (String)f.apply(single);
    }

    private String willAdd(AutoPlugin base, List<AutoPlugin> plugins3) {
        return this.str(plugins3, (Function1 & Serializable & scala.Serializable)plugin -> MODULE$.willAddPlugin(base, (AutoPlugin)plugin), (Function1 & Serializable & scala.Serializable)plugins2 -> MODULE$.willAddPlugins(base, (List<AutoPlugin>)plugins2));
    }

    private String willAddPlugin(AutoPlugin base, AutoPlugin plugin) {
        return new StringBuilder(27).append("Enabling ").append(base.label()).append(" will also enable ").append(plugin.label()).toString();
    }

    private String willAddPlugins(AutoPlugin base, List<AutoPlugin> plugins2) {
        return new StringBuilder(29).append("Enabling ").append(base.label()).append(" will also enable:\n\t").append(this.labels(plugins2).mkString("\n\t")).toString();
    }

    private String willRemove(AutoPlugin base, List<AutoPlugin> plugins3) {
        return this.str(plugins3, (Function1 & Serializable & scala.Serializable)plugin -> MODULE$.willRemovePlugin(base, (AutoPlugin)plugin), (Function1 & Serializable & scala.Serializable)plugins2 -> MODULE$.willRemovePlugins(base, (List<AutoPlugin>)plugins2));
    }

    private String willRemovePlugin(AutoPlugin base, AutoPlugin plugin) {
        return new StringBuilder(23).append("Enabling ").append(base.label()).append(" will disable ").append(plugin.label()).toString();
    }

    private String willRemovePlugins(AutoPlugin base, List<AutoPlugin> plugins2) {
        return new StringBuilder(25).append("Enabling ").append(base.label()).append(" will disable:\n\t").append(this.labels(plugins2).mkString("\n\t")).toString();
    }

    private List<String> labels(List<AutoPlugin> plugins2) {
        return (List)plugins2.map((Function1 & Serializable & scala.Serializable)x$23 -> x$23.label(), List$.MODULE$.canBuildFrom());
    }

    private String needToDeactivate(List<PluginsDebug.DeactivatePlugin> deactivate2) {
        return this.str(deactivate2, (Function1 & Serializable & scala.Serializable)deactivate -> MODULE$.deactivate1((PluginsDebug.DeactivatePlugin)deactivate), (Function1 & Serializable & scala.Serializable)plugins2 -> MODULE$.deactivateN((List<PluginsDebug.DeactivatePlugin>)plugins2));
    }

    private String deactivateN(List<PluginsDebug.DeactivatePlugin> plugins2) {
        return ((TraversableOnce)plugins2.map((Function1 & Serializable & scala.Serializable)d -> MODULE$.deactivateString((PluginsDebug.DeactivatePlugin)d), List$.MODULE$.canBuildFrom())).mkString("These plugins need to be deactivated:\n\t", "\n\t", "");
    }

    private String deactivate1(PluginsDebug.DeactivatePlugin deactivate) {
        return new StringBuilder(19).append("Need to deactivate ").append(this.deactivateString(deactivate)).toString();
    }

    /*
     * Unable to fully structure code
     */
    private String deactivateString(PluginsDebug.DeactivatePlugin d) {
        block3: {
            block2: {
                var4_2 = d.removeOneOf().toList();
                if (!Nil$.MODULE$.equals(var4_2)) break block2;
                var2_3 = "";
                break block3;
            }
            if (!(var4_2 instanceof .colon.colon)) ** GOTO lbl-1000
            var5_4 = (.colon.colon)var4_2;
            x = (AutoPlugin)var5_4.head();
            var7_6 = var5_4.tl$access$1();
            if (Nil$.MODULE$.equals(var7_6)) {
                var2_3 = new StringBuilder(22).append(" or no longer include ").append(x).toString();
            } else lbl-1000:
            // 2 sources

            {
                var2_3 = new StringBuilder(18).append(" or remove one of ").append(var4_2.mkString(", ")).toString();
            }
        }
        removePluginsString = var2_3;
        return new StringBuilder(21).append(d.plugin().label()).append(": directly exclude it").append(removePluginsString).toString();
    }

    private String pluginImpossible(AutoPlugin plugin, Set<AutoPlugin> contradictions2) {
        return this.str(contradictions2.toList(), (Function1 & Serializable & scala.Serializable)contradiction -> MODULE$.pluginImpossible1(plugin, (AutoPlugin)contradiction), (Function1 & Serializable & scala.Serializable)contradictions -> MODULE$.pluginImpossibleN(plugin, (List<AutoPlugin>)contradictions));
    }

    private String pluginImpossible1(AutoPlugin plugin, AutoPlugin contradiction) {
        String s1 = new StringBuilder(34).append("There is no way to enable plugin ").append(plugin.label()).append(".").toString();
        String s2 = new StringBuilder(72).append("It (or its dependencies) requires plugin ").append(contradiction.label()).append(" to both be present and absent.").toString();
        String s3 = "Please report the problem to the plugin's author.";
        return new StringBuilder(4).append(s1).append("  ").append(s2).append("  ").append(s3).toString();
    }

    private String pluginImpossibleN(AutoPlugin plugin, List<AutoPlugin> contradictions) {
        String s1 = new StringBuilder(34).append("There is no way to enable plugin ").append(plugin.label()).append(".").toString();
        String s2 = "It (or its dependencies) requires these plugins to be both present and absent:";
        String s3 = "Please report the problem to the plugin's author.";
        return new StringBuilder(6).append(s1).append("  ").append(s2).append(":\n\t").append(this.labels(contradictions).mkString("\n\t")).append("\n").append(s3).toString();
    }

    public static final /* synthetic */ boolean $anonfun$helpAll$2(AutoPlugin plugin$1, ResolvedProject x$8) {
        return x$8.autoPlugins().contains((Object)plugin$1);
    }

    private final String helpBuild$1(URI uri, LoadedBuildUnit build) {
        Seq pluginStrings = (Seq)this.availableAutoPlugins(build).map((Function1 & Serializable & scala.Serializable)plugin -> {
            List activatedIn = (List)((List)build.projects().toList().filter((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)PluginsDebug$.$anonfun$helpAll$2(plugin, x$8)))).map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.id(), List$.MODULE$.canBuildFrom());
            String actString = activatedIn.nonEmpty() ? activatedIn.mkString(": enabled in ", ", ", "") : "";
            return new StringBuilder(2).append("\n\t").append(plugin.label()).append(actString).toString();
        }, Seq$.MODULE$.canBuildFrom());
        return new StringBuilder(3).append("In ").append(uri).append(pluginStrings.mkString()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$helpAll$4(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    private static final boolean definesPlugin$1(ResolvedProject p, AutoPlugin plugin$2) {
        return p.autoPlugins().contains((Object)plugin$2);
    }

    private static final ResolvedProject projectForRef$1(ProjectRef ref, Extracted extracted$1) {
        return (ResolvedProject)extracted$1.get((SettingKey)Keys$.MODULE$.thisProject().in((Reference)ref));
    }

    private static final /* synthetic */ PluginsDebug.Context context$lzycompute$1(LazyRef context$lzy$1, Extracted extracted$1, List pluginsThisBuild$1, State s$1) {
        PluginsDebug.Context context;
        LazyRef lazyRef = context$lzy$1;
        synchronized (lazyRef) {
            context = context$lzy$1.initialized() ? (PluginsDebug.Context)context$lzy$1.value() : (PluginsDebug.Context)context$lzy$1.initialize((Object)new PluginsDebug.Context(extracted$1.currentProject().plugins(), extracted$1.currentProject().autoPlugins(), Plugins$.MODULE$.deducer((List<AutoPlugin>)pluginsThisBuild$1), (List<AutoPlugin>)pluginsThisBuild$1, (Logger)State.StateOpsImpl$.MODULE$.log$extension(State$.MODULE$.StateOpsImpl(s$1))));
        }
        return context;
    }

    private static final PluginsDebug.Context context$2(LazyRef context$lzy$1, Extracted extracted$1, List pluginsThisBuild$1, State s$1) {
        return context$lzy$1.initialized() ? (PluginsDebug.Context)context$lzy$1.value() : PluginsDebug$.context$lzycompute$1(context$lzy$1, extracted$1, pluginsThisBuild$1, s$1);
    }

    private static final /* synthetic */ PluginsDebug debug$lzycompute$1(LazyRef debug$lzy$1, LazyRef context$lzy$1, Extracted extracted$1, List pluginsThisBuild$1, State s$1) {
        PluginsDebug pluginsDebug;
        LazyRef lazyRef = debug$lzy$1;
        synchronized (lazyRef) {
            pluginsDebug = debug$lzy$1.initialized() ? (PluginsDebug)debug$lzy$1.value() : (PluginsDebug)debug$lzy$1.initialize((Object)MODULE$.apply(PluginsDebug$.context$2(context$lzy$1, extracted$1, pluginsThisBuild$1, s$1).available()));
        }
        return pluginsDebug;
    }

    private static final PluginsDebug debug$1(LazyRef debug$lzy$1, LazyRef context$lzy$1, Extracted extracted$1, List pluginsThisBuild$1, State s$1) {
        return debug$lzy$1.initialized() ? (PluginsDebug)debug$lzy$1.value() : PluginsDebug$.debug$lzycompute$1(debug$lzy$1, context$lzy$1, extracted$1, pluginsThisBuild$1, s$1);
    }

    public static final /* synthetic */ boolean $anonfun$help$3(AutoPlugin plugin$2, Tuple2 x$12) {
        return ((GenSetLike)x$12._2()).apply((Object)plugin$2);
    }

    private static final String indent$1(String str) {
        return str.isEmpty() ? "" : new StringBuilder(1).append("\t").append(str).toString();
    }

    private static final String note$1(String str) {
        return str.isEmpty() ? "" : new StringBuilder(6).append("Note: ").append(str).toString();
    }

    private static final Seq extractDefinedKeys$1(Seq ss) {
        return (Seq)ss.map((Function1 & Serializable & scala.Serializable)x$21 -> x$21.key().key(), Seq$.MODULE$.canBuildFrom());
    }

    private static final Seq allSettings$1(AutoPlugin p) {
        return (Seq)((TraversableLike)p.projectSettings().$plus$plus(p.buildSettings(), Seq$.MODULE$.canBuildFrom())).$plus$plus(p.globalSettings(), Seq$.MODULE$.canBuildFrom());
    }

    private PluginsDebug$() {
        MODULE$ = this;
    }
}

