/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.diagram;

import java.util.LinkedList;
import net.sf.sdedit.diagram.Lifeline;
import net.sf.sdedit.diagram.MessageData;
import net.sf.sdedit.diagram.SequenceDiagram;
import net.sf.sdedit.diagram.SequenceDiagramDataProvider;
import net.sf.sdedit.error.ObjectNotFound;
import net.sf.sdedit.error.SemanticError;
import net.sf.sdedit.message.Answer;
import net.sf.sdedit.message.BroadcastMessage;
import net.sf.sdedit.message.ConstructorMessage;
import net.sf.sdedit.message.ForwardMessage;
import net.sf.sdedit.message.Message;
import net.sf.sdedit.message.MessageToSelf;
import net.sf.sdedit.message.NullMessage;
import net.sf.sdedit.message.Primitive;

final class MessageProcessor {
    private final SequenceDiagram diagram;
    private final SequenceDiagramDataProvider provider;
    private MessageData data;
    private Lifeline rootCaller;
    private Lifeline rootCallee;
    private int callerThread = 0;
    private int calleeThread = 0;
    private Lifeline caller;
    private Lifeline callee;
    private Answer answer;
    private boolean requireReturn;

    private boolean callerIsActor() {
        return this.rootCaller != null && this.rootCaller.isAlwaysActive();
    }

    private boolean calleeIsActor() {
        return this.rootCallee != null && this.rootCallee.isAlwaysActive();
    }

    private boolean isPrimitiveMessage() {
        return this.rootCallee == null;
    }

    MessageProcessor(SequenceDiagram diagram) {
        this.diagram = diagram;
        this.provider = diagram.getDataProvider();
        this.requireReturn = diagram.getConfiguration().isExplicitReturns();
    }

    ForwardMessage processMessage(MessageData theData, Lifeline precomputedCaller) throws SemanticError {
        this.data = theData;
        this.initMessage();
        theData.getBroadcastType();
        return this._processMessage(theData.getBroadcastType() < 2, precomputedCaller);
    }

    Lifeline processReturn(MessageData ret) throws SemanticError {
        this.data = ret;
        this.initMessage();
        if (this.diagram.isThreaded()) {
            this.findThreadNumbers();
            this.diagram.setCallerThread(this.callerThread);
        }
        return this.findCaller(true);
    }

    private ForwardMessage _processMessage(boolean openFragments, Lifeline precomputedCaller) throws SemanticError {
        this.checkSemantics();
        if (this.diagram.isThreaded()) {
            this.findThreadNumbers();
            this.diagram.setCallerThread(this.callerThread);
        } else {
            this.noThreadingChecks();
        }
        this.caller = precomputedCaller != null ? precomputedCaller : this.findCaller(false);
        this.callee = !this.isPrimitiveMessage() ? this.findCallee() : null;
        ForwardMessage message = this.getMessage();
        if (openFragments) {
            this.diagram.getFragmentManager().openFragments();
        }
        return message;
    }

    private void noThreadingChecks() throws SemanticError {
        if (this.data.isSpawnMessage()) {
            throw new SemanticError(this.provider, "Threads cannot be spawned when multithreading is not enabled.");
        }
        if (this.data.returnsInstantly()) {
            throw new SemanticError(this.provider, "Instant return must not be specified when multithreading is not enabled.");
        }
        if (this.data.getThread() != -1) {
            throw new SemanticError(this.provider, "A thread number must not be specified when multithreading is not enabled.");
        }
        if (this.data.getBroadcastType() != 0) {
            throw new SemanticError(this.provider, "Broadcast messages can only be sent when multithreading is enabled");
        }
    }

    private void checkSemantics() throws SemanticError {
        if (this.callerIsActor() && this.data.getCaller().equals(this.data.getCallee())) {
            throw new SemanticError(this.provider, "an actor cannot send a message to itself");
        }
        if (this.callerIsActor() && this.data.getAnswer().length() > 0) {
            throw new SemanticError(this.provider, "An actor cannot receive an answer automatically. This should be done by means of an explicit message!");
        }
        if (this.calleeIsActor() && this.data.getAnswer().length() > 0) {
            throw new SemanticError(this.provider, "There are no automatic answers to messages that reach actors.<br>This should be done by means of an explicit message!");
        }
        if (this.diagram.isThreaded() && this.data.isSpawnMessage() && this.data.getAnswer().length() > 0) {
            throw new SemanticError(this.provider, "There are no automatic answers to messages that spawn threads.<br>This should be done by means of an explicit message!");
        }
        if (this.rootCallee != null) {
            if (!this.rootCallee.isAlive() && !this.data.isNewMessage()) {
                throw new SemanticError(this.provider, this.data.getMessage() + ": " + this.data.getCallee() + " must be created first");
            }
            if (this.rootCallee.isAlive() && this.data.isNewMessage()) {
                throw new SemanticError(this.provider, this.data.getMessage() + ": " + this.data.getCallee() + " has already been created");
            }
        }
        if (this.diagram.isThreaded() && this.callerIsActor() && this.data.isSpawnMessage()) {
            throw new SemanticError(this.provider, "Actor messages are spawning by default in threaded mode");
        }
        if (this.diagram.isThreaded() && this.calleeIsActor() && this.data.getBroadcastType() == 0 && this.data.isSpawnMessage()) {
            throw new SemanticError(this.provider, "Messages sent to actors must not be spawning");
        }
    }

    private void initMessage() throws SemanticError {
        if (this.data.getCaller().equals("$")) {
            this.rootCaller = null;
        } else {
            this.rootCaller = this.diagram.getLifeline(this.data.getCaller());
            if (this.rootCaller == null) {
                throw new ObjectNotFound(this.provider, this.data.getCaller());
            }
        }
        if (!this.data.getCallee().equals("")) {
            this.rootCallee = this.diagram.getLifeline(this.data.getCallee());
            if (this.rootCallee == null) {
                throw new ObjectNotFound(this.provider, this.data.getCallee());
            }
        } else {
            this.rootCallee = null;
        }
    }

    private void findThreadNumbers() throws SemanticError {
        if (this.data.getCaller().equals("$")) {
            this.callerThread = -1;
            this.calleeThread = this.diagram.spawnThread();
            return;
        }
        if (this.callerIsActor() && (this.isPrimitiveMessage() || this.calleeIsActor())) {
            this.callerThread = -1;
            this.calleeThread = -1;
            return;
        }
        if (this.callerIsActor()) {
            this.callerThread = -1;
            if (!this.data.returnsInstantly()) {
                this.calleeThread = this.diagram.spawnThread();
            }
            return;
        }
        if (this.diagram.noThreadIsSpawned()) {
            this.callerThread = this.diagram.spawnThread();
        } else if (this.data.getThread() >= 0) {
            if (this.data.getThread() >= this.diagram.getNumberOfThreads()) {
                throw new SemanticError(this.provider, "Illegal thread number: " + this.data.getThread());
            }
            this.callerThread = this.data.getThread();
        } else {
            int uniqueThread = this.rootCaller.getUniqueThread();
            if (uniqueThread >= 0) {
                this.callerThread = uniqueThread;
            } else {
                if (this.calleeThread == -1) {
                    throw new SemanticError(this.provider, "Explicit thread number required.");
                }
                this.callerThread = this.calleeThread;
            }
        }
        boolean spawning = this.data.isSpawnMessage();
        if (spawning && this.data.getBroadcastType() > 0) {
            spawning = !this.calleeIsActor();
        }
        this.calleeThread = spawning && !this.data.returnsInstantly() ? this.diagram.spawnThread() : this.callerThread;
    }

    private Lifeline findCaller(boolean dropOneAnswer) throws SemanticError {
        if (this.rootCaller == null) {
            return null;
        }
        String callerName = this.data.getCaller();
        if (this.callerIsActor()) {
            if (!this.diagram.isThreaded()) {
                this.diagram.finish();
            }
            return this.rootCaller;
        }
        LinkedList<Message> currentStack = this.diagram.currentStack();
        if (currentStack == null) {
            throw new SemanticError(this.provider, "Thread " + this.callerThread + " has died");
        }
        if (this.callerThread == 0 && currentStack.isEmpty() && this.diagram.firstCaller() == null) {
            this.diagram.setFirstCaller(this.rootCaller);
            this.rootCaller.setActive(true);
            return this.rootCaller;
        }
        int occured = 0;
        while (!currentStack.isEmpty()) {
            Message theAnswer = currentStack.getLast();
            if (dropOneAnswer) {
                if (theAnswer.isSynchronous() && theAnswer.getCallee().getName().equals(this.data.getCaller())) {
                    this.diagram.sendAnswer(theAnswer, true);
                    return theAnswer.getCallee();
                }
                throw new SemanticError(this.provider, this.data.getCaller() + " cannot receive an answer here.");
            }
            if (theAnswer.getCaller().getName().equals(this.data.getCaller())) {
                if (occured == this.data.getLevel()) {
                    return theAnswer.getCaller();
                }
                ++occured;
            }
            currentStack.removeLast();
            if (this.requireReturn) {
                throw new SemanticError(this.provider, "Explicit answer required.");
            }
            this.diagram.sendAnswer(theAnswer);
        }
        if (this.diagram.firstCaller() != null && this.diagram.firstCaller().getName().equals(callerName)) {
            if (occured == this.data.getLevel()) {
                return this.diagram.firstCaller();
            }
            ++occured;
        }
        throw this.objectNotFound(occured);
    }

    private SemanticError objectNotFound(int occured) {
        String msg = occured == 0 ? this.data.getCaller() + " is not active at all" : (occured == 1 ? this.data.getCaller() + "[" + this.data.getLevel() + "]" + "is not active, but " + this.data.getCaller() + "[0] is" : this.data.getCaller() + "[" + this.data.getLevel() + "]" + "is not active, but " + this.data.getCaller() + "[0]" + (occured == 2 ? ", " : " - ") + this.data.getCaller() + "[" + (occured - 1) + "] are");
        return new SemanticError(this.provider, msg);
    }

    private Lifeline findCallee() throws SemanticError {
        if (this.calleeIsActor()) {
            return this.rootCallee;
        }
        Lifeline theCallee = this.rootCallee.getLastInThread(this.calleeThread);
        if (theCallee == null) {
            theCallee = this.rootCallee;
        }
        if (!this.data.returnsInstantly() || !this.callerIsActor() && !this.data.isSpawnMessage()) {
            if (!theCallee.isAlive() && this.data.isNewMessage()) {
                theCallee.setThread(this.calleeThread);
            } else if (theCallee.isActive()) {
                theCallee = theCallee.addActivity(this.caller, this.calleeThread);
            } else {
                theCallee.setThread(this.calleeThread);
            }
        }
        return theCallee;
    }

    private ForwardMessage getMessage() throws SemanticError {
        if (this.rootCaller == null) {
            if (!this.data.isSpawnMessage()) {
                throw new SemanticError(this.provider, "messages from caller $ must be spawning");
            }
            if (this.callee == null) {
                throw new SemanticError(this.provider, "messages from caller $ must have a callee");
            }
            return new NullMessage(this.callee, this.diagram, this.data);
        }
        if (this.rootCallee != null && this.rootCallee.isDestroyed()) {
            throw new SemanticError(this.provider, this.rootCallee.getName() + " has already been destroyed");
        }
        if (this.data.isDestroyMessage() && this.rootCallee != null) {
            if (this.rootCallee.isActive()) {
                throw new SemanticError(this.provider, "cannot destroy active object");
            }
            this.rootCallee.setDestroyed(true);
        }
        if (this.isPrimitiveMessage()) {
            return new Primitive(this.caller, this.diagram, this.data);
        }
        if (this.data.getBroadcastType() != 0) {
            return new BroadcastMessage(this.caller, this.callee, this.diagram, this.data);
        }
        if (!this.callee.isAlive() && this.data.isNewMessage()) {
            return new ConstructorMessage(this.caller, this.callee, this.diagram, this.data);
        }
        if (this.caller.getName().equals(this.callee.getName())) {
            return new MessageToSelf(this.caller, this.callee, this.diagram, this.data);
        }
        return new ForwardMessage(this.caller, this.callee, this.diagram, this.data);
    }

    void execute(ForwardMessage message) throws SemanticError {
        int dnum;
        if (message instanceof Primitive && this.diagram.isThreaded() && message.getText().equals("stop") && !this.caller.isAlwaysActive()) {
            this.diagram.finish(this.diagram.getCallerThread());
            this.diagram.setThreadState("dead");
            this.caller.finish();
            this.diagram.deleteStack();
            return;
        }
        message.executeMessage();
        if (this.provider.getState() != null) {
            this.diagram.addToStateMap(message.getArrow(), this.provider.getState());
        }
        this.answer = message.getAnswerMessage();
        this.diagram.setCallerThread(this.calleeThread);
        if (this.diagram.isThreaded() && !this.calleeIsActor() && !this.data.returnsInstantly() && !(message instanceof Primitive) && (this.data.isSpawnMessage() || this.caller.isAlwaysActive())) {
            this.diagram.setFirstCaller(this.callee);
            this.diagram.setThreadState("running");
        }
        if (this.answer != null) {
            if (this.data.returnsInstantly()) {
                this.diagram.sendAnswer(this.answer);
            } else {
                this.diagram.currentStack().add(this.answer);
            }
        }
        if ((dnum = this.data.getNoteNumber()) > 0) {
            this.diagram.associateMessage(dnum, message);
        }
        if ((dnum = this.data.getAnswerNoteNumber()) > 0) {
            if (this.answer == null) {
                throw new SemanticError(this.provider, "You cannot associate a note to an answer when there is none.");
            }
            this.diagram.associateMessage(dnum, this.answer);
        }
    }
}

