/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.help;

import java.awt.BorderLayout;
import java.awt.Component;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import net.sf.sdedit.editor.plugin.FileHandler;
import net.sf.sdedit.help.HelpTabFactory;
import net.sf.sdedit.icons.Icons;
import net.sf.sdedit.ui.Tab;
import net.sf.sdedit.ui.components.AdvancedHelpPanel;
import net.sf.sdedit.ui.components.HelpPanel;
import net.sf.sdedit.ui.components.Zoomable;
import net.sf.sdedit.ui.components.buttons.Activator;
import net.sf.sdedit.ui.impl.UserInterfaceImpl;
import net.sf.sdedit.util.Pair;
import net.sf.sdedit.util.Utilities;

public class HelpTab
extends Tab {
    private static Map<String, HelpTab> tabs = new HashMap<String, HelpTab>();
    private static List<HelpTabFactory> factories = new LinkedList<HelpTabFactory>();
    private String title;

    public static void addHelpTabFactory(HelpTabFactory factory) {
        factories.add(factory);
    }

    public static HelpTab getHelpTab(UserInterfaceImpl ui, String resource, boolean advanced) {
        HelpTab tab = tabs.get(resource);
        if (tab == null) {
            for (HelpTabFactory factory : factories) {
                JComponent comp = factory.getHelpTabComponent(ui, resource, advanced);
                if (comp == null) continue;
                String title = resource;
                int slash = resource.lastIndexOf(47);
                if (slash > 0) {
                    title = resource.substring(slash + 1);
                }
                tab = new HelpTab(ui, title, comp);
                tabs.put(resource, tab);
                break;
            }
        }
        return tab;
    }

    private HelpTab(UserInterfaceImpl ui, String title, JComponent comp) {
        super(ui);
        this.title = title;
        this.getContentPanel().setLayout(new BorderLayout());
        this.getContentPanel().add((Component)comp, "Center");
    }

    public boolean equals(Object o) {
        if (HelpTab.class.isInstance(o)) {
            return ((HelpTab)HelpTab.class.cast((Object)o)).title.equals(this.title);
        }
        return false;
    }

    public int hashCode() {
        return this.title.hashCode();
    }

    @Override
    public Icon getIcon() {
        return Icons.getIcon("help");
    }

    @Override
    public FileHandler getFileHandler() {
        return null;
    }

    @Override
    protected List<Pair<Action, Activator>> getOverloadedActions() {
        return null;
    }

    @Override
    protected Zoomable<? extends JComponent> getZoomable() {
        return null;
    }

    @Override
    protected void _getContextActions(List<Action> actionList) {
    }

    @Override
    public boolean canClose() {
        return true;
    }

    @Override
    public boolean canGoHome() {
        return false;
    }

    @Override
    public String getCategory() {
        return "Help pages";
    }

    static {
        factories.add(new HelpTabFactoryImpl());
    }

    public static class HelpTabFactoryImpl
    implements HelpTabFactory {
        @Override
        public JComponent getHelpTabComponent(UserInterfaceImpl ui, String file, boolean advanced) {
            URL helpURL = Utilities.getResource(file + ".html");
            if (helpURL != null) {
                if (advanced) {
                    return new AdvancedHelpPanel(helpURL, ui);
                }
                return new JScrollPane(new HelpPanel(helpURL, ui).getPane());
            }
            return null;
        }
    }
}

