/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.util;

import java.awt.Font;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import net.sf.sdedit.util.Utilities;

public final class ObjectFactory {
    private static final Map<Class<?>, Constructor<?>> stringConstructorMap = new HashMap();

    private ObjectFactory() {
    }

    public static Object createFromString(Class<?> cls, String string) {
        if (cls == String.class) {
            return string == null ? "" : string;
        }
        if (cls == Integer.TYPE && string.length() == 1) {
            return string.charAt(0) - 48;
        }
        if (cls == Font.class) {
            return Font.decode(string);
        }
        Class<?> nonPrimitive = Utilities.getWrapperClass(cls);
        if (nonPrimitive != null) {
            cls = nonPrimitive;
        }
        try {
            if (string == null) {
                return cls.newInstance();
            }
            Constructor<?> constructor = stringConstructorMap.get(cls);
            if (constructor == null) {
                try {
                    constructor = cls.getConstructor(String.class);
                }
                catch (NoSuchMethodException e) {
                    constructor = cls.getConstructor(Integer.TYPE);
                }
                stringConstructorMap.put(cls, constructor);
            }
            if (constructor.getParameterTypes()[0] == Integer.TYPE) {
                return constructor.newInstance(Integer.parseInt(string));
            }
            return constructor.newInstance(string);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(cls.getName() + " has no" + " constructor with a single string or integer as a parameter");
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException(cls.getName() + " has no" + " constructor with an empty parameter list");
        }
        catch (Throwable e) {
            throw new IllegalArgumentException(cls.getName() + " has a" + " constructor with a single string or integer as a parameter, but" + " it cannot be invoked with the argument \"" + string + "\", which led to an exception/error of type " + e.getClass().getSimpleName() + " with the message: " + e.getMessage());
        }
    }
}

