/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.index.BufferedUpdates;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.Term;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;

abstract class DocValuesUpdate {
    private static final int RAW_SIZE_IN_BYTES = 8 * RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + 8 * RamUsageEstimator.NUM_BYTES_OBJECT_REF + 32;
    final DocValuesType type;
    final Term term;
    final String field;
    final int docIDUpto;
    final boolean hasValue;

    protected DocValuesUpdate(DocValuesType type, Term term, String field, int docIDUpto, boolean hasValue) {
        assert (docIDUpto >= 0) : docIDUpto + "must be >= 0";
        this.type = type;
        this.term = term;
        this.field = field;
        this.docIDUpto = docIDUpto;
        this.hasValue = hasValue;
    }

    abstract long valueSizeInBytes();

    final int sizeInBytes() {
        int sizeInBytes = RAW_SIZE_IN_BYTES;
        sizeInBytes += this.term.field.length() * 2;
        sizeInBytes += this.term.bytes.bytes.length;
        sizeInBytes += this.field.length() * 2;
        sizeInBytes = (int)((long)sizeInBytes + this.valueSizeInBytes());
        return ++sizeInBytes;
    }

    protected abstract String valueToString();

    abstract void writeTo(DataOutput var1) throws IOException;

    boolean hasValue() {
        return this.hasValue;
    }

    public String toString() {
        return "term=" + this.term + ",field=" + this.field + ",value=" + this.valueToString() + ",docIDUpto=" + this.docIDUpto;
    }

    static final class NumericDocValuesUpdate
    extends DocValuesUpdate {
        private final long value;

        NumericDocValuesUpdate(Term term, String field, long value) {
            this(term, field, value, (int)BufferedUpdates.MAX_INT, true);
        }

        NumericDocValuesUpdate(Term term, String field, Long value) {
            this(term, field, value != null ? value : -1L, (int)BufferedUpdates.MAX_INT, value != null);
        }

        private NumericDocValuesUpdate(Term term, String field, long value, int docIDUpTo, boolean hasValue) {
            super(DocValuesType.NUMERIC, term, field, docIDUpTo, hasValue);
            this.value = value;
        }

        NumericDocValuesUpdate prepareForApply(int docIDUpto) {
            if (docIDUpto == this.docIDUpto) {
                return this;
            }
            return new NumericDocValuesUpdate(this.term, this.field, this.value, docIDUpto, this.hasValue);
        }

        @Override
        long valueSizeInBytes() {
            return 8L;
        }

        @Override
        protected String valueToString() {
            return this.hasValue ? Long.toString(this.value) : "null";
        }

        @Override
        void writeTo(DataOutput out) throws IOException {
            assert (this.hasValue);
            out.writeZLong(this.value);
        }

        static long readFrom(DataInput in) throws IOException {
            return in.readZLong();
        }

        long getValue() {
            assert (this.hasValue) : "getValue should only be called if this update has a value";
            return this.value;
        }
    }

    static final class BinaryDocValuesUpdate
    extends DocValuesUpdate {
        private final BytesRef value;
        private static final long RAW_VALUE_SIZE_IN_BYTES = RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + 8 + RamUsageEstimator.NUM_BYTES_OBJECT_REF;

        BinaryDocValuesUpdate(Term term, String field, BytesRef value) {
            this(term, field, value, BufferedUpdates.MAX_INT);
        }

        private BinaryDocValuesUpdate(Term term, String field, BytesRef value, int docIDUpTo) {
            super(DocValuesType.BINARY, term, field, docIDUpTo, value != null);
            this.value = value;
        }

        BinaryDocValuesUpdate prepareForApply(int docIDUpto) {
            if (docIDUpto == this.docIDUpto) {
                return this;
            }
            return new BinaryDocValuesUpdate(this.term, this.field, this.value, docIDUpto);
        }

        @Override
        long valueSizeInBytes() {
            return RAW_VALUE_SIZE_IN_BYTES + (long)(this.value == null ? 0 : this.value.bytes.length);
        }

        @Override
        protected String valueToString() {
            return this.value.toString();
        }

        BytesRef getValue() {
            assert (this.hasValue) : "getValue should only be called if this update has a value";
            return this.value;
        }

        @Override
        void writeTo(DataOutput out) throws IOException {
            assert (this.hasValue);
            out.writeVInt(this.value.length);
            out.writeBytes(this.value.bytes, this.value.offset, this.value.length);
        }

        static BytesRef readFrom(DataInput in, BytesRef scratch) throws IOException {
            scratch.length = in.readVInt();
            if (scratch.bytes.length < scratch.length) {
                scratch.bytes = ArrayUtil.grow(scratch.bytes, scratch.length);
            }
            in.readBytes(scratch.bytes, 0, scratch.length);
            return scratch;
        }
    }
}

