/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.compress;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.util.FutureArrays;
import org.apache.lucene.util.FutureObjects;
import org.apache.lucene.util.packed.PackedInts;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class LZ4 {
    static final int MEMORY_USAGE = 14;
    static final int MIN_MATCH = 4;
    static final int MAX_DISTANCE = 65536;
    static final int LAST_LITERALS = 5;
    static final int HASH_LOG_HC = 15;
    static final int HASH_TABLE_SIZE_HC = 32768;
    static final int OPTIMAL_ML = 18;

    private LZ4() {
    }

    private static int hash(int i, int hashBits) {
        return i * -1640531535 >>> 32 - hashBits;
    }

    private static int hashHC(int i) {
        return LZ4.hash(i, 15);
    }

    private static int readInt(byte[] buf, int i) {
        return (buf[i] & 0xFF) << 24 | (buf[i + 1] & 0xFF) << 16 | (buf[i + 2] & 0xFF) << 8 | buf[i + 3] & 0xFF;
    }

    private static int commonBytes(byte[] b, int o1, int o2, int limit) {
        assert (o1 < o2);
        return FutureArrays.mismatch(b, o1, limit, b, o2, limit);
    }

    public static int decompress(DataInput compressed, int decompressedLen, byte[] dest) throws IOException {
        int dOff = 0;
        int destEnd = dest.length;
        do {
            int token;
            int literalLen;
            if ((literalLen = (token = compressed.readByte() & 0xFF) >>> 4) != 0) {
                if (literalLen == 15) {
                    byte len;
                    while ((len = compressed.readByte()) == -1) {
                        literalLen += 255;
                    }
                    literalLen += len & 0xFF;
                }
                compressed.readBytes(dest, dOff, literalLen);
                dOff += literalLen;
            }
            if (dOff >= decompressedLen) break;
            int matchDec = compressed.readByte() & 0xFF | (compressed.readByte() & 0xFF) << 8;
            assert (matchDec > 0);
            int matchLen = token & 0xF;
            if (matchLen == 15) {
                byte len;
                while ((len = compressed.readByte()) == -1) {
                    matchLen += 255;
                }
                matchLen += len & 0xFF;
            }
            int fastLen = (matchLen += 4) + 7 & 0xFFFFFFF8;
            if (matchDec < matchLen || dOff + fastLen > destEnd) {
                int ref = dOff - matchDec;
                int end = dOff + matchLen;
                while (dOff < end) {
                    dest[dOff] = dest[ref];
                    ++ref;
                    ++dOff;
                }
            } else {
                System.arraycopy(dest, dOff - matchDec, dest, dOff, fastLen);
                dOff += matchLen;
            }
        } while (dOff < decompressedLen);
        return dOff;
    }

    private static void encodeLen(int l, DataOutput out) throws IOException {
        while (l >= 255) {
            out.writeByte((byte)-1);
            l -= 255;
        }
        out.writeByte((byte)l);
    }

    private static void encodeLiterals(byte[] bytes, int token, int anchor, int literalLen, DataOutput out) throws IOException {
        out.writeByte((byte)token);
        if (literalLen >= 15) {
            LZ4.encodeLen(literalLen - 15, out);
        }
        out.writeBytes(bytes, anchor, literalLen);
    }

    private static void encodeLastLiterals(byte[] bytes, int anchor, int literalLen, DataOutput out) throws IOException {
        int token = Math.min(literalLen, 15) << 4;
        LZ4.encodeLiterals(bytes, token, anchor, literalLen, out);
    }

    private static void encodeSequence(byte[] bytes, int anchor, int matchRef, int matchOff, int matchLen, DataOutput out) throws IOException {
        int literalLen = matchOff - anchor;
        assert (matchLen >= 4);
        int token = Math.min(literalLen, 15) << 4 | Math.min(matchLen - 4, 15);
        LZ4.encodeLiterals(bytes, token, anchor, literalLen, out);
        int matchDec = matchOff - matchRef;
        assert (matchDec > 0 && matchDec < 65536);
        out.writeByte((byte)matchDec);
        out.writeByte((byte)(matchDec >>> 8));
        if (matchLen >= 19) {
            LZ4.encodeLen(matchLen - 15 - 4, out);
        }
    }

    public static void compress(byte[] bytes, int off, int len, DataOutput out, HashTable ht) throws IOException {
        FutureObjects.checkFromIndexSize(off, len, bytes.length);
        int base = off;
        int end = off + len;
        int anchor = off++;
        if (len > 9) {
            int limit = end - 5;
            int matchLimit = limit - 4;
            ht.reset(bytes, base, len);
            block0: while (off <= limit) {
                while (off < matchLimit) {
                    int ref = ht.get(off);
                    if (ref != -1) {
                        assert (ref >= base && ref < off);
                        assert (LZ4.readInt(bytes, ref) == LZ4.readInt(bytes, off));
                    } else {
                        ++off;
                        continue;
                    }
                    int matchLen = 4 + LZ4.commonBytes(bytes, ref + 4, off + 4, limit);
                    int r = ht.previous(ref);
                    int min = Math.max(off - 65536 + 1, base);
                    while (r >= min) {
                        assert (LZ4.readInt(bytes, r) == LZ4.readInt(bytes, off));
                        int rMatchLen = 4 + LZ4.commonBytes(bytes, r + 4, off + 4, limit);
                        if (rMatchLen > matchLen) {
                            ref = r;
                            matchLen = rMatchLen;
                        }
                        r = ht.previous(r);
                    }
                    LZ4.encodeSequence(bytes, anchor, ref, off, matchLen, out);
                    anchor = off += matchLen;
                    continue block0;
                }
                break block0;
            }
        }
        int literalLen = end - anchor;
        assert (literalLen >= 5 || literalLen == len);
        LZ4.encodeLastLiterals(bytes, anchor, end - anchor, out);
    }

    static abstract class HashTable {
        HashTable() {
        }

        abstract void reset(byte[] var1, int var2, int var3);

        abstract int get(int var1);

        abstract int previous(int var1);

        abstract boolean assertReset();
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static final class HighCompressionHashTable
    extends HashTable {
        private static final int MAX_ATTEMPTS = 256;
        private static final int MASK = 65535;
        private byte[] bytes;
        private int base;
        private int next;
        private int end;
        private final int[] hashTable = new int[32768];
        private final short[] chainTable;
        private int attempts = 0;

        public HighCompressionHashTable() {
            Arrays.fill(this.hashTable, -1);
            this.chainTable = new short[65536];
            Arrays.fill(this.chainTable, (short)-1);
        }

        @Override
        void reset(byte[] bytes, int off, int len) {
            FutureObjects.checkFromIndexSize(off, len, bytes.length);
            if (this.end - this.base < this.chainTable.length) {
                int endOffset;
                int startOffset = this.base & 0xFFFF;
                int n = endOffset = this.end == 0 ? 0 : (this.end - 1 & 0xFFFF) + 1;
                if (startOffset < endOffset) {
                    Arrays.fill(this.chainTable, startOffset, endOffset, (short)-1);
                } else {
                    Arrays.fill(this.chainTable, 0, endOffset, (short)-1);
                    Arrays.fill(this.chainTable, startOffset, this.chainTable.length, (short)-1);
                }
            } else {
                Arrays.fill(this.hashTable, -1);
                Arrays.fill(this.chainTable, (short)-1);
            }
            this.bytes = bytes;
            this.base = off;
            this.next = off;
            this.end = off + len;
        }

        @Override
        int get(int off) {
            assert (off > this.next);
            assert (off < this.end);
            while (this.next < off) {
                this.addHash(this.next);
                ++this.next;
            }
            int v = LZ4.readInt(this.bytes, off);
            int h = LZ4.hashHC(v);
            this.attempts = 0;
            int ref = this.hashTable[h];
            if (ref >= off) {
                return -1;
            }
            int min = Math.max(this.base, off - 65536 + 1);
            while (ref >= min && this.attempts < 256) {
                if (LZ4.readInt(this.bytes, ref) == v) {
                    return ref;
                }
                ref -= this.chainTable[ref & 0xFFFF] & 0xFFFF;
                ++this.attempts;
            }
            return -1;
        }

        private void addHash(int off) {
            int v = LZ4.readInt(this.bytes, off);
            int h = LZ4.hashHC(v);
            int delta = off - this.hashTable[h];
            if (delta <= 0 || delta >= 65536) {
                delta = 65535;
            }
            this.chainTable[off & 0xFFFF] = (short)delta;
            this.hashTable[h] = off;
        }

        @Override
        int previous(int off) {
            int v = LZ4.readInt(this.bytes, off);
            int ref = off - (this.chainTable[off & 0xFFFF] & 0xFFFF);
            while (ref >= this.base && this.attempts < 256) {
                if (LZ4.readInt(this.bytes, ref) == v) {
                    return ref;
                }
                ref -= this.chainTable[ref & 0xFFFF] & 0xFFFF;
                ++this.attempts;
            }
            return -1;
        }

        @Override
        boolean assertReset() {
            for (int i = 0; i < this.chainTable.length; ++i) {
                assert (this.chainTable[i] == -1) : i;
            }
            return true;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static final class FastCompressionHashTable
    extends HashTable {
        private byte[] bytes;
        private int base;
        private int lastOff;
        private int end;
        private int hashLog;
        private PackedInts.Mutable hashTable;

        @Override
        void reset(byte[] bytes, int off, int len) {
            FutureObjects.checkFromIndexSize(off, len, bytes.length);
            this.bytes = bytes;
            this.base = off;
            this.lastOff = off - 1;
            this.end = off + len;
            int bitsPerOffset = PackedInts.bitsRequired(len - 5);
            int bitsPerOffsetLog = 32 - Integer.numberOfLeadingZeros(bitsPerOffset - 1);
            this.hashLog = 17 - bitsPerOffsetLog;
            if (this.hashTable == null || this.hashTable.size() < 1 << this.hashLog || this.hashTable.getBitsPerValue() < bitsPerOffset) {
                this.hashTable = PackedInts.getMutable(1 << this.hashLog, bitsPerOffset, 0.25f);
            } else {
                this.get(off);
            }
        }

        @Override
        int get(int off) {
            assert (off > this.lastOff);
            assert (off < this.end);
            int v = LZ4.readInt(this.bytes, off);
            int h = LZ4.hash(v, this.hashLog);
            int ref = this.base + (int)this.hashTable.get(h);
            this.hashTable.set(h, off - this.base);
            this.lastOff = off;
            if (ref < off && off - ref < 65536 && LZ4.readInt(this.bytes, ref) == v) {
                return ref;
            }
            return -1;
        }

        @Override
        public int previous(int off) {
            return -1;
        }

        @Override
        boolean assertReset() {
            return true;
        }
    }
}

