/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.stream;

import java.util.HashMap;
import java.util.Locale;
import org.apache.james.mime4j.MimeException;
import org.apache.james.mime4j.codec.DecodeMonitor;
import org.apache.james.mime4j.stream.BasicBodyDescriptor;
import org.apache.james.mime4j.stream.BodyDescriptor;
import org.apache.james.mime4j.stream.BodyDescriptorBuilder;
import org.apache.james.mime4j.stream.Field;
import org.apache.james.mime4j.stream.NameValuePair;
import org.apache.james.mime4j.stream.RawBody;
import org.apache.james.mime4j.stream.RawField;
import org.apache.james.mime4j.stream.RawFieldParser;
import org.apache.james.mime4j.util.MimeUtil;

class FallbackBodyDescriptorBuilder
implements BodyDescriptorBuilder {
    private static final String US_ASCII = "us-ascii";
    private static final String SUB_TYPE_EMAIL = "rfc822";
    private static final String MEDIA_TYPE_TEXT = "text";
    private static final String MEDIA_TYPE_MESSAGE = "message";
    private static final String EMAIL_MESSAGE_MIME_TYPE = "message/rfc822";
    private static final String DEFAULT_SUB_TYPE = "plain";
    private static final String DEFAULT_MEDIA_TYPE = "text";
    private static final String DEFAULT_MIME_TYPE = "text/plain";
    private final String parentMimeType;
    private final DecodeMonitor monitor;
    private String mediaType;
    private String subType;
    private String mimeType;
    private String boundary;
    private String charset;
    private String transferEncoding;
    private long contentLength;

    public FallbackBodyDescriptorBuilder() {
        this(null, null);
    }

    public FallbackBodyDescriptorBuilder(String parentMimeType, DecodeMonitor monitor) {
        this.parentMimeType = parentMimeType;
        this.monitor = monitor != null ? monitor : DecodeMonitor.SILENT;
        this.reset();
    }

    public void reset() {
        this.mimeType = null;
        this.subType = null;
        this.mediaType = null;
        this.boundary = null;
        this.charset = null;
        this.transferEncoding = null;
        this.contentLength = -1L;
    }

    public BodyDescriptorBuilder newChild() {
        return new FallbackBodyDescriptorBuilder(this.mimeType, this.monitor);
    }

    public BodyDescriptor build() {
        String actualMimeType = this.mimeType;
        String actualMediaType = this.mediaType;
        String actualSubType = this.subType;
        String actualCharset = this.charset;
        if (actualMimeType == null) {
            if (MimeUtil.isSameMimeType("multipart/digest", this.parentMimeType)) {
                actualMimeType = EMAIL_MESSAGE_MIME_TYPE;
                actualMediaType = MEDIA_TYPE_MESSAGE;
                actualSubType = SUB_TYPE_EMAIL;
            } else {
                actualMimeType = DEFAULT_MIME_TYPE;
                actualMediaType = "text";
                actualSubType = DEFAULT_SUB_TYPE;
            }
        }
        if (actualCharset == null && "text".equals(actualMediaType)) {
            actualCharset = US_ASCII;
        }
        return new BasicBodyDescriptor(actualMimeType, actualMediaType, actualSubType, this.boundary, actualCharset, this.transferEncoding != null ? this.transferEncoding : "7bit", this.contentLength);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Field addField(RawField field) throws MimeException {
        String name = field.getName().toLowerCase(Locale.US);
        if (name.equals("content-transfer-encoding") && this.transferEncoding == null) {
            String value = field.getBody();
            if (value == null || (value = value.trim().toLowerCase(Locale.US)).length() <= 0) return null;
            this.transferEncoding = value;
            return null;
        } else if (name.equals("content-length") && this.contentLength == -1L) {
            String value = field.getBody();
            if (value == null) return null;
            value = value.trim();
            try {
                this.contentLength = Long.parseLong(value.trim());
                return null;
            }
            catch (NumberFormatException e) {
                if (!this.monitor.warn("Invalid content length: " + value, "ignoring Content-Length header")) return null;
                throw new MimeException("Invalid Content-Length header: " + value);
            }
        } else {
            if (!name.equals("content-type") || this.mimeType != null) return null;
            this.parseContentType(field);
        }
        return null;
    }

    private void parseContentType(Field field) throws MimeException {
        boolean multipart;
        RawField rawfield = field instanceof RawField ? (RawField)field : new RawField(field.getName(), field.getBody());
        RawBody body = RawFieldParser.DEFAULT.parseRawBody(rawfield);
        String main = body.getValue();
        HashMap<String, String> params = new HashMap<String, String>();
        for (NameValuePair nmp : body.getParams()) {
            String name = nmp.getName().toLowerCase(Locale.US);
            params.put(name, nmp.getValue());
        }
        String type = null;
        String subtype = null;
        if (main != null) {
            main = main.toLowerCase().trim();
            int index = main.indexOf(47);
            boolean valid = false;
            if (index != -1) {
                type = main.substring(0, index).trim();
                subtype = main.substring(index + 1).trim();
                if (type.length() > 0 && subtype.length() > 0) {
                    main = type + "/" + subtype;
                    valid = true;
                }
            }
            if (!valid) {
                main = null;
                type = null;
                subtype = null;
            }
        }
        String b = (String)params.get("boundary");
        boolean bl = multipart = main != null && main.startsWith("multipart/");
        if (multipart && b != null || !multipart) {
            this.mimeType = main;
            this.mediaType = type;
            this.subType = subtype;
        }
        if (MimeUtil.isMultipart(this.mimeType)) {
            this.boundary = b;
        }
        String c = (String)params.get("charset");
        this.charset = null;
        if (c != null && (c = c.trim()).length() > 0) {
            this.charset = c;
        }
    }
}

