/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoTypeReader;
import com.coremedia.iso.IsoTypeWriter;
import com.coremedia.iso.boxes.FullBox;
import com.coremedia.iso.boxes.sampleentry.AbstractSampleEntry;
import com.googlecode.mp4parser.AbstractContainerBox;
import com.googlecode.mp4parser.DataSource;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.Iterator;

public class SampleDescriptionBox
extends AbstractContainerBox
implements FullBox {
    public static final String TYPE = "stsd";
    private int version;
    private int flags;

    public SampleDescriptionBox() {
        super(TYPE);
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public void parse(DataSource dataSource, ByteBuffer header, long contentSize, BoxParser boxParser) throws IOException {
        ByteBuffer versionFlagNumOfChildBoxes = ByteBuffer.allocate(8);
        dataSource.read(versionFlagNumOfChildBoxes);
        versionFlagNumOfChildBoxes.rewind();
        this.version = IsoTypeReader.readUInt8(versionFlagNumOfChildBoxes);
        this.flags = IsoTypeReader.readUInt24(versionFlagNumOfChildBoxes);
        this.initContainer(dataSource, contentSize - 8L, boxParser);
    }

    public void getBox(WritableByteChannel writableByteChannel) throws IOException {
        writableByteChannel.write(this.getHeader());
        ByteBuffer versionFlagNumOfChildBoxes = ByteBuffer.allocate(8);
        IsoTypeWriter.writeUInt8(versionFlagNumOfChildBoxes, this.version);
        IsoTypeWriter.writeUInt24(versionFlagNumOfChildBoxes, this.flags);
        IsoTypeWriter.writeUInt32(versionFlagNumOfChildBoxes, this.getBoxes().size());
        writableByteChannel.write((ByteBuffer)versionFlagNumOfChildBoxes.rewind());
        this.writeContainer(writableByteChannel);
    }

    public AbstractSampleEntry getSampleEntry() {
        Iterator<AbstractSampleEntry> iterator = this.getBoxes(AbstractSampleEntry.class).iterator();
        if (iterator.hasNext()) {
            AbstractSampleEntry box = iterator.next();
            return box;
        }
        return null;
    }

    public long getSize() {
        long s = this.getContainerSize();
        long t = 8L;
        return s + t + (long)(this.largeBox || s + t + 8L >= 0x100000000L ? 16 : 8);
    }
}

