/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.Container;
import com.googlecode.mp4parser.AbstractBox;
import com.googlecode.mp4parser.DataSource;
import com.googlecode.mp4parser.util.CastUtils;
import com.googlecode.mp4parser.util.LazyList;
import com.googlecode.mp4parser.util.Logger;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicContainer
implements Container,
Iterator<Box>,
Closeable {
    private static final Box EOF = new AbstractBox("eof "){

        protected long getContentSize() {
            return 0L;
        }

        protected void getContent(ByteBuffer byteBuffer) {
        }

        protected void _parseDetails(ByteBuffer content) {
        }
    };
    private static Logger LOG = Logger.getLogger(BasicContainer.class);
    protected BoxParser boxParser;
    protected DataSource dataSource;
    Box lookahead = null;
    long parsePosition = 0L;
    long startPosition = 0L;
    long endPosition = 0L;
    private List<Box> boxes = new ArrayList<Box>();

    @Override
    public List<Box> getBoxes() {
        if (this.dataSource != null && this.lookahead != EOF) {
            return new LazyList<Box>(this.boxes, this);
        }
        return this.boxes;
    }

    @Override
    public void setBoxes(List<Box> boxes) {
        this.boxes = new ArrayList<Box>(boxes);
        this.lookahead = EOF;
        this.dataSource = null;
    }

    protected long getContainerSize() {
        long contentSize = 0L;
        int i = 0;
        while (i < this.getBoxes().size()) {
            contentSize += this.boxes.get(i).getSize();
            ++i;
        }
        return contentSize;
    }

    @Override
    public <T extends Box> List<T> getBoxes(Class<T> clazz) {
        ArrayList<Box> boxesToBeReturned = null;
        Box oneBox = null;
        List<Box> boxes = this.getBoxes();
        int i = 0;
        while (i < boxes.size()) {
            Box boxe = boxes.get(i);
            if (clazz.isInstance(boxe)) {
                if (oneBox == null) {
                    oneBox = boxe;
                } else {
                    if (boxesToBeReturned == null) {
                        boxesToBeReturned = new ArrayList<Box>(2);
                        boxesToBeReturned.add(oneBox);
                    }
                    boxesToBeReturned.add(boxe);
                }
            }
            ++i;
        }
        if (boxesToBeReturned != null) {
            return boxesToBeReturned;
        }
        if (oneBox != null) {
            return Collections.singletonList(oneBox);
        }
        return Collections.emptyList();
    }

    @Override
    public <T extends Box> List<T> getBoxes(Class<T> clazz, boolean recursive) {
        ArrayList<Box> boxesToBeReturned = new ArrayList<Box>(2);
        List<Box> boxes = this.getBoxes();
        int i = 0;
        while (i < boxes.size()) {
            Box boxe = boxes.get(i);
            if (clazz.isInstance(boxe)) {
                boxesToBeReturned.add(boxe);
            }
            if (recursive && boxe instanceof Container) {
                boxesToBeReturned.addAll(((Container)((Object)boxe)).getBoxes(clazz, recursive));
            }
            ++i;
        }
        return boxesToBeReturned;
    }

    public void addBox(Box box) {
        if (box != null) {
            this.boxes = new ArrayList<Box>(this.getBoxes());
            box.setParent(this);
            this.boxes.add(box);
        }
    }

    public void initContainer(DataSource dataSource, long containerSize, BoxParser boxParser) throws IOException {
        this.dataSource = dataSource;
        this.parsePosition = this.startPosition = dataSource.position();
        dataSource.position(dataSource.position() + containerSize);
        this.endPosition = dataSource.position();
        this.boxParser = boxParser;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasNext() {
        if (this.lookahead == EOF) {
            return false;
        }
        if (this.lookahead != null) {
            return true;
        }
        try {
            this.lookahead = this.next();
            return true;
        }
        catch (NoSuchElementException noSuchElementException) {
            this.lookahead = EOF;
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Box next() {
        if (this.lookahead != null && this.lookahead != EOF) {
            Box b = this.lookahead;
            this.lookahead = null;
            return b;
        }
        if (this.dataSource == null || this.parsePosition >= this.endPosition) {
            this.lookahead = EOF;
            throw new NoSuchElementException();
        }
        try {
            DataSource dataSource = this.dataSource;
            synchronized (dataSource) {
                this.dataSource.position(this.parsePosition);
                Box b = this.boxParser.parseBox(this.dataSource, this);
                this.parsePosition = this.dataSource.position();
                return b;
            }
        }
        catch (EOFException eOFException) {
            throw new NoSuchElementException();
        }
        catch (IOException iOException) {
            throw new NoSuchElementException();
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getClass().getSimpleName()).append("[");
        int i = 0;
        while (i < this.boxes.size()) {
            if (i > 0) {
                buffer.append(";");
            }
            buffer.append(this.boxes.get(i).toString());
            ++i;
        }
        buffer.append("]");
        return buffer.toString();
    }

    @Override
    public final void writeContainer(WritableByteChannel bb) throws IOException {
        for (Box box : this.getBoxes()) {
            box.getBox(bb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuffer getByteBuffer(long rangeStart, long size) throws IOException {
        if (this.dataSource != null) {
            DataSource dataSource = this.dataSource;
            synchronized (dataSource) {
                return this.dataSource.map(this.startPosition + rangeStart, size);
            }
        }
        ByteBuffer out = ByteBuffer.allocate(CastUtils.l2i(size));
        long rangeEnd = rangeStart + size;
        long boxEnd = 0L;
        Iterator<Box> iterator = this.boxes.iterator();
        while (iterator.hasNext()) {
            int length;
            long boxStart = boxEnd;
            Box box = iterator.next();
            if ((boxEnd = boxStart + box.getSize()) <= rangeStart || boxStart >= rangeEnd) continue;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            WritableByteChannel wbc = Channels.newChannel(baos);
            box.getBox(wbc);
            wbc.close();
            if (boxStart >= rangeStart && boxEnd <= rangeEnd) {
                out.put(baos.toByteArray());
                continue;
            }
            if (boxStart < rangeStart && boxEnd > rangeEnd) {
                length = CastUtils.l2i(box.getSize() - (rangeStart - boxStart) - (boxEnd - rangeEnd));
                out.put(baos.toByteArray(), CastUtils.l2i(rangeStart - boxStart), length);
                continue;
            }
            if (boxStart < rangeStart && boxEnd <= rangeEnd) {
                length = CastUtils.l2i(box.getSize() - (rangeStart - boxStart));
                out.put(baos.toByteArray(), CastUtils.l2i(rangeStart - boxStart), length);
                continue;
            }
            if (boxStart < rangeStart || boxEnd <= rangeEnd) continue;
            length = CastUtils.l2i(box.getSize() - (boxEnd - rangeEnd));
            out.put(baos.toByteArray(), 0, length);
        }
        return (ByteBuffer)out.rewind();
    }

    @Override
    public void close() throws IOException {
        this.dataSource.close();
    }
}

