/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.authoring.tracks.ttml;

import com.googlecode.mp4parser.authoring.tracks.ttml.TtmlHelpers;
import java.util.ArrayList;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TtmlSegmenter {
    public static List<Document> split(Document doc, int splitTimeInSeconds) throws XPathExpressionException {
        boolean thereIsMore;
        int splitTime = splitTimeInSeconds * 1000;
        XPathFactory xPathfactory = XPathFactory.newInstance();
        XPath xpath = xPathfactory.newXPath();
        XPathExpression xp = xpath.compile("//*[name()='p']");
        ArrayList<Document> subDocs = new ArrayList<Document>();
        do {
            long segmentStartTime = subDocs.size() * splitTime;
            long segmentEndTime = (subDocs.size() + 1) * splitTime;
            Document d = (Document)doc.cloneNode(true);
            NodeList timedNodes = (NodeList)xp.evaluate(d, XPathConstants.NODESET);
            thereIsMore = false;
            int i = 0;
            while (i < timedNodes.getLength()) {
                Node p = timedNodes.item(i);
                long startTime = TtmlHelpers.getStartTime(p);
                long endTime = TtmlHelpers.getEndTime(p);
                if (startTime < segmentStartTime && endTime > segmentStartTime) {
                    TtmlSegmenter.changeTime(p, "begin", segmentStartTime - startTime);
                    startTime = segmentStartTime;
                }
                if (startTime >= segmentStartTime && startTime < segmentEndTime && endTime > segmentEndTime) {
                    TtmlSegmenter.changeTime(p, "end", segmentEndTime - endTime);
                    startTime = segmentStartTime;
                    endTime = segmentEndTime;
                }
                if (startTime > segmentEndTime) {
                    thereIsMore = true;
                }
                if (startTime < segmentStartTime || endTime > segmentEndTime) {
                    Node parent = p.getParentNode();
                    parent.removeChild(p);
                } else {
                    TtmlSegmenter.changeTime(p, "begin", -segmentStartTime);
                    TtmlSegmenter.changeTime(p, "end", -segmentStartTime);
                }
                ++i;
            }
            TtmlSegmenter.trimWhitespace(d);
            XPathExpression bodyXP = xpath.compile("/*[name()='tt']/*[name()='body'][1]");
            Element body = (Element)bodyXP.evaluate(d, XPathConstants.NODE);
            String beginTime = body.getAttribute("begin");
            String endTime = body.getAttribute("end");
            if (beginTime == null || "".equals(beginTime)) {
                body.setAttribute("begin", TtmlHelpers.toTimeExpression(segmentStartTime));
            } else {
                TtmlSegmenter.changeTime(body, "begin", segmentStartTime);
            }
            if (endTime == null || "".equals(endTime)) {
                body.setAttribute("end", TtmlHelpers.toTimeExpression(segmentEndTime));
            } else {
                TtmlSegmenter.changeTime(body, "end", segmentEndTime);
            }
            subDocs.add(d);
        } while (thereIsMore);
        return subDocs;
    }

    public static void changeTime(Node p, String attribute, long amount) {
        if (p.getAttributes() != null && p.getAttributes().getNamedItem(attribute) != null) {
            String oldValue = p.getAttributes().getNamedItem(attribute).getNodeValue();
            long nuTime = TtmlHelpers.toTime(oldValue) + amount;
            int frames = 0;
            frames = oldValue.contains(".") ? -1 : (int)(nuTime - nuTime / 1000L * 1000L) / 44;
            p.getAttributes().getNamedItem(attribute).setNodeValue(TtmlHelpers.toTimeExpression(nuTime, frames));
        }
    }

    public static Document normalizeTimes(Document doc) throws XPathExpressionException {
        Node p;
        XPathFactory xPathfactory = XPathFactory.newInstance();
        XPath xpath = xPathfactory.newXPath();
        xpath.setNamespaceContext(TtmlHelpers.NAMESPACE_CONTEXT);
        XPathExpression xp = xpath.compile("//*[name()='p']");
        NodeList timedNodes = (NodeList)xp.evaluate(doc, XPathConstants.NODESET);
        int i = 0;
        while (i < timedNodes.getLength()) {
            p = timedNodes.item(i);
            TtmlSegmenter.pushDown(p);
            ++i;
        }
        i = 0;
        while (i < timedNodes.getLength()) {
            p = timedNodes.item(i);
            TtmlSegmenter.removeAfterPushDown(p, "begin");
            TtmlSegmenter.removeAfterPushDown(p, "end");
            ++i;
        }
        return doc;
    }

    private static void pushDown(Node p) {
        long time = 0L;
        Node current = p;
        while ((current = current.getParentNode()) != null) {
            if (current.getAttributes() == null || current.getAttributes().getNamedItem("begin") == null) continue;
            time += TtmlHelpers.toTime(current.getAttributes().getNamedItem("begin").getNodeValue());
        }
        if (p.getAttributes() != null && p.getAttributes().getNamedItem("begin") != null) {
            p.getAttributes().getNamedItem("begin").setNodeValue(TtmlHelpers.toTimeExpression(time + TtmlHelpers.toTime(p.getAttributes().getNamedItem("begin").getNodeValue())));
        }
        if (p.getAttributes() != null && p.getAttributes().getNamedItem("end") != null) {
            p.getAttributes().getNamedItem("end").setNodeValue(TtmlHelpers.toTimeExpression(time + TtmlHelpers.toTime(p.getAttributes().getNamedItem("end").getNodeValue())));
        }
    }

    private static void removeAfterPushDown(Node p, String begin) {
        Node current = p;
        while ((current = current.getParentNode()) != null) {
            if (current.getAttributes() == null || current.getAttributes().getNamedItem(begin) == null) continue;
            current.getAttributes().removeNamedItem(begin);
        }
    }

    public static void trimWhitespace(Node node) {
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeType() == 3) {
                child.setTextContent(child.getTextContent().trim());
            }
            TtmlSegmenter.trimWhitespace(child);
            ++i;
        }
    }
}

