/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.api.collections;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.solr.client.solrj.cloud.DistribStateManager;
import org.apache.solr.client.solrj.cloud.SolrCloudManager;
import org.apache.solr.client.solrj.cloud.autoscaling.AlreadyExistsException;
import org.apache.solr.client.solrj.cloud.autoscaling.BadVersionException;
import org.apache.solr.client.solrj.cloud.autoscaling.NotEmptyException;
import org.apache.solr.client.solrj.cloud.autoscaling.PolicyHelper;
import org.apache.solr.client.solrj.cloud.autoscaling.VersionedData;
import org.apache.solr.cloud.Overseer;
import org.apache.solr.cloud.api.collections.AddReplicaCmd;
import org.apache.solr.cloud.api.collections.Assign;
import org.apache.solr.cloud.api.collections.DeleteCollectionCmd;
import org.apache.solr.cloud.api.collections.OverseerCollectionMessageHandler;
import org.apache.solr.cloud.overseer.ClusterStateMutator;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.Aliases;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.ReplicaPosition;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkConfigManager;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.cloud.ZooKeeperException;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.CoreAdminParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.common.util.TimeSource;
import org.apache.solr.common.util.Utils;
import org.apache.solr.handler.admin.ConfigSetsHandlerApi;
import org.apache.solr.handler.component.ShardHandler;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.util.TimeOut;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateCollectionCmd
implements OverseerCollectionMessageHandler.Cmd {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final OverseerCollectionMessageHandler ocmh;
    private final TimeSource timeSource;
    private final DistribStateManager stateManager;

    public CreateCollectionCmd(OverseerCollectionMessageHandler ocmh) {
        this.ocmh = ocmh;
        this.stateManager = ocmh.cloudManager.getDistribStateManager();
        this.timeSource = ocmh.cloudManager.getTimeSource();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void call(ClusterState clusterState, ZkNodeProps message, NamedList results) throws Exception {
        List<ReplicaPosition> replicaPositions;
        boolean isLegacyCloud;
        ZkStateReader zkStateReader;
        String async;
        AtomicReference<PolicyHelper.SessionWrapper> sessionWrapper;
        List<String> shardNames;
        String configName;
        String withCollectionShard;
        String withCollection;
        String alias;
        boolean waitForFinalState;
        String collectionName;
        block33: {
            if (this.ocmh.zkStateReader.aliasesManager != null) {
                this.ocmh.zkStateReader.aliasesManager.update();
            }
            Aliases aliases = this.ocmh.zkStateReader.getAliases();
            collectionName = message.getStr("name");
            waitForFinalState = message.getBool("waitForFinalState", false);
            alias = message.getStr("alias", collectionName);
            log.info("Create collection {}", (Object)collectionName);
            if (clusterState.hasCollection(collectionName)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "collection already exists: " + collectionName);
            }
            if (aliases.hasAlias(collectionName)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "collection alias already exists: " + collectionName);
            }
            withCollection = message.getStr("withCollection");
            withCollectionShard = null;
            if (withCollection != null) {
                String realWithCollection = aliases.resolveSimpleAlias(withCollection);
                if (!clusterState.hasCollection(realWithCollection)) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The 'withCollection' does not exist: " + realWithCollection);
                }
                DocCollection collection = clusterState.getCollection(realWithCollection);
                if (collection.getActiveSlices().size() > 1) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The `withCollection` must have only one shard, found: " + collection.getActiveSlices().size());
                }
                withCollectionShard = ((Slice)collection.getActiveSlices().iterator().next()).getName();
            }
            if ((configName = this.getConfigName(collectionName, message)) == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No config set found to associate with the collection.");
            }
            this.ocmh.validateConfigOrThrowSolrException(configName);
            String router = message.getStr("router.name", "compositeId");
            shardNames = CreateCollectionCmd.populateShardNames(message, router);
            CreateCollectionCmd.checkReplicaTypes(message);
            sessionWrapper = new AtomicReference<PolicyHelper.SessionWrapper>();
            async = message.getStr("async");
            zkStateReader = this.ocmh.zkStateReader;
            isLegacyCloud = Overseer.isLegacy(zkStateReader);
            OverseerCollectionMessageHandler.createConfNode(this.stateManager, configName, collectionName, isLegacyCloud);
            HashMap<String, String> collectionParams = new HashMap<String, String>();
            Map collectionProps = message.getProperties();
            for (Map.Entry entry : collectionProps.entrySet()) {
                String propName = (String)entry.getKey();
                if (!propName.startsWith("collection.")) continue;
                collectionParams.put(propName.substring("collection.".length()), (String)entry.getValue());
            }
            CreateCollectionCmd.createCollectionZkNode(this.stateManager, collectionName, collectionParams);
            this.ocmh.overseer.offerStateUpdate(Utils.toJSON((Object)message));
            TimeOut waitUntil = new TimeOut(30L, TimeUnit.SECONDS, this.timeSource);
            boolean created = false;
            while (!waitUntil.hasTimedOut()) {
                waitUntil.sleep(100L);
                created = this.ocmh.cloudManager.getClusterStateProvider().getClusterState().hasCollection(collectionName);
                if (!created) continue;
            }
            if (!created) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not fully create collection: " + collectionName);
            }
            clusterState = this.ocmh.cloudManager.getClusterStateProvider().getClusterState();
            replicaPositions = null;
            try {
                replicaPositions = CreateCollectionCmd.buildReplicaPositions(this.ocmh.cloudManager, clusterState, clusterState.getCollection(collectionName), message, shardNames, sessionWrapper);
            }
            catch (Assign.AssignmentException e) {
                ZkNodeProps deleteMessage = new ZkNodeProps(new String[]{"name", collectionName});
                new DeleteCollectionCmd(this.ocmh).call(clusterState, deleteMessage, results);
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, e.getMessage(), e.getCause());
            }
            if (!replicaPositions.isEmpty()) break block33;
            log.debug("Finished create command for collection: {}", (Object)collectionName);
            if (sessionWrapper.get() == null) return;
            sessionWrapper.get().release();
            return;
        }
        try {
            boolean bl;
            boolean failure;
            OverseerCollectionMessageHandler.ShardRequestTracker shardRequestTracker = this.ocmh.asyncRequestTracker(async);
            if (log.isDebugEnabled()) {
                log.debug(StrUtils.formatString((String)"Creating SolrCores for new collection {0}, shardNames {1} , message : {2}", (Object[])new Object[]{collectionName, shardNames, message}));
            }
            LinkedHashMap<String, ShardRequest> coresToCreate = new LinkedHashMap<String, ShardRequest>();
            ShardHandler shardHandler = this.ocmh.shardHandlerFactory.getShardHandler(this.ocmh.overseer.getCoreContainer().getUpdateShardHandler().getDefaultHttpClient());
            for (ReplicaPosition replicaPosition : replicaPositions) {
                ZkNodeProps props;
                DocCollection collection;
                List replicas;
                String string = replicaPosition.node;
                if (withCollection != null && ((replicas = (collection = clusterState.getCollection(withCollection)).getReplicas(string)) == null || replicas.isEmpty())) {
                    props = new ZkNodeProps(new String[]{"operation", CollectionParams.CollectionAction.ADDREPLICA.toString(), "collection", withCollection, "shard", withCollectionShard, "node", string, "waitForFinalState", Boolean.TRUE.toString()});
                    new AddReplicaCmd(this.ocmh).call(clusterState, props, results);
                    clusterState = zkStateReader.getClusterState();
                }
                String coreName = Assign.buildSolrCoreName(this.ocmh.cloudManager.getDistribStateManager(), this.ocmh.cloudManager.getClusterStateProvider().getClusterState().getCollection(collectionName), replicaPosition.shard, replicaPosition.type, true);
                if (log.isDebugEnabled()) {
                    log.debug(StrUtils.formatString((String)"Creating core {0} as part of shard {1} of collection {2} on {3}", (Object[])new Object[]{coreName, replicaPosition.shard, collectionName, string}));
                }
                String baseUrl = zkStateReader.getBaseUrlForNodeName(string);
                if (!isLegacyCloud) {
                    props = new ZkNodeProps(new String[]{"operation", CollectionParams.CollectionAction.ADDREPLICA.toString(), "collection", collectionName, "shard", replicaPosition.shard, "core", coreName, "state", Replica.State.DOWN.toString(), "base_url", baseUrl, "node_name", string, "type", replicaPosition.type.name(), "waitForFinalState", Boolean.toString(waitForFinalState)});
                    this.ocmh.overseer.offerStateUpdate(Utils.toJSON((Object)props));
                }
                ModifiableSolrParams params = new ModifiableSolrParams();
                params.set("action", new String[]{CoreAdminParams.CoreAdminAction.CREATE.toString()});
                params.set("name", new String[]{coreName});
                params.set("collection.configName", new String[]{configName});
                params.set("collection", new String[]{collectionName});
                params.set("shard", new String[]{replicaPosition.shard});
                params.set("numShards", shardNames.size());
                params.set("newCollection", new String[]{"true"});
                params.set("replicaType", new String[]{replicaPosition.type.name()});
                if (async != null) {
                    String coreAdminAsyncId = async + Math.abs(System.nanoTime());
                    params.add("async", new String[]{coreAdminAsyncId});
                    shardRequestTracker.track(string, coreAdminAsyncId);
                }
                this.ocmh.addPropertyParams(message, params);
                ShardRequest sreq = new ShardRequest();
                sreq.nodeName = string;
                params.set("qt", new String[]{this.ocmh.adminPath});
                sreq.purpose = 1;
                sreq.shards = new String[]{baseUrl};
                sreq.actualShards = sreq.shards;
                sreq.params = params;
                if (isLegacyCloud) {
                    shardHandler.submit(sreq, sreq.shards[0], sreq.params);
                    continue;
                }
                coresToCreate.put(coreName, sreq);
            }
            if (!isLegacyCloud) {
                Map<String, Replica> replicas = this.ocmh.waitToSeeReplicasInState(collectionName, coresToCreate.keySet());
                for (Map.Entry entry : coresToCreate.entrySet()) {
                    ShardRequest sreq = (ShardRequest)entry.getValue();
                    sreq.params.set("coreNodeName", new String[]{replicas.get(entry.getKey()).getName()});
                    shardHandler.submit(sreq, sreq.shards[0], sreq.params);
                }
            }
            shardRequestTracker.processResponses((NamedList<Object>)results, shardHandler, false, null, Collections.emptySet());
            boolean bl2 = failure = results.get("failure") != null && ((SimpleOrderedMap)results.get("failure")).size() > 0;
            if (failure) {
                this.ocmh.cleanupCollection(collectionName, new NamedList());
                log.info("Cleaned up artifacts for failed create collection for [{}]", (Object)collectionName);
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Underlying core creation failed while creating collection: " + collectionName);
            }
            log.debug("Finished create command on all shards for collection: {}", (Object)collectionName);
            boolean bl3 = bl = message.getStr("collection.configName") == null || message.getStr("collection.configName").equals("_default");
            if (bl) {
                results.add("warning", (Object)("Using _default configset. Data driven schema functionality is enabled by default, which is NOT RECOMMENDED for production use. To turn it off: curl http://{host:port}/solr/" + collectionName + "/config -d '{\"set-user-property\": {\"update.autoCreateFields\":\"false\"}}'"));
            }
            if (withCollection != null) {
                ZkNodeProps zkNodeProps = new ZkNodeProps(new String[]{"operation", CollectionParams.CollectionAction.MODIFYCOLLECTION.toString(), "collection", withCollection, "COLOCATED_WITH", collectionName});
                this.ocmh.overseer.offerStateUpdate(Utils.toJSON((Object)zkNodeProps));
                try {
                    zkStateReader.waitForState(withCollection, 5L, TimeUnit.SECONDS, collectionState -> collectionName.equals(collectionState.getStr("COLOCATED_WITH")));
                }
                catch (TimeoutException timeoutException) {
                    log.warn("Timed out waiting to see the {} property set on collection: {}", (Object)"COLOCATED_WITH", (Object)withCollection);
                }
            }
            if (!alias.equals(collectionName)) {
                this.ocmh.zkStateReader.aliasesManager.applyModificationAndExportToZk(a -> a.cloneWithCollectionAlias(alias, collectionName));
            }
            if (sessionWrapper.get() == null) return;
        }
        catch (SolrException ex) {
            try {
                throw ex;
                catch (Exception ex2) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, null, (Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                if (sessionWrapper.get() == null) throw throwable;
                ((PolicyHelper.SessionWrapper)sessionWrapper.get()).release();
                throw throwable;
            }
        }
        sessionWrapper.get().release();
        return;
    }

    public static List<ReplicaPosition> buildReplicaPositions(SolrCloudManager cloudManager, ClusterState clusterState, DocCollection docCollection, ZkNodeProps message, List<String> shardNames, AtomicReference<PolicyHelper.SessionWrapper> sessionWrapper) throws IOException, InterruptedException, Assign.AssignmentException {
        List<ReplicaPosition> replicaPositions;
        List<String> nodeList;
        String collectionName = message.getStr("name");
        int numTlogReplicas = message.getInt("tlogReplicas", Integer.valueOf(0));
        int numNrtReplicas = message.getInt("nrtReplicas", message.getInt("replicationFactor", Integer.valueOf(numTlogReplicas > 0 ? 0 : 1)));
        int numPullReplicas = message.getInt("pullReplicas", Integer.valueOf(0));
        int numSlices = shardNames.size();
        int maxShardsPerNode = message.getInt("maxShardsPerNode", Integer.valueOf(1));
        if (maxShardsPerNode == -1) {
            maxShardsPerNode = Integer.MAX_VALUE;
        }
        if ((nodeList = Assign.getLiveOrLiveAndCreateNodeSetList(clusterState.getLiveNodes(), message, OverseerCollectionMessageHandler.RANDOM)).isEmpty()) {
            log.warn("It is unusual to create a collection ({}) without cores.", (Object)collectionName);
            replicaPositions = new ArrayList<ReplicaPosition>();
        } else {
            int requestedShardsToCreate;
            int maxShardsAllowedToCreate;
            int totalNumReplicas = numNrtReplicas + numTlogReplicas + numPullReplicas;
            if (totalNumReplicas > nodeList.size()) {
                log.warn("Specified number of replicas of {} on collection {} is higher than the number of Solr instances currently live or live and part of your {}({}). {}", new Object[]{totalNumReplicas, collectionName, "createNodeSet", nodeList.size(), "It's unusual to run two replica of the same slice on the same Solr-instance."});
            }
            if ((maxShardsAllowedToCreate = maxShardsPerNode == Integer.MAX_VALUE ? Integer.MAX_VALUE : maxShardsPerNode * nodeList.size()) < (requestedShardsToCreate = numSlices * totalNumReplicas)) {
                throw new Assign.AssignmentException("Cannot create collection " + collectionName + ". Value of " + "maxShardsPerNode" + " is " + maxShardsPerNode + ", and the number of nodes currently live or live and part of your " + "createNodeSet" + " is " + nodeList.size() + ". This allows a maximum of " + maxShardsAllowedToCreate + " to be created. Value of " + "numShards" + " is " + numSlices + ", value of " + "nrtReplicas" + " is " + numNrtReplicas + ", value of " + "tlogReplicas" + " is " + numTlogReplicas + " and value of " + "pullReplicas" + " is " + numPullReplicas + ". This requires " + requestedShardsToCreate + " shards to be created (higher than the allowed number)");
            }
            Assign.AssignRequest assignRequest = new Assign.AssignRequestBuilder().forCollection(collectionName).forShard(shardNames).assignNrtReplicas(numNrtReplicas).assignTlogReplicas(numTlogReplicas).assignPullReplicas(numPullReplicas).onNodes(nodeList).build();
            Assign.AssignStrategyFactory assignStrategyFactory = new Assign.AssignStrategyFactory(cloudManager);
            Assign.AssignStrategy assignStrategy = assignStrategyFactory.create(clusterState, docCollection);
            replicaPositions = assignStrategy.assign(cloudManager, assignRequest);
            sessionWrapper.set(PolicyHelper.getLastSessionWrapper((boolean)true));
        }
        return replicaPositions;
    }

    public static void checkReplicaTypes(ZkNodeProps message) {
        int numTlogReplicas = message.getInt("tlogReplicas", Integer.valueOf(0));
        int numNrtReplicas = message.getInt("nrtReplicas", message.getInt("replicationFactor", Integer.valueOf(numTlogReplicas > 0 ? 0 : 1)));
        if (numNrtReplicas + numTlogReplicas <= 0) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "nrtReplicas + tlogReplicas must be greater than 0");
        }
    }

    public static List<String> populateShardNames(ZkNodeProps message, String router) {
        ArrayList<String> shardNames = new ArrayList<String>();
        Integer numSlices = message.getInt("numShards", null);
        if ("implicit".equals(router)) {
            ClusterStateMutator.getShardNames(shardNames, message.getStr("shards", null));
            numSlices = shardNames.size();
        } else {
            if (numSlices == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "numShards is a required param (when using CompositeId router).");
            }
            if (numSlices <= 0) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "numShards must be > 0");
            }
            ClusterStateMutator.getShardNames(numSlices, shardNames);
        }
        return shardNames;
    }

    String getConfigName(String coll, ZkNodeProps message) throws KeeperException, InterruptedException {
        String configName = message.getStr("collection.configName");
        if (configName == null) {
            List configNames = null;
            try {
                configNames = this.ocmh.zkStateReader.getZkClient().getChildren("/configs", null, true);
                if (configNames.contains("_default")) {
                    if (".system".equals(coll)) {
                        return coll;
                    }
                    String intendedConfigSetName = ConfigSetsHandlerApi.getSuffixedNameForAutoGeneratedConfigSet(coll);
                    this.copyDefaultConfigSetTo(configNames, intendedConfigSetName);
                    return intendedConfigSetName;
                }
                if (configNames != null && configNames.size() == 1) {
                    configName = (String)configNames.get(0);
                    log.info("Only one config set found in zk - using it: {}", (Object)configName);
                }
            }
            catch (KeeperException.NoNodeException noNodeException) {
                // empty catch block
            }
        }
        return "".equals(configName) ? null : configName;
    }

    private void copyDefaultConfigSetTo(List<String> configNames, String targetConfig) {
        ZkConfigManager configManager = new ZkConfigManager(this.ocmh.zkStateReader.getZkClient());
        if (configNames.contains(targetConfig)) {
            log.info("There exists a configset by the same name as the collection we're trying to create: {}, re-using it.", (Object)targetConfig);
            return;
        }
        try {
            configManager.copyConfigDir("_default", targetConfig, new HashSet());
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.INVALID_STATE, "Error while copying _default to " + targetConfig, (Throwable)e);
        }
    }

    public static void createCollectionZkNode(DistribStateManager stateManager, String collection, Map<String, String> params) {
        block22: {
            log.debug("Check for collection zkNode: {}", (Object)collection);
            String collectionPath = "/collections/" + collection;
            String termsPath = "/collections/" + collection + "/terms";
            try {
                stateManager.removeRecursively(termsPath, true, true);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error deleting old term nodes for collection from Zookeeper", (Throwable)e);
            }
            catch (IOException | BadVersionException | NotEmptyException | KeeperException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error deleting old term nodes for collection from Zookeeper", e);
            }
            try {
                if (!stateManager.hasData(collectionPath)) {
                    log.debug("Creating collection in ZooKeeper: {}", (Object)collection);
                    try {
                        HashMap<String, Object> collectionProps = new HashMap<String, Object>();
                        if (params.size() > 0) {
                            collectionProps.putAll(params);
                            if (!collectionProps.containsKey("configName")) {
                                CreateCollectionCmd.getConfName(stateManager, collection, collectionPath, collectionProps);
                            }
                        } else if (System.getProperty("bootstrap_confdir") != null) {
                            String defaultConfigName = System.getProperty("collection.configName", collection);
                            log.info("Setting config for collection: {} to {}", (Object)collection, (Object)defaultConfigName);
                            Properties sysProps = System.getProperties();
                            for (String sprop : System.getProperties().stringPropertyNames()) {
                                if (!sprop.startsWith("collection.")) continue;
                                collectionProps.put(sprop.substring("collection.".length()), sysProps.getProperty(sprop));
                            }
                            if (!collectionProps.containsKey("configName")) {
                                collectionProps.put("configName", defaultConfigName);
                            }
                        } else if (Boolean.getBoolean("bootstrap_conf")) {
                            collectionProps.put("configName", collection);
                        } else {
                            CreateCollectionCmd.getConfName(stateManager, collection, collectionPath, collectionProps);
                        }
                        collectionProps.remove("numShards");
                        ZkNodeProps zkProps = new ZkNodeProps(collectionProps);
                        stateManager.makePath(collectionPath, Utils.toJSON((Object)zkProps), CreateMode.PERSISTENT, false);
                        break block22;
                    }
                    catch (KeeperException e) {
                        if (e.code() != KeeperException.Code.NODEEXISTS) {
                            throw e;
                        }
                        break block22;
                    }
                    catch (AlreadyExistsException e) {
                        break block22;
                    }
                }
                log.debug("Collection zkNode exists");
            }
            catch (KeeperException e) {
                if (e.code() == KeeperException.Code.NODEEXISTS) {
                    return;
                }
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error creating collection node in Zookeeper", (Throwable)e);
            }
            catch (IOException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error creating collection node in Zookeeper", (Throwable)e);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error creating collection node in Zookeeper", (Throwable)e);
            }
        }
    }

    private static void getConfName(DistribStateManager stateManager, String collection, String collectionPath, Map<String, Object> collectionProps) throws IOException, KeeperException, InterruptedException {
        VersionedData data;
        ZkNodeProps cProps;
        int retry;
        log.debug("Looking for collection configName");
        if (collectionProps.containsKey("configName")) {
            if (log.isInfoEnabled()) {
                log.info("configName was passed as a param {}", collectionProps.get("configName"));
            }
            return;
        }
        List configNames = null;
        int retryLimt = 6;
        for (retry = 1; !(retry >= retryLimt || stateManager.hasData(collectionPath) && (cProps = ZkNodeProps.load((byte[])(data = stateManager.getData(collectionPath)).getData())).containsKey("configName")); ++retry) {
            try {
                configNames = stateManager.listData("/configs");
            }
            catch (NoSuchElementException | KeeperException.NoNodeException throwable) {
                // empty catch block
            }
            if (configNames != null && configNames.contains(collection)) {
                log.info("Could not find explicit collection configName, but found config name matching collection name - using that set.");
                collectionProps.put("configName", collection);
                break;
            }
            if (configNames != null && configNames.contains("_default")) {
                log.info("Could not find explicit collection configName, but found _default config set - using that set.");
                collectionProps.put("configName", "_default");
                break;
            }
            if (configNames != null && configNames.size() == 1) {
                if (log.isInfoEnabled()) {
                    log.info("Only one config set found in zk - using it: {}", configNames.get(0));
                }
                collectionProps.put("configName", configNames.get(0));
                break;
            }
            log.info("Could not find collection configName - pausing for 3 seconds and trying again - try: {}", (Object)retry);
            Thread.sleep(3000L);
        }
        if (retry == retryLimt) {
            log.error("Could not find configName for collection {}", (Object)collection);
            throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "Could not find configName for collection " + collection + " found:" + configNames);
        }
    }
}

