/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.metrics.reporters;

import java.io.Closeable;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReporterClientCache<T>
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Map<String, T> cache = new ConcurrentHashMap<String, T>();

    public synchronized T getOrCreate(String id, ClientProvider<T> clientProvider) {
        T item = this.cache.get(id);
        if (item == null) {
            try {
                item = clientProvider.get();
                this.cache.put(id, item);
            }
            catch (Exception e) {
                log.warn("Error providing a new client for id={}", (Object)id, (Object)e);
                item = null;
            }
        }
        return item;
    }

    @Override
    public void close() {
        for (T client : this.cache.values()) {
            if (!(client instanceof Closeable)) continue;
            try {
                ((Closeable)client).close();
            }
            catch (Exception e) {
                log.warn("Error closing client {}, ignoring...", client, (Object)e);
            }
        }
        this.cache.clear();
    }

    public static interface ClientProvider<T> {
        public T get() throws Exception;
    }
}

