/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.stats;

import org.apache.lucene.index.Term;
import org.apache.lucene.search.TermStatistics;
import org.apache.solr.search.stats.StatsUtil;

public class TermStats {
    public final String term;
    public long docFreq;
    public long totalTermFreq;
    private final Term t;

    public TermStats(String term) {
        this.term = term;
        this.t = this.makeTerm(term);
    }

    private Term makeTerm(String s) {
        int idx = s.indexOf(58);
        if (idx == -1) {
            return null;
        }
        return new Term(s.substring(0, idx), s.substring(idx + 1));
    }

    public TermStats(String term, long docFreq, long totalTermFreq) {
        this(term);
        this.docFreq = docFreq;
        this.totalTermFreq = totalTermFreq;
    }

    public TermStats(String field, TermStatistics stats) {
        this.term = field + ":" + stats.term().utf8ToString();
        this.t = new Term(field, stats.term());
        this.docFreq = stats.docFreq();
        this.totalTermFreq = stats.totalTermFreq();
    }

    public void add(TermStats stats) {
        this.docFreq += stats.docFreq;
        this.totalTermFreq += stats.totalTermFreq;
    }

    public TermStatistics toTermStatistics() {
        if (this.docFreq == 0L) {
            return null;
        }
        return new TermStatistics(this.t.bytes(), this.docFreq, this.totalTermFreq);
    }

    public String toString() {
        return StatsUtil.termStatsToString(this, false);
    }
}

